/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.syslogng.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.syslogng.bean.LogFilterInfo;
import com.clustercontrol.syslogng.ejb.session.SyslogNGController;
import com.clustercontrol.syslogng.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * 륯饹Ǥ
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class LogManager {

    // ----- static ե ----- //

    /** ͣΥ󥹥 */
    private static LogManager INSTANCE = null;

    // ----- static ᥽å ----- //

    /**
     * ͣΥ󥹥󥹤֤ޤ
     * 
     * @return 󥹥
     */
    public static LogManager getInstance() {
        if (INSTANCE == null) {
            synchronized (LogManager.class) {
                if (INSTANCE == null) {
                    INSTANCE = new LogManager();
                }
            }
        }

        return INSTANCE;
    }

    // ----- instance ե ----- //

    /** Υå */
    private Map cashe = null;

    /** ꥹ */
    private List orderList = null;

    /** ǿ */
    private volatile int size = 0;

    // ----- 󥹥ȥ饯 ----- //

    /**
     * ػߤޤ
     */
    private LogManager() {
    }

    public void initialize() {
        this.loadLog();
    }

    // ----- instance ᥽å ----- //

    /**
     * ƤΥ֤ޤ
     * 
     * @return 
     */
    public Object[] get() {

        Object[] records = this.orderList.toArray();
        return records;
    }

    /**
     * ꤷ֤ޤ
     * 
     * @param logId
     *            ID
     * @return 
     */
    public LogFilterInfo get(String logId) {
        return (LogFilterInfo) this.cashe.get(logId);
    }

    /**
     * ɲäޤ
     * <p>
     * 
     * ȥIDϼưŪ˳Ƥޤ
     * 
     * @param log
     *            
     * @return 硢true
     */
    public boolean add(LogFilterInfo log) {
        int order = this.cashe.size() + 1;

        // ϰָȤ롣
        log.setOrderNo(order);
        // ΥID򿶤ʬ롣
        log.setLogId("newLog" + order);

        this.cashe.put(log.getLogId(), log);
        this.orderList.add(log);
        return true;
    }

    /**
     * ѹޤ
     * 
     * @param log
     * @return 硢true
     */
    public boolean modify(LogFilterInfo log) {
        if (!this.cashe.containsKey(log.getLogId())) {
            return false;
        }

        this.cashe.put(log.getLogId(), log);
        this.orderList.set(log.getOrderNo() - 1, log);

        return true;
    }

    /**
     * ޤ
     * 
     * @param logId
     *            ID
     * @return 硢true
     */
    public boolean delete(String logId) {
        if (!this.cashe.containsKey(logId)) {
            return false;
        }

        LogFilterInfo log = (LogFilterInfo) this.cashe.remove(logId);

        this.orderList.remove(log.getOrderNo() - 1);

        // Ƥʤޤ
        int order = 0;
        Iterator ite = this.orderList.iterator();
        while (ite.hasNext()) {
            ((LogFilterInfo) ite.next()).setOrderNo(++order);
        }

        return true;
    }

    /**
     * ꤷν̤ҤȤľ夲ޤ
     * 
     * @param logId
     *            ID
     * @return 硢true
     */
    public boolean upOrder(String logId) {
        if (!this.cashe.containsKey(logId)) {
            return false;
        }

        LogFilterInfo log = (LogFilterInfo) this.cashe.get(logId);
        int oldOrder = log.getOrderNo();
        int newOrder = oldOrder - 1;
        if (newOrder < 1) {
            return false;
        }

        return this.change(oldOrder, newOrder);
    }

    /**
     * ꤷν̤ҤȤĲޤ
     * 
     * @param logId
     *            ID
     * @return 硢true
     */
    public boolean downOrder(String logId) {
        if (!this.cashe.containsKey(logId)) {
            return false;
        }

        LogFilterInfo log = (LogFilterInfo) this.cashe.get(logId);
        int oldOrder = log.getOrderNo();
        int newOrder = oldOrder + 1;
        if (newOrder > this.cashe.size()) {
            return false;
        }

        return this.change(oldOrder, newOrder);
    }

    /**
     * ޤǤƤꤷޤ
     * 
     * @return 硢true
     */
    public boolean commit() {

        SyslogNGController syslog = EjbConnectionManager.getConnectionManager()
                .getSyslogNGController();

        try {
            return syslog.createMonitorRuleList((ArrayList) this.orderList);
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// ʤξ硢顼ɽ
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        } catch (CreateException e) {
        } catch (RemoveException e) {
        } catch (FinderException e) {
        } catch (NamingException e) {
        }
        return true;
    }

    /**
     * ޤǤƤ򥭥󥻥뤷ޤ
     * 
     * @return 硢true
     */
    public boolean rollback() {
        // å򥯥ꥢ
        this.loadLog();

        return true;
    }

    /**
     * ɤޤ
     */
    private void loadLog() {
        this.cashe = new HashMap();
        this.orderList = new ArrayList();

        SyslogNGController syslog = EjbConnectionManager.getConnectionManager()
                .getSyslogNGController();

        ArrayList records = new ArrayList();
        try {
            records = syslog.getFilterInfoList();
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// ʤξ硢顼ɽ
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        } catch (CreateException e) {
        } catch (FinderException e) {
        } catch (NamingException e) {
        }

        int index = 0;
        Iterator ite = records.iterator();
        while (ite.hasNext()) {
        	Object o = ite.next();
            LogFilterInfo log = (LogFilterInfo)o;

            log.setLogId("newLog" + index);
            this.cashe.put(log.getLogId(), log);
            this.orderList.add(log);
            index++;
        }
    }

    /**
     * ꤷƱΤν̤ؤޤ
     * <p>
     * 
     * ꤹͤϡListΥǥåͤǤϤʤνꤷƲ
     * 
     * @param index1
     *            ν
     * @param index2
     *            ν
     * @return ˽λ硢true
     */
    private boolean change(int index1, int index2) {
        LogFilterInfo log1 = (LogFilterInfo) this.orderList.get(--index1);
        LogFilterInfo log2 = (LogFilterInfo) this.orderList.get(--index2);

        int order1 = log1.getOrderNo();
        int order2 = log2.getOrderNo();

        // ͤؤޤ
        log1.setOrderNo(order2);
        log2.setOrderNo(order1);

        // ꥹȤΰ֤ؤޤ
        this.orderList.set(index1, log2);
        this.orderList.set(index2, log1);

        return true;
    }
}