/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.syslogng.factory;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.syslogng.bean.TopicConstant;
import com.clustercontrol.syslogng.message.UpdateMonitorRuleInfo;
import com.clustercontrol.syslogng.util.SendTopic;
import com.clustercontrol.syslogng.bean.LogFilterInfo;
import com.clustercontrol.syslogng.ejb.entity.SyslogMonitorRuleLocal;
import com.clustercontrol.syslogng.ejb.entity.SyslogMonitorRuleLocalHome;
import com.clustercontrol.syslogng.ejb.entity.SyslogMonitorRuleUtil;
import com.clustercontrol.util.apllog.AplLogger;


/**
 * ƻϿ饹
 *
 * @version 2.1.0
 * @since 1.0.0
 */
public class ModifyMonitorRule {
	
	protected static Log m_log = LogFactory.getLog( ModifyMonitorRule.class );
	
	/**
	 * ƻ
	 * 
	 * @param list ե륿ꥹ
	 * @param user 桼
	 * @return
	 * @throws CreateException
	 * @throws NamingException
	 * @version 2.1.0
	 * @since 1.0.0
	 */
	public boolean createMonitorRule(ArrayList list, String user) throws CreateException, NamingException {
    	//å
    	AccessLock.lock(AccessLock.MONITOR_SYSLOG);
    	
		if(list == null){
			return true;
		}
		
		try
		{
			SyslogMonitorRuleLocalHome monitorRuleHome = SyslogMonitorRuleUtil.getLocalHome();
			SyslogMonitorRuleLocal monitorRule = null;
			
			Timestamp regDate = null;
			Timestamp updateDate = new Timestamp(new Date().getTime());
			
			String regUser = null;

			for(int index=0; index<list.size(); index++){
				
				if(list.get(index) instanceof LogFilterInfo){
					
					LogFilterInfo filterInfo = (LogFilterInfo)list.get(index);
					
					if(filterInfo.getRegDate() != null){
						regDate = new Timestamp(filterInfo.getRegDate().getTime());
					}
					else{
						regDate = updateDate;
					}
					
					if(filterInfo.getRegUser() != null && !"".equals(filterInfo.getRegUser().trim())){
						regUser = filterInfo.getRegUser();
					}
					else{
						regUser = user;
					}
					
					monitorRule = monitorRuleHome.create(
							new Integer(filterInfo.getOrderNo()),
							filterInfo.getDescription(),
							filterInfo.getFacilityId(),
							filterInfo.getPattern(),
							new Integer(filterInfo.getProcessType()),
							new Integer(filterInfo.getPriority()),
							filterInfo.getMonitorId(),
							filterInfo.getApplication(),
							filterInfo.getMessageId(),
							filterInfo.getMessage(),
							filterInfo.getNotifyId(),
							filterInfo.getCalendarId(),
							Integer.valueOf(filterInfo.getJobRun()),
							filterInfo.getJobId(),
							Integer.valueOf(filterInfo.getJobInhibitionFlg()),
							Integer.valueOf(filterInfo.getJobFailurePriority()),
							new Integer(ValidConstant.booleanToType(filterInfo.isValidFlg())),
							regDate,
							updateDate,
							regUser,
							user
							);
				}
			}
			
			try {
				//Topic
				SendTopic send = new SendTopic(TopicConstant.TOPIC_NAME_EXECUTE);
				send.put(new UpdateMonitorRuleInfo());
			} catch (Exception e) {
				m_log.debug("createMonitorRule() : 顼 : " + e.getMessage());
			}
			
			return true;
			
		} catch (CreateException e) {
            AplLogger apllog = new AplLogger("SLOGNG", "slogng");
            String[] args = {"insert"};
            apllog.put("SYS", "002", args);
			m_log.debug("createMonitorRule():" + e.getMessage());
			throw e;
		} catch (NamingException e) {
            AplLogger apllog = new AplLogger("SLOGNG", "slogng");
            String[] args = {"insert"};
            apllog.put("SYS", "002", args);
			m_log.debug("createMonitorRule():" + e.getMessage());
			throw e;
		}
	}
	
	/**
	 * ƻ
	 * 
	 * @return
	 * @throws RemoveException
	 * @throws FinderException
	 * @throws NamingException
	 */
	public boolean deleteMonitorRule() throws RemoveException, FinderException, NamingException {
    	//å
    	AccessLock.lock(AccessLock.MONITOR_SYSLOG);
    	
		try 
		{
			SyslogMonitorRuleLocalHome moniterRuleHome = SyslogMonitorRuleUtil.getLocalHome();
			
			// ƻ
			Collection ct = moniterRuleHome.findAll();
			
			Iterator itr = ct.iterator();
			while(itr.hasNext())
			{
				SyslogMonitorRuleLocal moniterRule = (SyslogMonitorRuleLocal)itr.next();
				// ƻ
				moniterRuleHome.remove(moniterRule.getPrimaryKey());
			}
			return true;
			
		} catch (RemoveException e) {
            AplLogger apllog = new AplLogger("SLOGNG", "slogng");
            String[] args = {"delete"};
            apllog.put("SYS", "002", args);
			m_log.debug("createMonitorRule():" + e.getMessage());
			throw e;
		} catch (FinderException e) {
            AplLogger apllog = new AplLogger("SLOGNG", "slogng");
            String[] args = {"delete"};
            apllog.put("SYS", "002", args);
			m_log.debug("createMonitorRule():" + e.getMessage());
			throw e;
		} catch (NamingException e) {
            AplLogger apllog = new AplLogger("SLOGNG", "slogng");
            String[] args = {"delete"};
            apllog.put("SYS", "002", args);
			m_log.debug("createMonitorRule():" + e.getMessage());
			throw e;
		}
	}
}
