/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.syslogng.dialog;

import java.util.ArrayList;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.syslogng.action.LogManager;
import com.clustercontrol.syslogng.bean.LogFilterInfo;
import com.clustercontrol.syslogng.composite.LogListComposite;
import com.clustercontrol.util.Messages;

/**
 * 饹Ǥ
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class LogListDialog extends CommonDialog {

    // ----- instance ե ----- //

    /**  */
    private LogListComposite logList = null;

    /** ɲåܥ */
    private Button buttonAdd = null;

    /** ѹܥ */
    private Button buttonModify = null;

    /** ܥ */
    private Button buttonDelete = null;

    /** ܥ */
    private Button buttonUp = null;

    /** ܥ */
    private Button buttonDown = null;

    /** ͭܥ */
    private Button buttonValid = null;
    
    /** ̵ܥ */
    private Button buttonInvalid = null;
    
    // ----- 󥹥ȥ饯 ----- //

    /**
     * Υ󥹥󥹤֤ޤ
     * 
     * @param parent
     *            ƤΥ륪֥
     */
    public LogListDialog(Shell parent) {
        super(parent);
        setShellStyle(getShellStyle() | SWT.RESIZE | SWT.MAX);
    }

    // ----- instance ᥽å ----- //

    /**
     * ν֤ޤ
     * 
     * @return 
     */
    protected Point getInitialSize() {
        return new Point(800, 420);
    }

    /**
     * ꥢޤ
     * 
     * @param parent
     *            ƤΥ󥹥
     */
    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();

        // ȥ
        shell.setText(Messages.getString("dialog.syslog-ng.list"));

        // 쥤
        GridLayout layout = new GridLayout(8, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 8;
        parent.setLayout(layout);

        /*
         * 
         */

        this.logList = new LogListComposite(parent, SWT.BORDER);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 7;
        this.logList.setLayoutData(gridData);

        /*
         * ܥ
         */

        Composite composite = new Composite(parent, SWT.NONE);
        layout = new GridLayout(1, true);
        layout.numColumns = 1;
        composite.setLayout(layout);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        composite.setLayoutData(gridData);

        // ɲåܥ
        this.buttonAdd = this
                .createButton(composite, Messages.getString("add"));
        this.buttonAdd.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
                LogCreateDialog dialog = new LogCreateDialog(getParentShell());
                if (dialog.open() == IDialogConstants.OK_ID) {
                    LogManager.getInstance().add(dialog.getInputData());
                    logList.update();
                }
            }
        });

        // ѹܥ
        Label dummy = new Label(composite, SWT.NONE);
        this.buttonModify = this.createButton(composite, Messages
                .getString("modify"));
        this.buttonModify.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
                String logId = getSelectLogId();
                if (logId != null) {
                    LogCreateDialog dialog = new LogCreateDialog(
                            getParentShell(), logId);
                    if (dialog.open() == IDialogConstants.OK_ID) {
                        Table table = logList.getTableViewer().getTable();
                        int selectIndex = table.getSelectionIndex();
                        LogManager.getInstance().modify(dialog.getInputData());
                        logList.update();
                        table.setSelection(selectIndex);
                    }
                }
                else{
                	MessageBox box = new MessageBox(getShell(), SWT.OK | SWT.ICON_WARNING);
                    box.setText(Messages.getString("warning"));
                    box.setMessage(Messages.getString("message.monitor.1"));
                    box.open();
                }
            }
        });

        // ܥ
        dummy = new Label(composite, SWT.NONE);
        this.buttonDelete = this.createButton(composite, Messages
                .getString("delete"));
        this.buttonDelete.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
                LogFilterInfo filterInfo = logList.getFilterItem();

                if (filterInfo != null) {
                    String monitorId = filterInfo.getMonitorId();

                    MessageBox box = new MessageBox(getShell(), SWT.OK
                            | SWT.CANCEL | SWT.ICON_WARNING);
                    box.setText(Messages.getString("confirmed"));
                    String[] args = { monitorId };
                    String message = Messages.getString("message.monitor.39", args);
                    box.setMessage(message);

                    if (box.open() == SWT.OK) {
                        LogManager.getInstance().delete(getSelectLogId());
                        logList.update();
                    }
                }
                else{
                	MessageBox box = new MessageBox(getShell(), SWT.OK | SWT.ICON_WARNING);
                    box.setText(Messages.getString("warning"));
                    box.setMessage(Messages.getString("message.monitor.1"));
                    box.open();
                }
            }
        });

        // إܥ
        dummy = new Label(composite, SWT.NONE);
        dummy = new Label(composite, SWT.NONE);
        this.buttonUp = this.createButton(composite, Messages.getString("up"));
        this.buttonUp.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
                String logId = getSelectLogId();
                if (logId != null) {
                    if (LogManager.getInstance().upOrder(logId)) {
                        logList.update();
                        selectItem(logId);
                    }
                }
                else{
                	MessageBox box = new MessageBox(getShell(), SWT.OK | SWT.ICON_WARNING);
                    box.setText(Messages.getString("warning"));
                    box.setMessage(Messages.getString("message.monitor.1"));
                    box.open();
                }
            }
        });

        // إܥ
        this.buttonDown = this.createButton(composite, Messages
                .getString("down"));
        this.buttonDown.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
                String logId = getSelectLogId();
                if (logId != null) {
                    if (LogManager.getInstance().downOrder(getSelectLogId())) {
                        logList.update();
                        selectItem(logId);
                    }
                }
                else{
                	MessageBox box = new MessageBox(getShell(), SWT.OK | SWT.ICON_WARNING);
                    box.setText(Messages.getString("warning"));
                    box.setMessage(Messages.getString("message.monitor.1"));
                    box.open();
                }
            }
        });
        
        // ͭܥ
        dummy = new Label(composite, SWT.NONE);
        this.buttonValid = this.createButton(composite, Messages
                .getString("valid"));
        this.buttonValid.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
            	//ͭѹ
            	setValid(YesNoConstant.TYPE_YES);
            }
        });
        
        // ̵ܥ
        this.buttonInvalid = this.createButton(composite, Messages
                .getString("invalid"));
        this.buttonInvalid.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
            	//̵ѹ
            	setValid(YesNoConstant.TYPE_NO);
            }
        });

        // 饤
        Label line = new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 8;
        line.setLayoutData(gridData);

        // 
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2,
                (display.getBounds().height - shell.getSize().y) / 2);
    }

    /**
     * ͥå򤷤ޤ
     * 
     * @return ڷ
     */
    protected ValidateResult validate() {
        return super.validate();
    }

    /**
     * ϣ˥ܥΥƥȤ֤ޤ
     * 
     * @return ϣ˥ܥΥƥ
     */
    protected String getOkButtonText() {
        return Messages.getString("register");
    }

    /**
     * 󥻥ܥΥƥȤ֤ޤ
     * 
     * @return 󥻥ܥΥƥ
     */
    protected String getCancelButtonText() {
        return Messages.getString("cancel");
    }

    /**
     * ̤Υܥޤ
     * 
     * @param parent
     *            ƤΥݥå
     * @param label
     *            ܥΥ٥
     * @return 줿ܥ
     */
    private Button createButton(Composite parent, String label) {
        Button button = new Button(parent, SWT.NONE);

        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        button.setLayoutData(gridData);

        button.setText(label);

        return button;
    }

    /**
     * 򤵤ƤID֤ޤ
     * 
     * @return ID򤵤Ƥʤϡnull
     */
    private String getSelectLogId() {
        StructuredSelection selection = (StructuredSelection) this.logList
                .getTableViewer().getSelection();

        if (selection.getFirstElement() instanceof LogFilterInfo) {
            LogFilterInfo filterInfo = (LogFilterInfo) selection
                    .getFirstElement();
            return filterInfo.getLogId();
        } else {
            return null;
        }
    }

    /**
     * ꤷٹԤ֤ˤޤ
     * 
     * @param logId
     *            ID
     */
    private void selectItem(String logId) {
        Table table = this.logList.getTableViewer().getTable();
        TableItem[] items = table.getItems();

        if (items == null || logId == null) {
            return;
        }

        for (int i = 0; i < items.length; i++) {

            if (items[i].getData() instanceof LogFilterInfo) {
                LogFilterInfo filterInfo = (LogFilterInfo) items[i].getData();
                if (logId.equals(filterInfo.getLogId())) {
                    table.select(i);
                    return;
                }
            }
        }
    }
    
    /**
     * ̵ͭѹ
     * 
     * @param valid
     */
    public void setValid(int valid) {

		//򤵤줿ƻID
		ArrayList<LogFilterInfo> list = logList.getSelectionData();
		if (list != null && list.size() > 0) {
			
			StringBuilder logIds = new StringBuilder();
			for(int i = 0; i < list.size(); i++){
				if(logIds.length() > 0){
					logIds.append(", ");
				}
				LogFilterInfo info = list.get(i);
				if(info instanceof LogFilterInfo){
					logIds.append(info.getMonitorId());
				}
			}
			MessageBox confirmBox = new MessageBox(getShell(), SWT.OK | SWT.CANCEL | SWT.ICON_WARNING);
			confirmBox.setText(Messages.getString("confirmed"));
            String[] confirmArgs = { logIds.toString() };
            if(valid == YesNoConstant.TYPE_YES)
            	confirmBox.setMessage(Messages.getString("message.monitor.47",confirmArgs));
            else
            	confirmBox.setMessage(Messages.getString("message.monitor.48",confirmArgs));
            if(confirmBox.open() == SWT.CANCEL){
            	return;
            }
			
			for(int i = 0; i < list.size(); i++){
				String logId = null;
				if(list.get(i) instanceof LogFilterInfo){
					logId = ((LogFilterInfo)list.get(i)).getLogId();
				}
				
				if(logId != null && !logId.equals("")){
			        // IDξ
			        LogFilterInfo info = LogManager.getInstance().get(logId);
			        
			        //̵ͭ
			        info.setValidFlg(YesNoConstant.typeToBoolean(valid));
			        
			        //ƻ򹹿
			        boolean result = LogManager.getInstance().modify(info);
                    if(!result){
                        MessageBox box = new MessageBox(getShell(), SWT.OK | SWT.ICON_ERROR);
                        box.setText(Messages.getString("failed"));
                        String[] args = { logId };
                        box.setMessage(Messages.getString("message.monitor.36",args));
                        box.open();
                    }
				}
			}
    			
            int selectIndex = logList.getTableViewer().getTable().getSelectionIndex();
            logList.update();
            logList.getTableViewer().getTable().setSelection(selectIndex);
		}
		else{
        	MessageBox box = new MessageBox(getShell(), SWT.OK | SWT.ICON_WARNING);
            box.setText(Messages.getString("warning"));
            box.setMessage(Messages.getString("message.monitor.1"));
            box.open();
        }
    }
}