/*
                                                                                                
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
*/

package com.clustercontrol.troubledetection.jmx;

import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;

import org.jboss.naming.NonSerializableFactory;
import org.jboss.system.ServiceMBeanSupport;

import com.clustercontrol.troubledetection.monitor.MonitorManagement;

/**
 * @jmx.mbean
 *     name="user:service=TroubleDetectionService,name=TroubleDetectionService"
 *     description="TroubleDetectionService MBean"
 *     extends="org.jboss.system.ServiceMBean"
 * 
 * @jboss.service servicefile="TroubleDetection"
 */
public class TroubleDetectionService extends ServiceMBeanSupport implements TroubleDetectionServiceMBean{
	private String jndiName = "TroubleDetectionService";  // JNDIϿݤ̾
	
	private MonitorManagement manager;
	
	public TroubleDetectionService(){
		
	}
	
    /**
     * @jmx.managed-attribute
     * 
     * @see com.clustercontrol.troubledetection.jmx.TroubleDetectionServiceMBean#getJndiName()
     */
    public String getJndiName() {
        return jndiName;
    }
    
    /**
     * @jmx.managed-attribute
     * 
     * @see com.clustercontrol.troubledetection.jmx.TroubleDetectionServiceMBean#setJndiName(java.lang.String)
     * 
     * @param jndiName
     * @throws NamingException 
     */
    public void setJndiName(String jndiName) throws NamingException {
        log.info("setJndiName() : jndiName = " + jndiName);
    	
        String oldName = this.jndiName;
        this.jndiName = jndiName;
        
        if (super.getState() == STARTED) {
        	try {
        		unbind(oldName);
        	} catch (NamingException e){
        		NamingException ne = new NamingException("Failed to unbind");
        		ne.setRootCause(e);
        		log.error(ne);
        	}

        	try{
        		rebind();
        	} catch (NamingException e){
        		NamingException ne = new NamingException("Failed to rebind");
        		ne.setRootCause(e);
        		log.error(ne);
        	}
        }
    }
	
    /**
     * @jmx.managed-attribute
     * 
     * @see org.jboss.system.ServiceMBean#getName()
     */
    public String getName() {
        return "TroubleDetectionService(" + jndiName + ")";
    }

    /* (non-Javadoc)
     * @see org.jboss.system.ServiceMBeanSupport#createService()
     */
    public void createService() {
        log.info("Create TroubleDetectionService(" + jndiName + ")");
 
        manager = new MonitorManagement();

        log.info("Created TroubleDetectionService(" + jndiName + ")");
    }
    
    /* (non-Javadoc)
     * @see org.jboss.system.ServiceMBeanSupport#startService()
     */
    public void startService() throws NamingException {
        log.info("Start TroubleDetectionService(" + jndiName + ")");
    	
        //ƻ볫
        manager.exec();
        
    	rebind();
    	
        log.info("Started TroubleDetectionService(" + jndiName + ")");
    }
    
    /* (non-Javadoc)
     * @see org.jboss.system.ServiceMBeanSupport#stopService()
     */
    public void stopService() throws NamingException {
        log.info("Stop TroubleDetectionService(" + jndiName + ")");
        
        //ƻ뽪λ
        manager.terminate();
        
    	unbind(jndiName);

        log.info("Stoped TroubleDetectionService(" + jndiName + ")");
    }
    
    /* (non-Javadoc)
     * @see org.jboss.system.ServiceMBeanSupport#destroyService()
     */
    public void destroyService() throws Exception {
        log.info("Destroy TroubleDetectionService(" + jndiName + ")");
        
        //ƻ뽪λ
        if(manager != null)
        	manager.terminate();
        
        manager = null;

        log.info("Destroyed TroubleDetectionService(" + jndiName + ")");
    }
    
	/**
	 * 깹
	 * 
	 * @jmx.managed-attribute
	 * 
	 * @see com.clustercontrol.troubledetection.jmx.TroubleDetectionServiceMBean#updateNotify()
	 */
	public void updateNotify() {
		log.debug("updateNotify() start");
		
		manager.updateNotifyInfo();
		
		log.debug("updateNotify() end");
	}
	

	/** 
	 * å
	 * 
	 * @jmx.managed-attribute
	 * 
	 * @see com.clustercontrol.troubledetection.jmx.TroubleDetectionServiceMBean#putMessage(java.lang.String, java.lang.String)
	 */
	public void putMessage(String monitorId, String messageId) {
		log.debug("putMessage() start : monitorId=" + monitorId + ", messageId=" + messageId);
		
		manager.putMessage(monitorId, messageId);
		
		log.debug("putMessage() end : monitorId=" + monitorId + ", messageId=" + messageId);
	}

    private static Context createContext(Context rootCtx, Name name) throws NamingException {
    	Context subctx = rootCtx;
    	
    	for (int n = 0; n < name.size(); n++) {
    		String atom = name.get(n);
    		
    		try {
    			Object obj = subctx.lookup(atom);
    			subctx = (Context) obj;
    		} catch (NamingException e) {
    			// ¸ߤʤϡ֥ƥȤ
    			subctx = subctx.createSubcontext(atom);
    		}
    	}
    	
    	return subctx;
    }
    
    private void rebind() throws NamingException {
    	InitialContext rootCtx = new InitialContext();
    	
    	Name fullName = rootCtx.getNameParser("").parse(jndiName);
    	Name parentName = fullName;
    	if(fullName.size() > 1){
    		parentName = fullName.getPrefix(fullName.size()-1);
    	} else {
    		parentName = new CompositeName();
    	}
    	
    	Context parentCtx = createContext(rootCtx, parentName);
    	Name atomName = fullName.getSuffix(fullName.size()-1);
    	String atomStirng = atomName.get(0);
    	
    	NonSerializableFactory.rebind(parentCtx, atomStirng, manager);
    }
    
    private void unbind(String jndiName) throws NamingException {
    	InitialContext rootCtx = null;
    	
    	try {
    		rootCtx = new InitialContext();
    		
    		Name fullName = rootCtx.getNameParser("").parse(jndiName);
    		Name atomName = fullName.getSuffix(fullName.size() - 1);
    		String atom = atomName.get(0);
    		
    		rootCtx.unbind(jndiName);
    		NonSerializableFactory.unbind(atom);
    	} finally {
    		if(rootCtx != null) { 
    			rootCtx.close(); 
    		}
    	}
    }
}
