/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.troubledetection.monitor;

import java.util.Timer;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.notify.bean.NotifyInfo;
import com.clustercontrol.troubledetection.bean.TroubleDetectionInfo;
import com.clustercontrol.troubledetection.ejb.session.TroubleDetectionControllerLocal;
import com.clustercontrol.troubledetection.ejb.session.TroubleDetectionControllerUtil;

/**
 * 㳲Υᥤ󥯥饹
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class MonitorManagement {
	private static Log log = LogFactory.getLog(MonitorManagement.class);

	protected Timer timer = null;
	protected MonitorTask task = null;
	
	protected TroubleDetectionInfo troubleDetectionInfo = null;
	protected NotifyInfo notifyInfo = null;
	
	/**
	 * 󥹥ȥ饯
	 */
	public MonitorManagement() {

	}

	/**
	 * Ͻ
	 */
	public void exec() {
		
		//㳲ξ
		troubleDetectionInfo = getTroubleDetectionInfo();
		
		//ξ
		notifyInfo = getNotifyInfo();
		
		//ƻ륿
		task = new MonitorTask();
		task.setTroubleDetectionInfo(troubleDetectionInfo);
		task.setNotifyInfo(notifyInfo);
		
		//ƻ륿ޡ
		timer = new Timer(true);
		timer.schedule(
				task, 
				troubleDetectionInfo.getInterval() * 60000,
				troubleDetectionInfo.getInterval() * 60000);
	}
	
	/**
	 * λ
	 */
	public void terminate() {
		
		if(timer != null)
			timer.cancel();
		
		timer = null;
		
		if(task != null)
			task.cancel();
		
		task = null;
		
	}
	
	/**
	 * ξ󹹿
	 */
	public void updateNotifyInfo() {
		log.debug("updateNotifyInfo() start");
		
		//ξ
		NotifyInfo info = getNotifyInfo();
		if(info != null){
			notifyInfo = info;
			
			//ƻ륿ξ
			task.setNotifyInfo(notifyInfo);
		}
		
		log.debug("updateNotifyInfo() end");
	}
	
	/** 
	 * å
	 * 
	 * @param monitorId
	 * @param messageId
	 */
	public void putMessage(String monitorId, String messageId) {
		log.debug("putMessage() start : monitorId=" + monitorId + ", messageId=" + messageId);

		String lowerMonitorId = monitorId.toLowerCase();
		
		if(lowerMonitorId.matches("jboss.*")){
			//JBossƻ
			MonitorJboss jboss = new MonitorJboss();
			jboss.setTroubleDetectionInfo(troubleDetectionInfo);
			jboss.setNotifyInfo(notifyInfo);
			jboss.logout(monitorId, messageId);
		}
		else if(lowerMonitorId.matches("ldap.*")){
			//OpenLDAPƻ
			MonitorLdap ldap = new MonitorLdap();
			ldap.setTroubleDetectionInfo(troubleDetectionInfo);
			ldap.setNotifyInfo(notifyInfo);
			ldap.logout(monitorId, messageId);
		}
		else if(lowerMonitorId.matches("hinemosdb.*")){
			//PostgresForestƻ
			MonitorForest forest = new MonitorForest();
			forest.setTroubleDetectionInfo(troubleDetectionInfo);
			forest.setNotifyInfo(notifyInfo);
			forest.logout(monitorId, messageId);
		}
		else if(lowerMonitorId.matches("syslog.*")){
			//SyslogForwardƻ
			MonitorSyslogForward syslogForward = new MonitorSyslogForward();
			syslogForward.setTroubleDetectionInfo(troubleDetectionInfo);
			syslogForward.setNotifyInfo(notifyInfo);
			syslogForward.logout(monitorId, messageId);
		}
		
		log.debug("putMessage() end : monitorId=" + monitorId + ", messageId=" + messageId);
	}
	
	/**
	 * 㳲ξ
	 * 
	 * @return
	 */
	public TroubleDetectionInfo getTroubleDetectionInfo() {
		TroubleDetectionInfo info = null;
		
		try {
			TroubleDetectionControllerLocal controller = 
				TroubleDetectionControllerUtil.getLocalHome().create();
			
			info = controller.getInfo();
		} catch (CreateException e) {
		} catch (NamingException e) {
		}

		return info;
	}
	
	/**
	 * ξ
	 * 
	 * @return
	 */
	public NotifyInfo getNotifyInfo() {
		NotifyInfo info = null;
		
		try {
			TroubleDetectionControllerLocal controller = 
				TroubleDetectionControllerUtil.getLocalHome().create();
			
			info = controller.getNotify();
		} catch (CreateException e) {
		} catch (NamingException e) {
		} catch (FinderException e) {
		}
		
		return info;
	}
}
