/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.troubledetection.monitor;

import java.io.IOException;
import java.util.Date;
import java.util.List;

import javax.jms.InvalidSelectorException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.jmx.adaptor.rmi.RMIAdaptor;
import org.jboss.mq.Subscription;
import org.jboss.mq.selectors.Selector;

import com.clustercontrol.monitor.message.LogOutputInfo;
import com.clustercontrol.troubledetection.output.OutputLog;
import com.clustercontrol.troubledetection.util.NotifyMessages;

/**
 * PostgresFprestƻ륯饹
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class MonitorSyslogForward extends MonitorBase {
	private static Log log = LogFactory.getLog(MonitorSyslogForward.class);
	
	protected static final String LOOKUP_NAME = "jmx/invoker/RMIAdaptor";
	protected static final String OBJECT_NAME = "jboss.mq.destination:name=clustercontrol/Repository/update,service=Topic";
	protected static final String OPERATION_NAME = "listAllSubscriptions";
	
	/**
	 * ƻ¹
	 * 
	 * @see com.clustercontrol.troubledetection.monitor.MonitorBase#run()
	 */
	public void run() {
		log.debug("run() start :");
		
		boolean syslogForward1 = false;
		boolean syslogForward2 = false;
		
		try{
	        InitialContext ic = new InitialContext();
	        
	        //RMIAdaptor
	        RMIAdaptor server = (RMIAdaptor) ic.lookup(LOOKUP_NAME);

	        //ObjectName
	        ObjectName name = new ObjectName(OBJECT_NAME);
	        
	        //ObjectNameOperationNameΥ᥽åɤ¹
	        Object returnObject = server.invoke(name, OPERATION_NAME, null, null);

	        //̤å
	        if(returnObject instanceof List){
		        //åʸ
		        String checkString1 = "MultiId='" + this.troubleDetectionInfo.getSyslogForward1() + "'";
		        String checkString2 = "MultiId='" + this.troubleDetectionInfo.getSyslogForward2() + "'";
		        
	        	for(int i = 0; i < ((List)returnObject).size(); i++){
	        		//Subscription
	        		Subscription subscription = (Subscription)((List)returnObject).get(i);
	        		
	        		try {
	        			//SubscriptionSelector
	        			Selector selecter = subscription.getSelector();
	        			
	        			//Selectorȥåʸ
	        			if(selecter != null){
	    				
	        				//ץ1
			        		if(selecter.selector.indexOf(checkString1) != -1){
			        			//åʸޤ
			        			syslogForward1 = true;
			        		}
			        		//ץ2
			        		else if(selecter.selector.indexOf(checkString2) != -1){
			        			//åʸޤ
			        			syslogForward2 = true;
			        		}
	        			}
		        		
					} catch (InvalidSelectorException e) {
						log.debug("run() : " + e.getMessage());
					}
	        	}
	        }
	        
		} catch (NamingException e) {
			log.debug("run() : " + e.getMessage());
		} catch (MalformedObjectNameException e) {
			log.debug("run() : " + e.getMessage());
		} catch (NullPointerException e) {
			log.debug("run() : " + e.getMessage());
		} catch (InstanceNotFoundException e) {
			log.debug("run() : " + e.getMessage());
		} catch (MBeanException e) {
			log.debug("run() : " + e.getMessage());
		} catch (ReflectionException e) {
			log.debug("run() : " + e.getMessage());
		} catch (IOException e) {
			log.debug("run() : " + e.getMessage());
		}

		//
		logout(syslogForward1, syslogForward2);
		
		log.debug("run() end :");
	}
	
	/**
	 * 
	 * 
	 * @param syslogForward1
	 * @param syslogForward2
	 */
	protected void logout(boolean syslogForward1, boolean syslogForward2) {
		
		String application = NotifyMessages.getString("syslog.application");
		
		OutputLog output = new OutputLog(troubleDetectionInfo);
		
		//ץ1ץ2
		if(syslogForward1 && syslogForward2){
			//ξ
			LogOutputInfo info = new LogOutputInfo();
			//ץ饰ID
			info.setPluginId(PLUGIN_ID);
			//ץꥱ
			info.setApplication(application);
			//ƻID
			info.setMonitorId("SYSLOG01");
			//åID
			info.setMessageId("001");
			//åꥸʥå
			info.setMessage(NotifyMessages.getString("syslog01.001.message"));
			String[] args = {this.troubleDetectionInfo.getSyslogForward1(), 
					this.troubleDetectionInfo.getSyslogForward2()};
			info.setMessageOrg(NotifyMessages.getString("syslog01.001.org.message", args));
			//եƥID
			info.setFacilityId(FACILITY_ID);
			//
			info.setScopeText("");
			//
			info.setPriority(getPriority(NotifyMessages.getString("syslog01.001.priority")));
			//ȯ
			info.setGenerationDate(new Date());
			
			//
			output.outputLog(notifyInfo, info);
		}
		//ץ1۾ץ2
		else if(!syslogForward1 && syslogForward2){
			//ξ
			LogOutputInfo info = new LogOutputInfo();
			//ץ饰ID
			info.setPluginId(PLUGIN_ID);
			//ץꥱ
			info.setApplication(application);
			//ƻID
			info.setMonitorId("SYSLOG01");
			//åID
			info.setMessageId("002");
			//åꥸʥå
			String[] args1 = {this.troubleDetectionInfo.getSyslogForward1()};
			info.setMessage(NotifyMessages.getString("syslog01.002.message", args1));
			String[] args2 = {this.troubleDetectionInfo.getSyslogForward1(), 
					this.troubleDetectionInfo.getSyslogForward2()};
			info.setMessageOrg(NotifyMessages.getString("syslog01.002.org.message", args2));
			//եƥID
			info.setFacilityId(FACILITY_ID);
			//
			info.setScopeText("");
			//
			info.setPriority(getPriority(NotifyMessages.getString("syslog01.002.priority")));
			//ȯ
			info.setGenerationDate(new Date());
			
			//
			output.outputLog(notifyInfo, info);
		}
		//ץ1ץ2۾
		else if(syslogForward1 && !syslogForward2){
			//ξ
			LogOutputInfo info = new LogOutputInfo();
			//ץ饰ID
			info.setPluginId(PLUGIN_ID);
			//ץꥱ
			info.setApplication(application);
			//ƻID
			info.setMonitorId("SYSLOG01");
			//åID
			info.setMessageId("002");
			//åꥸʥå
			String[] args1 = {this.troubleDetectionInfo.getSyslogForward2()};
			info.setMessage(NotifyMessages.getString("syslog01.002.message", args1));
			String[] args2 = {this.troubleDetectionInfo.getSyslogForward2(), 
					this.troubleDetectionInfo.getSyslogForward1()};
			info.setMessageOrg(NotifyMessages.getString("syslog01.002.org.message", args2));
			//եƥID
			info.setFacilityId(FACILITY_ID);
			//
			info.setScopeText("");
			//
			info.setPriority(getPriority(NotifyMessages.getString("syslog01.002.priority")));
			//ȯ
			info.setGenerationDate(new Date());
			
			//
			output.outputLog(notifyInfo, info);
		}
		//ץ1۾ץ2۾
		else if(!syslogForward1 && !syslogForward2){
			//ξ
			LogOutputInfo info = new LogOutputInfo();
			//ץ饰ID
			info.setPluginId(PLUGIN_ID);
			//ץꥱ
			info.setApplication(application);
			//ƻID
			info.setMonitorId("SYSLOG01");
			//åID
			info.setMessageId("003");
			//åꥸʥå
			info.setMessage(NotifyMessages.getString("syslog01.003.message"));
			String[] args = {this.troubleDetectionInfo.getSyslogForward1(), 
					this.troubleDetectionInfo.getSyslogForward2()};
			info.setMessageOrg(NotifyMessages.getString("syslog01.003.org.message", args));
			//եƥID
			info.setFacilityId(FACILITY_ID);
			//
			info.setScopeText("");
			//
			info.setPriority(getPriority(NotifyMessages.getString("syslog01.003.priority")));
			//ȯ
			info.setGenerationDate(new Date());
			
			//
			output.outputLog(notifyInfo, info);
		}
	}
	
	/**
	 * 
	 * 
	 * @param messageId
	 */
	public void logout(String monitorId, String messageId){
		
		String application = NotifyMessages.getString("syslog.application");
		String key = monitorId.toLowerCase() + "." + messageId;
		
		OutputLog output = new OutputLog(troubleDetectionInfo);
		
		//ξ
		LogOutputInfo info = new LogOutputInfo();
		//ץ饰ID
		info.setPluginId(PLUGIN_ID);
		//ץꥱ
		info.setApplication(application);
		//ƻID
		info.setMonitorId(monitorId);
		//åID
		info.setMessageId(messageId);
		//åꥸʥå
		info.setMessage(NotifyMessages.getString(key + ".message"));
		info.setMessageOrg(NotifyMessages.getString(key + ".org.message"));
		//եƥID
		info.setFacilityId(FACILITY_ID);
		//
		info.setScopeText("");
		//
		info.setPriority(getPriority(NotifyMessages.getString(key + ".priority")));
		//ȯ
		info.setGenerationDate(new Date());
		
		//
		output.outputLog(notifyInfo, info);
	}
}
