/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.troubledetection.monitor;

import java.util.TimerTask;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.notify.bean.NotifyInfo;
import com.clustercontrol.troubledetection.bean.TroubleDetectionInfo;

/**
 * 㳲μ¹ԥ饹
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class MonitorTask extends TimerTask {
	private static Log log = LogFactory.getLog(MonitorTask.class);

	protected TroubleDetectionInfo troubleDetectionInfo = null;
	protected NotifyInfo notifyInfo = null;
	
	/**
	 * ƻ¹
	 */
	public void run() {
		log.debug("run() start :");
		
		//JBossƻ
		MonitorJboss jboss = new MonitorJboss();
		jboss.setTroubleDetectionInfo(troubleDetectionInfo);
		jboss.setNotifyInfo(notifyInfo);
		jboss.run();
		
		//OpenLDAPƻ
		MonitorLdap ldap = new MonitorLdap();
		ldap.setTroubleDetectionInfo(troubleDetectionInfo);
		ldap.setNotifyInfo(notifyInfo);
		ldap.run();
		
		//PostgresForestƻ
		MonitorForest forest = new MonitorForest();
		forest.setTroubleDetectionInfo(troubleDetectionInfo);
		forest.setNotifyInfo(notifyInfo);
		forest.run();
		
		//SyslogForwardƻ
		MonitorSyslogForward syslogForward = new MonitorSyslogForward();
		syslogForward.setTroubleDetectionInfo(troubleDetectionInfo);
		syslogForward.setNotifyInfo(notifyInfo);
		syslogForward.run();
		
		log.debug("run() end :");
	}
	
	/**
	 * 㳲ξ
	 * 
	 * @param info
	 */
	public void setTroubleDetectionInfo(TroubleDetectionInfo info) {
		troubleDetectionInfo = info;
	}
	
	/**
	 * ξ
	 * 
	 * @param info
	 */
	public void setNotifyInfo(NotifyInfo info) {
		notifyInfo = info;
	}
}
