/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.troubledetection.output;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.EventConfirmConstant;
import com.clustercontrol.bean.ExclusionConstant;
import com.clustercontrol.monitor.message.LogOutputInfo;
import com.clustercontrol.troubledetection.message.LogOutputControlInfo;

/**
 * 饹
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class OutputControl {
	private static Log log = LogFactory.getLog( OutputControl.class );
	
	private static HashMap<String, LogOutputControlInfo> controlBuffer = new HashMap<String, LogOutputControlInfo>();
	
	private Timestamp outputDate = null;
	
	/** ٥ȥե饰 */
	private boolean insertFlg;
	
	/** ٥ȥ󹹿ե饰 */
	private boolean updateFlg;
	
	/**
	 * ٥ȥϽ
	 * 
	 * @param logOutput
	 * @param outputDate
	 * @return
	 */
	public void control(LogOutputInfo logOutput, Timestamp outputDate) {
		log.debug("control() start : MonitorId=" + logOutput.getMonitorId() + ", MessageId" + logOutput.getMessageId());
		
		this.outputDate = outputDate;
		this.insertFlg = false;
		this.updateFlg = false;

		if(logOutput.isEventLogFlg())
		{
			// 
			if(logOutput.getExcludeFlg() == ExclusionConstant.TYPE_FREQUENCY || 
					logOutput.getExcludeFlg() == ExclusionConstant.TYPE_PERIOD || 
					logOutput.getExcludeFlg() == ExclusionConstant.TYPE_PRIORITY){
				
				// ȯ鸫ƺǿƤʤ٥ȥθ
				LogOutputControlInfo controlInfo = controlBuffer.get(logOutput.getMonitorId());
				
				// Ǥ˥٥ȥ¸ߤ
				if(controlInfo != null)
				{
					// оݤξ硢٥ȥ򹹿
					if(isInhibited(logOutput, controlInfo)){
						updateFlg = true;
					}
					else{
						insertFlg = true;
					}
				}
				// ٥ȥ¸ߤʤ
				else
				{
					// ٥ȥ
					insertFlg = true;
				}
			}
			// ʤ
			else{
				// ٥ȥ
				insertFlg = true;
			}
			
			// ٥ȥ
			if(insertFlg)
			{
				LogOutputControlInfo controlInfo = new LogOutputControlInfo();
				controlInfo.setLogOutputInfo(logOutput);
				controlInfo.setDuplicationCount(0);
				controlBuffer.put(logOutput.getMonitorId(), controlInfo);
				
				log.debug("control() insert : MonitorId=" + logOutput.getMonitorId() + ", MessageId" + logOutput.getMessageId());
			}
			
			// ƥƥιоݡ
			if(updateFlg)
			{
				// Υƥƥ򹹿
				LogOutputControlInfo controlInfo = controlBuffer.get(logOutput.getMonitorId());
				controlInfo.setDuplicationCount(controlInfo.getDuplicationCount() + 1);
				controlBuffer.put(logOutput.getMonitorId(), controlInfo);
				
				log.debug("control() update : MonitorId=" + logOutput.getMonitorId() + ", MessageId" + logOutput.getMessageId());
				
				if(logOutput.getExcludeConfirmFlg() == EventConfirmConstant.TYPE_CONFIRMED ||
						logOutput.getExcludeConfirmFlg() == EventConfirmConstant.TYPE_UNCONFIRMED){
					insertFlg = true;
					
					log.debug("control() insert : MonitorId=" + logOutput.getMonitorId() + ", MessageId" + logOutput.getMessageId());
				}
			}
		}
		
		log.debug("control() end : MonitorId=" + logOutput.getMonitorId() + ", MessageId" + logOutput.getMessageId());
	}

	/**
	 * оȽ
	 * 
	 * @param logOutput 
	 * @param eventLog ٥ȥ
	 * @returnоݤξ硢true
	 */
	public boolean isInhibited(LogOutputInfo logOutput, LogOutputControlInfo controlInfo){
		
		// ϰ⤫
		if(logOutput.getExcludeFlg() == ExclusionConstant.TYPE_FREQUENCY){
			if(controlInfo.getDuplicationCount() < logOutput.getExcludeNumber()){
				return true;
			}
		}
		// ֤ϰ⤫
		else if(logOutput.getExcludeFlg() == ExclusionConstant.TYPE_PERIOD){
			
			Calendar cal = Calendar.getInstance();
			cal.setTime(controlInfo.getLogOutputInfo().getGenerationDate());
			cal.add(Calendar.MINUTE, logOutput.getExcludePeriod());
			
			if(cal.getTime().compareTo(logOutput.getGenerationDate()) > 0){
				return true;
			}
		}
		//٤
		else if(logOutput.getExcludeFlg() == ExclusionConstant.TYPE_PRIORITY){
			if(controlInfo.getLogOutputInfo().getPriority() == logOutput.getPriority()){
				return true;
			}
		}
		return false;
	}
	
	
	/**
	 * @return m_outputDate ᤷޤ
	 */
	public Timestamp getOutputDate() {
		return this.outputDate;
	}
	
	/**
	 * @param outputDate ꤷޤ
	 */
	public void setOutputDate(Timestamp outputDate) {
		this.outputDate = outputDate;
	}
	
	/**
	 * @return insertFlg ᤷޤ
	 */
	public boolean isInsertFlg() {
		return insertFlg;
	}
	
	/**
	 * @return updateFlg ᤷޤ
	 */
	public boolean isUpdateFlg() {
		return updateFlg;
	}
}
