/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.troubledetection.output;

import java.sql.Timestamp;
import java.util.Date;

import javax.ejb.CreateException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.monitor.ejb.entity.EventLogUtil;
import com.clustercontrol.monitor.message.LogOutputInfo;

/**
 * ٥Ƚϥ饹
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class OutputEvent {
	private static Log m_log = LogFactory.getLog( OutputEvent.class );

	private Timestamp m_outputDate = null;

	/**
	 * ٥ȥϽ
	 * 
	 * @param logOutput
	 * @param outputDate
	 * @return
	 */
	public boolean output(LogOutputInfo logOutput, Timestamp outputDate, int inhibitedFlg) {
		
		this.m_outputDate = outputDate;

		boolean result = false;
		
		try
		{
			// ٥ȥ
			insertEventLog(logOutput, inhibitedFlg);
			
			result = true;
		}
		catch(CreateException e)
		{
			m_log.error("outputEventLog():" + e.getMessage());
		}
		catch(Exception e)
		{
			m_log.error("outputEventLog():" + e.getMessage());
		}
		
		return result;
	}
	
	/**
	 * ٥ȥ
	 * 
	 * @param logOutput Ͼ
	 * @param inhibitedFlg ե饰
	 * @throws NamingException
	 * @throws CreateException
	 */
	public void  insertEventLog(LogOutputInfo logOutput, int inhibitedFlg) throws Exception, CreateException{
		
		try
		{
			int confirmFlg = -1;
			if(inhibitedFlg == YesNoConstant.TYPE_YES){
				// 줿ǡξ
				confirmFlg = logOutput.getExcludeConfirmFlg();
			}
			else{
				confirmFlg = logOutput.getConfirmFlg();
			}
			
			EventLogUtil.getLocalHome().create(
					logOutput.getMonitorId(),
					logOutput.getPluginId(),
					logOutput.getFacilityId(),
					logOutput.getScopeText(),
					logOutput.getApplication(),
					logOutput.getMessageId(),
					logOutput.getMessage(),
					logOutput.getMessageOrg(),
					new Integer(logOutput.getPriority()),
					new Integer(confirmFlg),
					null,
					new Integer(0),
					new Timestamp(logOutput.getGenerationDate().getTime()),
					m_outputDate,
					new Integer(inhibitedFlg)
			);
		}
		catch(CreateException e)
		{
			// Ʊĥ֥ȤǤ¸ߤ硢ټ٥ȥȥ饤
			if(e instanceof javax.ejb.DuplicateKeyException){
				Date now = new Date();
				m_outputDate = new Timestamp(now.getTime());
				
				this.insertEventLog(logOutput, inhibitedFlg);
			}
			else{
				throw e;
			}
		}
		catch(Exception e)
		{
			throw e;
		}
	}
}
