/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.troubledetection.composite;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.troubledetection.action.GetTroubleDetectionInfo;
import com.clustercontrol.troubledetection.bean.TroubleDetectionInfo;
import com.clustercontrol.util.Messages;


/**
 * ꥳݥåȥ饹Ǥ
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class MonitorComposite extends Composite {


    // ----- instance ե ----- //
	
	/** JBoss ƥ֥ */
	private Text textJbossActive = null;
	/** JBoss Х */
	private Text textJbossStandby = null;

	/** OpenLDAP ץХ */
	private Text textLdapProvider = null;
	/** OpenLDAP 󥷥塼ޥ */
	private Text textLdapConsumer = null;
	
	/** PostgresForest 1 */
	private Text textForest1 = null;
	/** PostgresForest 2 */
	private Text textForest2 = null;
	
	/** SyslogForward ץ1 */
	private Text textSyslogForward1 = null;
	/** SyslogForward ץ2 */
	private Text textSyslogForward2 = null;

	/** ֳ */
	private Text textInterval = null;
	
    // ----- 󥹥ȥ饯 ----- //

    /**
     * 󥹥ȥ饯
     * 
     * @param parent ƤΥݥå
     * @param style 
     */
    public MonitorComposite(Composite parent, int style) {
        super(parent, style);
        
        this.initialize(parent, true);
    }
    

    // ----- instance ᥽å ----- //

    /**
     * ݥåȤۤޤ
     */
    private void initialize(Composite parent, boolean labelFlg) {
        
        // ѿȤѤ٥
        Label label = null;
        // ѿȤѤ륰åɥǡ
        GridData gridData = null;
        
        // 쥤
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 1;
        this.setLayout(layout);
        
        /*
         * JBossξ㳲ƻ
         */
		Group groupJboss = new Group(this, SWT.NONE);
		layout = new GridLayout(1, true);
		layout.marginWidth = 5;
		layout.marginHeight = 5;
		layout.numColumns = 4;
		groupJboss.setLayout(layout);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		groupJboss.setLayoutData(gridData);
		
        /*
         * ƥ֥
         */
        label = new Label(groupJboss, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("active.server") + " : ");

        textJbossActive = new Text(groupJboss, SWT.BORDER | SWT.READ_ONLY);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        textJbossActive.setLayoutData(gridData);
        
        label = new Label(groupJboss, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        
        /*
         * Х
         */
        label = new Label(groupJboss, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("standby.server") + " : ");

        textJbossStandby = new Text(groupJboss, SWT.BORDER | SWT.READ_ONLY);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        textJbossStandby.setLayoutData(gridData);
        
        label = new Label(groupJboss, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        
        /*
         * OpenLDAPξ㳲ƻ
         */
		Group groupLdap = new Group(this, SWT.NONE);
		layout = new GridLayout(1, true);
		layout.marginWidth = 5;
		layout.marginHeight = 5;
		layout.numColumns = 4;
		groupLdap.setLayout(layout);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		groupLdap.setLayoutData(gridData);
		
        /*
         * ץХ
         */
        label = new Label(groupLdap, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("provider.server") + " : ");

        textLdapProvider = new Text(groupLdap, SWT.BORDER | SWT.READ_ONLY);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        textLdapProvider.setLayoutData(gridData);
        
        label = new Label(groupLdap, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        
        /*
         * 󥷥塼ޥ
         */
        label = new Label(groupLdap, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("consumer.server") + " : ");
        
        textLdapConsumer = new Text(groupLdap, SWT.BORDER | SWT.READ_ONLY);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        textLdapConsumer.setLayoutData(gridData);
        
        label = new Label(groupLdap, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        
        /*
         * PostgresForestξ㳲ƻ
         */
		Group groupForest = new Group(this, SWT.NONE);
		layout = new GridLayout(1, true);
		layout.marginWidth = 5;
		layout.marginHeight = 5;
		layout.numColumns = 4;
		groupForest.setLayout(layout);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		groupForest.setLayoutData(gridData);
		
        /*
         * 1
         */
        label = new Label(groupForest, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("server.1") + " : ");

        textForest1 = new Text(groupForest, SWT.BORDER | SWT.READ_ONLY);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        textForest1.setLayoutData(gridData);
        
        label = new Label(groupForest, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        
        /*
         * 2
         */
        label = new Label(groupForest, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("server.2") + " : ");
        
        textForest2 = new Text(groupForest, SWT.BORDER | SWT.READ_ONLY);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        textForest2.setLayoutData(gridData);
        
        label = new Label(groupForest, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        
        
        /*
         * SyslogForwardξ㳲ƻ
         */
		Group groupForward = new Group(this, SWT.NONE);
		layout = new GridLayout(1, true);
		layout.marginWidth = 5;
		layout.marginHeight = 5;
		layout.numColumns = 4;
		groupForward.setLayout(layout);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		groupForward.setLayoutData(gridData);
		
        /*
         * ץ1
         */
        label = new Label(groupForward, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("process.1") + " : ");

        textSyslogForward1 = new Text(groupForward, SWT.BORDER | SWT.READ_ONLY);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        textSyslogForward1.setLayoutData(gridData);
        
        label = new Label(groupForward, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        
        /*
         * ץ2
         */
        label = new Label(groupForward, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("process.2") + " : ");
        
        textSyslogForward2 = new Text(groupForward, SWT.BORDER | SWT.READ_ONLY);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        textSyslogForward2.setLayoutData(gridData);
        
        label = new Label(groupForward, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        
        
        /*
         * ֳ֡ʬ
         */
		Composite intervalComposite = new Composite(this, SWT.NONE);
		layout = new GridLayout(1, true);
		layout.marginWidth = 5;
		layout.marginHeight = 5;
		layout.numColumns = 4;
		intervalComposite.setLayout(layout);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		intervalComposite.setLayoutData(gridData);
		
        label = new Label(intervalComposite, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(
        		Messages.getString("run.interval")  + " (" + 
        		Messages.getString("minute") + ") : ");
        
        textInterval = new Text(intervalComposite, SWT.BORDER | SWT.READ_ONLY);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        textInterval.setLayoutData(gridData);
        
        label = new Label(intervalComposite, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        
		// IDꤵƤ硢ξɽ롣
		TroubleDetectionInfo info = new GetTroubleDetectionInfo().getInfo();   	
		this.setInputData(info);
    }
    
	/**
	 * ƹܤͤꤷޤ
	 * 
	 * @param info 㳲ξ
	 */
	protected void setInputData(TroubleDetectionInfo info) {

		// JBossƥ֥
		this.textJbossActive.setText(info.getJbossServer1());

		// JBossХ
		this.textJbossStandby.setText(info.getJbossServer2());
		
		// OpenLDAPץХ
		this.textLdapProvider.setText(info.getLdapProvider());

		// OpenLDAP󥷥塼ޥ
		this.textLdapConsumer.setText(info.getLdapConsumer());
		
		// Forest1
		this.textForest1.setText(info.getForest1());

		// Forest2
		this.textForest2.setText(info.getForest2());
		
		// SyslogForwardץ1
		this.textSyslogForward1.setText(info.getSyslogForward1());

		// SyslogForwardץ2
		this.textSyslogForward2.setText(info.getSyslogForward2());
		
		// ֳ
		this.textInterval.setText(info.getInterval().toString());
	}
}