/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.internal.ActionPresentation;
import org.eclipse.ui.internal.ExtensionEventHandlerMessages;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.PluginActionSet;
import org.eclipse.ui.internal.PluginActionSetBuilder;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.registry.ActionSetDescriptor;
import org.eclipse.ui.internal.registry.IActionSet;
import org.eclipse.ui.internal.registry.PerspectiveRegistry;
import org.eclipse.ui.internal.registry.WorkingSetRegistry;
import org.eclipse.ui.internal.registry.WorkingSetRegistryReader;
import org.eclipse.ui.internal.themes.ColorDefinition;
import org.eclipse.ui.internal.themes.FontDefinition;
import org.eclipse.ui.internal.themes.ThemeElementHelper;
import org.eclipse.ui.internal.themes.ThemeRegistry;
import org.eclipse.ui.internal.themes.ThemeRegistryReader;
import org.eclipse.ui.themes.ITheme;

class ExtensionEventHandler
implements IRegistryChangeListener {
    private Workbench workbench;
    private List changeList = new ArrayList(10);

    public ExtensionEventHandler(Workbench workbench) {
        this.workbench = workbench;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void registryChanged(IRegistryChangeEvent event) {
        block17: {
            block16: {
                try {
                    IExtensionDelta[] delta = event.getExtensionDeltas(WorkbenchPlugin.PI_WORKBENCH);
                    IWorkbenchWindow[] win = PlatformUI.getWorkbench().getWorkbenchWindows();
                    if (win.length == 0) {
                        Object var14_4 = null;
                        this.changeList.clear();
                        return;
                    }
                    Display display = win[0].getShell().getDisplay();
                    if (display == null) {
                        break block16;
                    }
                    ArrayList<IExtensionDelta> appearList = new ArrayList<IExtensionDelta>(5);
                    ArrayList<IExtensionDelta> revokeList = new ArrayList<IExtensionDelta>(5);
                    String id = null;
                    int numPerspectives = 0;
                    int numActionSetPartAssoc = 0;
                    int i = 0;
                    while (true) {
                        block19: {
                            block18: {
                                if (i >= delta.length) break;
                                id = delta[i].getExtensionPoint().getSimpleIdentifier();
                                if (delta[i].getKind() != 1) break block18;
                                if (id.equals("actionSets")) {
                                    appearList.add(0, delta[i]);
                                    break block19;
                                } else if (!(id.equals("perspectives") || id.equals("views") || id.equals("actionSets"))) {
                                    appearList.add(appearList.size() - numPerspectives, delta[i]);
                                }
                                break block19;
                            }
                            if (delta[i].getKind() == 2) {
                                if (id.equals("actionSetPartAssociations")) {
                                    revokeList.add(0, delta[i]);
                                    ++numActionSetPartAssoc;
                                } else if (id.equals("perspectives")) {
                                    revokeList.add(numActionSetPartAssoc, delta[i]);
                                } else {
                                    revokeList.add(delta[i]);
                                }
                            }
                        }
                        ++i;
                    }
                    Iterator iter = appearList.iterator();
                    IExtensionDelta extDelta = null;
                    while (true) {
                        if (!iter.hasNext()) {
                            this.resetCurrentPerspective(display);
                            break block17;
                        }
                        extDelta = (IExtensionDelta)iter.next();
                        IExtensionPoint extPt = extDelta.getExtensionPoint();
                        IExtension ext = extDelta.getExtension();
                        this.asyncAppear(display, extPt, ext);
                    }
                }
                catch (Throwable throwable) {
                    Object var14_6 = null;
                    this.changeList.clear();
                    throw throwable;
                }
            }
            Object var14_5 = null;
            this.changeList.clear();
            return;
        }
        Object var14_7 = null;
        this.changeList.clear();
    }

    private void asyncAppear(Display display, final IExtensionPoint extpt, final IExtension ext) {
        Runnable run = new Runnable(){

            public void run() {
                ExtensionEventHandler.this.appear(extpt, ext);
            }
        };
        display.syncExec(run);
    }

    private void appear(IExtensionPoint extPt, IExtension ext) {
        String name = extPt.getSimpleIdentifier();
        if (name.equalsIgnoreCase("workingSets")) {
            this.loadWorkingSets(ext);
            return;
        }
        if (name.equalsIgnoreCase("fontDefinitions")) {
            this.loadFontDefinitions(ext);
            return;
        }
        if (name.equalsIgnoreCase("themes")) {
            this.loadThemes(ext);
            return;
        }
    }

    private void loadFontDefinitions(IExtension ext) {
        ThemeRegistryReader reader = new ThemeRegistryReader();
        reader.setRegistry((ThemeRegistry)WorkbenchPlugin.getDefault().getThemeRegistry());
        IConfigurationElement[] elements = ext.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            reader.readElement(elements[i]);
            ++i;
        }
        Collection fonts = reader.getFontDefinitions();
        FontDefinition[] fontDefs = fonts.toArray(new FontDefinition[fonts.size()]);
        ThemeElementHelper.populateRegistry(this.workbench.getThemeManager().getTheme("org.eclipse.ui.defaultTheme"), fontDefs, this.workbench.getPreferenceStore());
    }

    private void loadThemes(IExtension ext) {
        ThemeRegistryReader reader = new ThemeRegistryReader();
        ThemeRegistry registry = (ThemeRegistry)WorkbenchPlugin.getDefault().getThemeRegistry();
        reader.setRegistry(registry);
        IConfigurationElement[] elements = ext.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            reader.readElement(elements[i]);
            ++i;
        }
        Collection colors = reader.getColorDefinitions();
        ColorDefinition[] colorDefs = colors.toArray(new ColorDefinition[colors.size()]);
        ITheme theme = this.workbench.getThemeManager().getTheme("org.eclipse.ui.defaultTheme");
        ThemeElementHelper.populateRegistry(theme, colorDefs, this.workbench.getPreferenceStore());
        Collection fonts = reader.getFontDefinitions();
        FontDefinition[] fontDefs = fonts.toArray(new FontDefinition[fonts.size()]);
        ThemeElementHelper.populateRegistry(theme, fontDefs, this.workbench.getPreferenceStore());
        Map data = reader.getData();
        registry.addData(data);
    }

    private void revoke(IExtensionPoint extPt, IExtension ext) {
        String name = extPt.getSimpleIdentifier();
        if (name.equalsIgnoreCase("perspectives")) {
            this.unloadPerspective(ext);
            return;
        }
        if (name.equalsIgnoreCase("workingSets")) {
            this.unloadWorkingSets(ext);
            return;
        }
    }

    private void unloadPerspective(IExtension ext) {
        MultiStatus result = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.ViewFactory_problemsSavingViews, null);
        IPerspectiveRegistry pReg = WorkbenchPlugin.getDefault().getPerspectiveRegistry();
        IConfigurationElement[] elements = ext.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IPerspectiveDescriptor desc;
            String id;
            if (elements[i].getName().equals("perspective") && (id = elements[i].getAttribute("id")) != null && (desc = pReg.findPerspectiveWithId(id)) != null) {
                ((PerspectiveRegistry)pReg).deletePerspective(desc);
                IWorkbenchWindow[] windows = this.workbench.getWorkbenchWindows();
                int j = 0;
                while (j < windows.length) {
                    WorkbenchWindow window = (WorkbenchWindow)windows[j];
                    IWorkbenchPage[] pages = window.getPages();
                    int k = 0;
                    while (k < pages.length) {
                        pages[k].closePerspective(desc, true, true);
                        ++k;
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (result.getSeverity() != 0) {
            ErrorDialog.openError(null, (String)WorkbenchMessages.Workbench_problemsSaving, (String)WorkbenchMessages.Workbench_problemsSavingMsg, (IStatus)result);
        }
    }

    private void restorePerspectiveState(MultiStatus result, String id) {
        IWorkbenchWindow[] windows = this.workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            WorkbenchWindow window = (WorkbenchWindow)windows[i];
            IWorkbenchPage[] pages = window.getPages();
            int j = pages.length - 1;
            while (j >= 0) {
                IMemento memento = (IMemento)((WorkbenchPage)pages[j]).getStateMap().remove(id);
                if (memento != null) {
                    try {
                        Perspective persp = new Perspective(null, (WorkbenchPage)pages[j]);
                        result.merge(persp.restoreState(memento));
                        ((WorkbenchPage)pages[j]).addPerspective(persp);
                    }
                    catch (WorkbenchException workbenchException) {}
                }
                --j;
            }
            ++i;
        }
    }

    private void resetCurrentPerspective(Display display) {
        if (this.changeList.isEmpty()) {
            return;
        }
        final StringBuffer message = new StringBuffer(ExtensionEventHandlerMessages.ExtensionEventHandler_following_changes);
        Iterator i = this.changeList.iterator();
        while (i.hasNext()) {
            message.append(i.next());
        }
        message.append(ExtensionEventHandlerMessages.ExtensionEventHandler_need_to_reset);
        display.asyncExec(new Runnable(){

            public void run() {
                Shell parentShell = null;
                IWorkbenchWindow window = ExtensionEventHandler.this.workbench.getActiveWorkbenchWindow();
                if (window == null) {
                    if (ExtensionEventHandler.this.workbench.getWorkbenchWindowCount() == 0) {
                        return;
                    }
                    window = ExtensionEventHandler.this.workbench.getWorkbenchWindows()[0];
                }
                if (MessageDialog.openQuestion((Shell)(parentShell = window.getShell()), (String)ExtensionEventHandlerMessages.ExtensionEventHandler_reset_perspective, (String)message.toString())) {
                    IWorkbenchPage page = window.getActivePage();
                    if (page == null) {
                        return;
                    }
                    page.resetPerspective();
                }
            }
        });
    }

    private void removeActionSet(WorkbenchPage page, String id) {
        Perspective persp = page.getActivePerspective();
        ActionPresentation actionPresentation = ((WorkbenchWindow)page.getWorkbenchWindow()).getActionPresentation();
        IActionSet[] actionSets = actionPresentation.getActionSets();
        int i = 0;
        while (i < actionSets.length) {
            ActionSetDescriptor desc = ((PluginActionSet)actionSets[i]).getDesc();
            if (id.equals(desc.getId())) {
                PluginActionSetBuilder builder = new PluginActionSetBuilder();
                builder.removeActionExtensions((PluginActionSet)actionSets[i], page.getWorkbenchWindow());
                actionPresentation.removeActionSet(desc);
            }
            ++i;
        }
        if (persp != null) {
            persp.removeActionSet(id);
        }
    }

    private void loadWorkingSets(IExtension ext) {
        WorkingSetRegistry wReg = WorkbenchPlugin.getDefault().getWorkingSetRegistry();
        WorkingSetRegistryReader reader = new WorkingSetRegistryReader(wReg);
        IConfigurationElement[] elements = ext.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            reader.readElement(elements[i]);
            ++i;
        }
    }

    private void unloadWorkingSets(IExtension ext) {
        WorkingSetRegistry wReg = WorkbenchPlugin.getDefault().getWorkingSetRegistry();
        IConfigurationElement[] elements = ext.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            wReg.removeWorkingSetDescriptor(elements[i].getAttribute("id"));
            ++i;
        }
    }

    private void stopActionSets(IExtension ext) {
        WorkbenchPlugin.getDefault().getActionSetRegistry();
        IConfigurationElement[] elements = ext.getConfigurationElements();
        IWorkbenchWindow[] windows = this.workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            WorkbenchWindow window = (WorkbenchWindow)windows[i];
            IWorkbenchPage[] pages = window.getPages();
            int j = 0;
            while (j < pages.length) {
                int k = 0;
                while (k < elements.length) {
                    String id;
                    if (elements[k].getName().equals("actionSet") && (id = elements[k].getAttribute("id")) != null) {
                        ((WorkbenchPage)pages[j]).hideActionSet(id);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }
}

