/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performanceMGR.util;

import com.clustercontrol.bean.FacilityInfo;
import com.clustercontrol.bean.FacilityPath;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

public class Repository {
    public FacilityTreeItem getFacilityTree(String facilityID) {
        try {
            RepositoryControllerLocal bean = RepositoryControllerUtil.getLocalHome().create();
            FacilityTreeItem facilityTree = bean.getFacilityTree(Locale.getDefault());
            bean.remove();
            FacilityTreeItem subFacilityTree = this.selectFacilityTreeItem(facilityTree, facilityID);
            if (subFacilityTree == null) {
                String message = "Facility not found : " + facilityID;
                return null;
            }
            FacilityInfo info = new FacilityInfo();
            info.setFacilityName("");
            info.setType(2);
            FacilityTreeItem top = new FacilityTreeItem(null, info);
            subFacilityTree.setParent(top);
            top.addChildren(subFacilityTree);
            return top;
        }
        catch (CreateException e) {
            e.printStackTrace();
            throw new EJBException((Exception)((Object)e));
        }
        catch (NamingException e) {
            e.printStackTrace();
            throw new EJBException((Exception)e);
        }
        catch (FinderException e) {
            e.printStackTrace();
        }
        catch (RemoveException e) {
            e.printStackTrace();
            throw new EJBException((Exception)((Object)e));
        }
        return null;
    }

    public String getFacilityPath(String facilityID) {
        try {
            RepositoryControllerLocal bean = RepositoryControllerUtil.getLocalHome().create();
            FacilityTreeItem facilityTree = bean.getFacilityTree(Locale.getDefault());
            bean.remove();
            FacilityTreeItem treeItem = this.selectFacilityTreeItem(facilityTree, facilityID);
            if (treeItem == null) {
                String message = "Facility not found : " + facilityID;
                throw new EJBException(message);
            }
            FacilityPath fpath = new FacilityPath(">");
            return fpath.getPath(treeItem);
        }
        catch (CreateException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (RemoveException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public List getDeviceList(String facilityID) {
        try {
            RepositoryControllerLocal bean = RepositoryControllerUtil.getLocalHome().create();
            ArrayList deviceList = new ArrayList();
            if (facilityID == null) {
                ArrayList nodeList = bean.getNodeFacilityIdList();
                for (String nodeID : nodeList) {
                    deviceList.addAll(bean.getDeviceList(nodeID));
                }
            } else if (bean.isNode(facilityID)) {
                deviceList.addAll(bean.getDeviceList(facilityID));
            } else {
                ArrayList nodeList = bean.getNodeFacilityIdList(facilityID, 0);
                for (String nodeID : nodeList) {
                    deviceList.addAll(bean.getDeviceList(nodeID));
                }
            }
            bean.remove();
            return deviceList;
        }
        catch (CreateException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (RemoveException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    private FacilityTreeItem selectFacilityTreeItem(FacilityTreeItem facilityTree, String facilityID) {
        if (facilityTree.getData().getFacilityId().equals(facilityID)) {
            return facilityTree;
        }
        for (int i = 0; i < facilityTree.getChildren().length; ++i) {
            FacilityTreeItem target = facilityTree.getChildren()[i];
            FacilityTreeItem temp = this.selectFacilityTreeItem(target, facilityID);
            if (temp == null) continue;
            return temp;
        }
        return null;
    }

    public String getIPAddress(String facilityID) {
        HashMap nodeInfo = new HashMap();
        try {
            RepositoryControllerLocal bean = RepositoryControllerUtil.getLocalHome().create();
            ArrayList<String> attributes = new ArrayList<String>();
            attributes.add("ipNetworkNumber");
            nodeInfo = bean.getNodeDetail(facilityID, attributes);
            bean.remove();
        }
        catch (CreateException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (RemoveException e) {
            throw new EJBException((Exception)((Object)e));
        }
        if (nodeInfo != null) {
            return (String)nodeInfo.get("ipNetworkNumber");
        }
        String message = "Couldn't get an IP Address : " + facilityID;
        throw new EJBException(message);
    }

    public boolean isNode(String facilityID) {
        RepositoryControllerLocal bean = null;
        try {
            bean = RepositoryControllerUtil.getLocalHome().create();
            boolean bl = bean.isNode(facilityID);
            return bl;
        }
        catch (CreateException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        finally {
            try {
                bean.remove();
            }
            catch (EJBException e) {
                throw new EJBException((Exception)((Object)e));
            }
            catch (RemoveException e) {
                throw new EJBException((Exception)((Object)e));
            }
        }
    }
}

