/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.composite;

import com.clustercontrol.bean.CommonTableTreeItem;
import com.clustercontrol.composite.CommonTableTreeViewer;
import com.clustercontrol.jobmanagement.action.GetRunScheduleDetailList;
import com.clustercontrol.jobmanagement.action.GetRunScheduleDetailListTableDefine;
import com.clustercontrol.jobmanagement.composite.action.VerticalBarSelectionListener;
import com.clustercontrol.util.Messages;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class RunScheduleDetailListComposite
extends Composite {
    protected CommonTableTreeViewer m_viewer = null;
    protected Label m_labelId = null;
    protected Label m_labelCount = null;
    protected String m_scheduleId = null;

    public RunScheduleDetailListComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.m_labelId = new Label((Composite)this, 16384);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.m_labelId.setLayoutData((Object)gridData);
        TableTree tree = new TableTree((Composite)this, 68356);
        Table table = tree.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.getHorizontalBar().setVisible(true);
        table.getHorizontalBar().setEnabled(true);
        table.getVerticalBar().setVisible(true);
        table.getVerticalBar().setEnabled(true);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        tree.setLayoutData((Object)gridData);
        this.m_labelCount = new Label((Composite)this, 131072);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.m_labelCount.setLayoutData((Object)gridData);
        this.m_viewer = new CommonTableTreeViewer(tree);
        this.m_viewer.createTableColumn(GetRunScheduleDetailListTableDefine.get(), 1, 1);
        this.m_viewer.getTableTree().getTable().getVerticalBar().addSelectionListener((SelectionListener)new VerticalBarSelectionListener(this));
    }

    public void update(String scheduleId) {
        GetRunScheduleDetailList getList = new GetRunScheduleDetailList();
        CommonTableTreeItem item = null;
        if (scheduleId != null && scheduleId.length() > 0) {
            item = getList.get(scheduleId);
        }
        this.m_viewer.setInput(item);
        this.m_viewer.expandAll();
        this.m_scheduleId = scheduleId;
        if (this.m_scheduleId != null) {
            this.m_labelId.setText(String.valueOf(Messages.getString((String)"schedule.id")) + " : " + this.m_scheduleId);
        } else {
            this.m_labelId.setText(String.valueOf(Messages.getString((String)"schedule.id")) + " : ");
        }
    }

    public TableTreeViewer getTableTreeViewer() {
        return this.m_viewer;
    }

    public Table getTable() {
        return this.m_viewer.getTableTree().getTable();
    }

    public TableTree getTableTree() {
        return this.m_viewer.getTableTree();
    }

    public String getScheduleId() {
        return this.m_scheduleId;
    }

    public void setScheduleId(String scheduleId) {
        this.m_scheduleId = scheduleId;
    }
}

