/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.composite;

import com.clustercontrol.bean.EndStatusConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.composite.CommonTableViewer;
import com.clustercontrol.composite.NumberVerifyListener;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.jobmanagement.action.GetWaitRuleTableDefine;
import com.clustercontrol.jobmanagement.bean.JobObjectInfo;
import com.clustercontrol.jobmanagement.bean.JobWaitRuleInfo;
import com.clustercontrol.jobmanagement.composite.action.WaitRuleSelectionChangedListener;
import com.clustercontrol.jobmanagement.dialog.WaitRuleDialog;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class WaitRuleComposite
extends Composite {
    protected CommonTableViewer m_viewer = null;
    protected Button m_andCondition = null;
    protected Button m_orCondition = null;
    protected Button m_endCondition = null;
    protected Group m_endConditionGroup = null;
    protected Text m_endValue = null;
    protected Button m_createCondition = null;
    protected Button m_modifyCondition = null;
    protected Button m_deleteCondition = null;
    protected JobWaitRuleInfo m_waitRule = null;
    protected Shell m_shell = null;
    protected ArrayList m_selectItem = null;
    protected String m_parentJobId = null;
    protected String m_jobId = null;

    public WaitRuleComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
        this.m_shell = this.getShell();
    }

    private void initialize() {
        RowLayout layout = new RowLayout();
        layout.type = 512;
        layout.spacing = 1;
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.fill = true;
        this.setLayout((Layout)layout);
        Composite composite = null;
        RowLayout rowLayout = null;
        composite = new Composite((Composite)this, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 512;
        composite.setLayout((Layout)rowLayout);
        Label tableTitle = new Label(composite, 0);
        tableTitle.setText(Messages.getString((String)"object.list"));
        Table table = new Table(composite, 68356);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)new RowData(430, 80));
        composite = new Composite(composite, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 5;
        composite.setLayout((Layout)rowLayout);
        Label dummy1 = new Label(composite, 0);
        dummy1.setLayoutData((Object)new RowData(190, 15));
        this.m_createCondition = new Button(composite, 0);
        this.m_createCondition.setText(Messages.getString((String)"add"));
        this.m_createCondition.setLayoutData((Object)new RowData(80, 22));
        this.m_createCondition.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WaitRuleDialog dialog = new WaitRuleDialog(WaitRuleComposite.this.m_shell, WaitRuleComposite.this.m_parentJobId, WaitRuleComposite.this.m_jobId);
                if (dialog.open() == 0) {
                    ArrayList info = dialog.getInputData();
                    ArrayList<ArrayList> list = (ArrayList<ArrayList>)WaitRuleComposite.this.m_viewer.getInput();
                    if (list == null) {
                        list = new ArrayList<ArrayList>();
                    }
                    list.add(info);
                    WaitRuleComposite.this.m_viewer.setInput(list);
                }
            }
        });
        this.m_modifyCondition = new Button(composite, 0);
        this.m_modifyCondition.setText(Messages.getString((String)"modify"));
        this.m_modifyCondition.setLayoutData((Object)new RowData(80, 22));
        this.m_modifyCondition.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WaitRuleDialog dialog = new WaitRuleDialog(WaitRuleComposite.this.m_shell, WaitRuleComposite.this.m_parentJobId, WaitRuleComposite.this.m_jobId);
                if (WaitRuleComposite.this.m_selectItem instanceof ArrayList) {
                    dialog.setInputData(WaitRuleComposite.this.m_selectItem);
                    if (dialog.open() == 0) {
                        ArrayList info = dialog.getInputData();
                        ArrayList list = (ArrayList)WaitRuleComposite.this.m_viewer.getInput();
                        list.remove(WaitRuleComposite.this.m_selectItem);
                        list.add(info);
                        WaitRuleComposite.this.m_selectItem = null;
                        WaitRuleComposite.this.m_viewer.setInput((Object)list);
                    }
                }
            }
        });
        this.m_deleteCondition = new Button(composite, 0);
        this.m_deleteCondition.setText(Messages.getString((String)"delete"));
        this.m_deleteCondition.setLayoutData((Object)new RowData(80, 22));
        this.m_deleteCondition.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (WaitRuleComposite.this.m_selectItem instanceof ArrayList) {
                    ArrayList list = (ArrayList)WaitRuleComposite.this.m_viewer.getInput();
                    list.remove(WaitRuleComposite.this.m_selectItem);
                    WaitRuleComposite.this.m_selectItem = null;
                    WaitRuleComposite.this.m_viewer.setInput((Object)list);
                }
            }
        });
        Group group = new Group((Composite)this, 0);
        group.setText(Messages.getString((String)"condition.between.objects"));
        rowLayout = new RowLayout();
        rowLayout.type = 512;
        rowLayout.marginWidth = 5;
        rowLayout.marginHeight = 5;
        rowLayout.spacing = 1;
        group.setLayout((Layout)rowLayout);
        composite = new Composite((Composite)group, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        this.m_andCondition = new Button(composite, 16);
        this.m_andCondition.setText(Messages.getString((String)"and"));
        this.m_andCondition.setLayoutData((Object)new RowData(100, 22));
        this.m_orCondition = new Button(composite, 16);
        this.m_orCondition.setText(Messages.getString((String)"or"));
        this.m_orCondition.setLayoutData((Object)new RowData(100, 22));
        composite = new Composite((Composite)this, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 512;
        composite.setLayout((Layout)rowLayout);
        Label dummy2 = new Label(composite, 0);
        dummy2.setLayoutData((Object)new RowData(190, 15));
        this.m_endCondition = new Button(composite, 32);
        this.m_endCondition.setText(Messages.getString((String)"end.if.condition.unmatched"));
        this.m_endCondition.setLayoutData((Object)new RowData(220, 22));
        this.m_endCondition.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button check = (Button)e.getSource();
                if (check.getSelection()) {
                    WaitRuleComposite.this.m_endConditionGroup.setEnabled(true);
                    WaitRuleComposite.this.m_endValue.setEnabled(true);
                } else {
                    WaitRuleComposite.this.m_endConditionGroup.setEnabled(false);
                    WaitRuleComposite.this.m_endValue.setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.m_endConditionGroup = new Group((Composite)this, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 512;
        rowLayout.marginWidth = 5;
        rowLayout.marginHeight = 5;
        rowLayout.spacing = 1;
        this.m_endConditionGroup.setLayout((Layout)rowLayout);
        composite = new Composite((Composite)this.m_endConditionGroup, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        Label endValueTitle = new Label(composite, 16384);
        endValueTitle.setText(String.valueOf(Messages.getString((String)"end.value")) + " : ");
        endValueTitle.setLayoutData((Object)new RowData(80, 15));
        this.m_endValue = new Text(composite, 2048);
        this.m_endValue.setLayoutData((Object)new RowData(100, 15));
        this.m_endValue.addVerifyListener((VerifyListener)new NumberVerifyListener(Short.MIN_VALUE, Short.MAX_VALUE));
        this.m_viewer = new CommonTableViewer(table);
        this.m_viewer.createTableColumn(GetWaitRuleTableDefine.get(), 0, 1);
        this.m_viewer.addSelectionChangedListener((ISelectionChangedListener)new WaitRuleSelectionChangedListener(this));
    }

    public void reflectWaitRuleInfo() {
        if (this.m_waitRule instanceof JobWaitRuleInfo) {
            ArrayList list = this.m_waitRule.getObject();
            if (list != null) {
                ArrayList tableData = new ArrayList();
                int i = 0;
                while (i < list.size()) {
                    JobObjectInfo info = (JobObjectInfo)list.get(i);
                    ArrayList<Object> tableLineData = new ArrayList<Object>();
                    tableLineData.add(new Integer(info.getType()));
                    if (info.getType() == 0) {
                        tableLineData.add(info.getJobId());
                        tableLineData.add(EndStatusConstant.typeToString((int)info.getValue()));
                    } else if (info.getType() == 1) {
                        tableLineData.add(info.getJobId());
                        tableLineData.add(new Integer(info.getValue()));
                    } else {
                        tableLineData.add("");
                        tableLineData.add(info.getTime());
                    }
                    tableData.add(tableLineData);
                    ++i;
                }
                this.m_viewer.setInput(tableData);
            }
            if (this.m_waitRule.getCondition() == 0) {
                this.m_andCondition.setSelection(true);
            } else {
                this.m_orCondition.setSelection(true);
            }
            this.m_endCondition.setSelection(YesNoConstant.typeToBoolean((int)this.m_waitRule.getEndCondition()));
            this.m_endValue.setText(String.valueOf(this.m_waitRule.getEndValue()));
        } else {
            this.m_andCondition.setSelection(true);
            this.m_endCondition.setSelection(false);
            this.m_endValue.setText(String.valueOf(0));
        }
        if (this.m_endCondition.getSelection()) {
            this.m_endConditionGroup.setEnabled(true);
            this.m_endValue.setEnabled(true);
        } else {
            this.m_endConditionGroup.setEnabled(false);
            this.m_endValue.setEnabled(false);
        }
    }

    public void setWaitRuleInfo(JobWaitRuleInfo start) {
        this.m_waitRule = start;
    }

    public JobWaitRuleInfo getWaitRuleInfo() {
        return this.m_waitRule;
    }

    public ValidateResult createWaitRuleInfo() {
        block14: {
            ValidateResult result = null;
            if (this.m_waitRule == null) {
                this.m_waitRule = new JobWaitRuleInfo();
            }
            ArrayList<JobObjectInfo> list = new ArrayList<JobObjectInfo>();
            ArrayList tableData = (ArrayList)this.m_viewer.getInput();
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (tableData instanceof ArrayList) {
                int i = 0;
                while (i < tableData.size()) {
                    Integer checkValue;
                    Object value;
                    ArrayList tableLineData = (ArrayList)tableData.get(i);
                    JobObjectInfo info = new JobObjectInfo();
                    Integer type = (Integer)tableLineData.get(0);
                    info.setType(type.intValue());
                    if (info.getType() == 0) {
                        info.setJobId((String)tableLineData.get(1));
                        value = (String)tableLineData.get(2);
                        info.setValue(EndStatusConstant.stringToType((String)value));
                        checkValue = (Integer)map.get(String.valueOf(info.getJobId()) + info.getType());
                        if (checkValue == null || checkValue.intValue() != info.getValue()) {
                            list.add(info);
                            map.put(String.valueOf(info.getJobId()) + info.getType(), new Integer(info.getValue()));
                        }
                    } else if (info.getType() == 1) {
                        info.setJobId((String)tableLineData.get(1));
                        value = (Integer)tableLineData.get(2);
                        info.setValue(((Integer)value).intValue());
                        checkValue = (Integer)map.get(String.valueOf(info.getJobId()) + info.getType());
                        if (checkValue == null || checkValue.intValue() != info.getValue()) {
                            list.add(info);
                            map.put(String.valueOf(info.getJobId()) + info.getType(), new Integer(info.getValue()));
                        }
                    } else {
                        value = (Date)tableLineData.get(2);
                        info.setTime((Date)value);
                        if (map.get("TIME") == null) {
                            list.add(info);
                            map.put("TIME", "1");
                        }
                    }
                    ++i;
                }
            }
            this.m_waitRule.setObject(list);
            if (this.m_andCondition.getSelection()) {
                this.m_waitRule.setCondition(0);
            } else {
                this.m_waitRule.setCondition(1);
            }
            this.m_waitRule.setEndCondition(YesNoConstant.booleanToType((boolean)this.m_endCondition.getSelection()));
            try {
                this.m_waitRule.setEndValue(Integer.parseInt(this.m_endValue.getText()));
            }
            catch (NumberFormatException numberFormatException) {
                if (this.m_waitRule.getEndCondition() != 1) break block14;
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.job.21"));
                return result;
            }
        }
        return null;
    }

    public ArrayList getSelectItem() {
        return this.m_selectItem;
    }

    public void setSelectItem(ArrayList selectItem) {
        this.m_selectItem = selectItem;
    }

    public String getParentJobId() {
        return this.m_parentJobId;
    }

    public void setParentJobId(String parentJobId) {
        this.m_parentJobId = parentJobId;
    }

    public String getJobId() {
        return this.m_jobId;
    }

    public void setJobId(String jobId) {
        this.m_jobId = jobId;
    }
}

