/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.actions;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.internal.ide.actions.BuildSetAction;
import org.eclipse.ui.internal.ide.actions.SelectBuildWorkingSetAction;

public class BuildSetMenu
extends ContributionItem {
    private IActionBarConfigurer actionBars;
    boolean dirty = true;
    private IMenuListener menuListener = new IMenuListener(){

        public void menuAboutToShow(IMenuManager manager) {
            manager.markDirty();
            BuildSetMenu.this.dirty = true;
        }
    };
    private IAction selectBuildWorkingSetAction;
    private IWorkbenchWindow window;

    public BuildSetMenu(IWorkbenchWindow window, IActionBarConfigurer actionBars) {
        this.window = window;
        this.actionBars = actionBars;
        this.selectBuildWorkingSetAction = new SelectBuildWorkingSetAction(window, actionBars);
    }

    private void addMnemonic(BuildSetAction action, int index) {
        StringBuffer label = new StringBuffer();
        if (index < 9) {
            label.append('&');
            label.append(index);
            label.append(' ');
        }
        label.append(action.getWorkingSet().getName());
        action.setText(label.toString());
    }

    public void fill(Menu menu, int index) {
        if (this.getParent() instanceof MenuManager) {
            ((MenuManager)this.getParent()).addMenuListener(this.menuListener);
        }
        if (!this.dirty) {
            return;
        }
        this.fillMenu(menu);
        this.dirty = false;
    }

    private void fillMenu(Menu menu) {
        boolean isAutoBuilding = ResourcesPlugin.getWorkspace().isAutoBuilding();
        IWorkingSet[] sets = this.window.getWorkbench().getWorkingSetManager().getRecentWorkingSets();
        BuildSetAction last = BuildSetAction.lastBuilt;
        Object lastSet = null;
        int accel = 1;
        if (last != null) {
            boolean found = false;
            int i = 0;
            while (i < sets.length) {
                if (sets[i].equals(last.getWorkingSet())) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (found) {
                last.setChecked(true);
                last.setEnabled(!isAutoBuilding);
                last.setActionDefinitionId("org.eclipse.ui.project.buildLast");
                this.addMnemonic(last, accel++);
                new ActionContributionItem((IAction)last).fill(menu, -1);
                lastSet = last.getWorkingSet();
            } else {
                BuildSetAction.lastBuilt = null;
            }
        }
        int i = 0;
        while (i < sets.length) {
            if (lastSet == null || !lastSet.equals(sets[i])) {
                BuildSetAction action = new BuildSetAction(sets[i], this.window, this.actionBars);
                this.addMnemonic(action, accel++);
                action.setEnabled(!isAutoBuilding);
                new ActionContributionItem((IAction)action).fill(menu, -1);
            }
            ++i;
        }
        if (sets.length > 0) {
            new Separator().fill(menu, -1);
        }
        this.selectBuildWorkingSetAction.setEnabled(!isAutoBuilding);
        new ActionContributionItem(this.selectBuildWorkingSetAction).fill(menu, -1);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isDynamic() {
        return true;
    }
}

