/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.management.monitor.MonitorMBean;
import javax.management.monitor.MonitorNotification;
import org.jboss.mx.util.ObservedObject;

public abstract class Monitor
extends NotificationBroadcasterSupport
implements MonitorMBean,
MBeanRegistration {
    protected static final int capacityIncrement = 16;
    protected static final int RESET_FLAGS_ALREADY_NOTIFIED = 0;
    protected static final int RUNTIME_ERROR_NOTIFIED = 8;
    protected static final int OBSERVED_OBJECT_ERROR_NOTIFIED = 1;
    protected static final int OBSERVED_ATTRIBUTE_ERROR_NOTIFIED = 2;
    protected static final int OBSERVED_ATTRIBUTE_TYPE_ERROR_NOTIFIED = 4;
    protected int elementCount = 0;
    long granularityPeriod = 10000L;
    String observedAttribute = null;
    ConcurrentHashMap observedObjects = new ConcurrentHashMap();
    boolean active = false;
    protected MBeanServer server;
    ObjectName objectName;
    protected int alreadyNotified = 0;
    protected int[] alreadyNotifieds = new int[0];
    protected String dbgTag = null;
    private long sequenceNumber;

    public long getGranularityPeriod() {
        return this.granularityPeriod;
    }

    public String getObservedAttribute() {
        return this.observedAttribute;
    }

    public ObjectName getObservedObject() {
        ObservedObject object = this.getFirstObservedObject();
        if (object != null) {
            return object.getObjectName();
        }
        return null;
    }

    public ObjectName[] getObservedObjects() {
        HashSet set = new HashSet(this.observedObjects.values());
        this.elementCount = set.size();
        ObjectName[] result = new ObjectName[set.size()];
        this.alreadyNotifieds = new int[set.size()];
        int count = 0;
        Iterator i = set.iterator();
        while (i.hasNext()) {
            ObservedObject object = (ObservedObject)i.next();
            result[count] = object.getObjectName();
            this.alreadyNotifieds[count++] = object.getAlreadyNotified();
        }
        return result;
    }

    public synchronized boolean isActive() {
        return this.active;
    }

    public void setGranularityPeriod(long period) throws IllegalArgumentException {
        if (period <= 0L) {
            throw new IllegalArgumentException("Period must be positive.");
        }
        this.granularityPeriod = period;
    }

    public void setObservedAttribute(String attribute) throws IllegalArgumentException {
        this.observedAttribute = attribute;
    }

    public void setObservedObject(ObjectName object) throws IllegalArgumentException {
        this.observedObjects.clear();
        this.addObservedObject(object);
    }

    public void addObservedObject(ObjectName object) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException("null object name");
        }
        ObservedObject o = new ObservedObject(object);
        this.initObservedObject(o);
        this.observedObjects.put(object, o);
    }

    public void removeObservedObject(ObjectName object) {
        if (object == null) {
            throw new IllegalArgumentException("null object name");
        }
        this.observedObjects.remove(object);
    }

    public boolean containsObservedObject(ObjectName object) {
        if (object == null) {
            throw new IllegalArgumentException("null object name");
        }
        return this.observedObjects.containsKey(object);
    }

    public abstract void start();

    public abstract void stop();

    public String toString() {
        StringBuffer buffer = new StringBuffer(100);
        buffer.append(this.getClass()).append(System.identityHashCode(this)).append(": {");
        buffer.append(" objectName=").append(this.objectName);
        return buffer.append("}").toString();
    }

    public ObjectName preRegister(MBeanServer server, ObjectName objectName) throws Exception {
        this.server = server;
        this.objectName = objectName;
        return objectName;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
        this.stop();
    }

    public void postDeregister() {
    }

    ObservedObject retrieveObservedObject(ObjectName name) {
        return (ObservedObject)this.observedObjects.get(name);
    }

    Map retrieveObservedObjects() {
        return this.observedObjects;
    }

    ObservedObject getFirstObservedObject() {
        Iterator i = this.observedObjects.values().iterator();
        if (i.hasNext()) {
            return (ObservedObject)i.next();
        }
        return null;
    }

    void initObservedObject(ObservedObject object) {
        object.resetAlreadyNotified();
        object.setDerivedGaugeTimeStamp(System.currentTimeMillis());
    }

    void sendNotification(ObservedObject object, String type, long timestamp, String message, String attribute, Object gauge, Object trigger) {
        long seq = this.nextSeqNo();
        if (timestamp == 0L) {
            timestamp = System.currentTimeMillis();
        }
        this.sendNotification(new MonitorNotification(type, this.objectName, seq, timestamp, message, gauge, attribute, object.getObjectName(), trigger));
    }

    void sendRuntimeErrorNotification(ObservedObject object, String message) {
        if (object.notAlreadyNotified(8)) {
            this.sendNotification(object, "jmx.monitor.error.runtime", 0L, message, this.observedAttribute, null, null);
        }
    }

    void sendObjectErrorNotification(ObservedObject object, String message) {
        if (object.notAlreadyNotified(1)) {
            this.sendNotification(object, "jmx.monitor.error.mbean", 0L, message, this.observedAttribute, null, null);
        }
    }

    void sendAttributeErrorNotification(ObservedObject object, String message) {
        if (object.notAlreadyNotified(2)) {
            this.sendNotification(object, "jmx.monitor.error.attribute", 0L, message, this.observedAttribute, null, null);
        }
    }

    void sendAttributeTypeErrorNotification(ObservedObject object, String message) {
        if (object.notAlreadyNotified(4)) {
            this.sendNotification(object, "jmx.monitor.error.type", 0L, message, this.observedAttribute, null, null);
        }
    }

    void resetAlreadyNotified() {
        Iterator i = this.observedObjects.values().iterator();
        while (i.hasNext()) {
            ((ObservedObject)i.next()).resetAlreadyNotified();
        }
    }

    synchronized long nextSeqNo() {
        long nextSeqNo = this.sequenceNumber++;
        return nextSeqNo;
    }
}

