/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import java.io.Serializable;
import java.util.HashSet;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TopicSession;
import javax.jms.XAConnection;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueSession;
import javax.jms.XASession;
import javax.jms.XATopicConnection;
import javax.jms.XATopicSession;
import org.jboss.mq.GenericConnectionFactory;
import org.jboss.mq.SpyConnection;
import org.jboss.mq.SpyQueueSession;
import org.jboss.mq.SpySession;
import org.jboss.mq.SpyTopicSession;

public class SpyXAConnection
extends SpyConnection
implements Serializable,
XAConnection,
XATopicConnection,
XAQueueConnection {
    static final long serialVersionUID = 1258716704996031025L;

    public SpyXAConnection(String userid, String password, GenericConnectionFactory gcf) throws JMSException {
        super(userid, password, gcf);
    }

    public SpyXAConnection(GenericConnectionFactory gcf) throws JMSException {
        super(gcf);
    }

    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return this.createXASession();
    }

    public QueueSession createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return (QueueSession)((Object)this.createXAQueueSession());
    }

    public TopicSession createTopicSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return (TopicSession)((Object)this.createXATopicSession());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XASession createXASession() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        this.checkClientID();
        SpySession session = new SpySession(this, true, 0, true);
        HashSet hashSet = this.createdSessions;
        synchronized (hashSet) {
            this.createdSessions.add(session);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XAQueueSession createXAQueueSession() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        this.checkClientID();
        SpyQueueSession session = new SpyQueueSession(this, true, 0, true);
        HashSet hashSet = this.createdSessions;
        synchronized (hashSet) {
            this.createdSessions.add(session);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XATopicSession createXATopicSession() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        this.checkClientID();
        SpyTopicSession session = new SpyTopicSession(this, true, 0, true);
        HashSet hashSet = this.createdSessions;
        synchronized (hashSet) {
            this.createdSessions.add(session);
        }
        return session;
    }
}

