/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.logtransfer.composite;

import com.clustercontrol.composite.CommonTableViewer;
import com.clustercontrol.logtransfer.action.GetLogTransfer;
import com.clustercontrol.logtransfer.action.GetLogTransferListTableDefine;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogTransferListComposite
extends Composite {
    private CommonTableViewer tableViewer = null;

    public LogTransferListComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Table table = new Table((Composite)this, 66306);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        table.setLayoutData((Object)gridData);
        this.tableViewer = new CommonTableViewer(table);
        this.tableViewer.createTableColumn(GetLogTransferListTableDefine.get(), 0, 1);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.update();
    }

    public CommonTableViewer getTableViewer() {
        return this.tableViewer;
    }

    public void update() {
        ArrayList list = new GetLogTransfer().getLogTransferList();
        if (list == null) {
            list = new ArrayList();
        }
        this.tableViewer.setInput(list);
    }

    public ArrayList<String> getSelectionData() {
        ArrayList<String> data = new ArrayList<String>();
        StructuredSelection selection = (StructuredSelection)this.tableViewer.getSelection();
        List list = selection.toList();
        if (list != null) {
            int index = 0;
            while (index < list.size()) {
                ArrayList info = (ArrayList)list.get(index);
                if (info != null && info.size() > 0) {
                    String transferId = (String)info.get(0);
                    data.add(transferId);
                }
                ++index;
            }
        }
        return data;
    }
}

