/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.run.composite;

import com.clustercontrol.bean.PriorityColorConstant;
import com.clustercontrol.composite.StringVerifyListener;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.bean.MonitorNumericValueInfo;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NumericMessageComposite
extends Composite {
    public static final int WIDTH_TITLE = 5;
    public static final int WIDTH_VALUE = 2;
    private Text m_textInfoId = null;
    private Text m_textInfoMessage = null;
    private Text m_textWarnId = null;
    private Text m_textWarnMessage = null;
    private Text m_textCriticalId = null;
    private Text m_textCriticalMessage = null;

    public NumericMessageComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        Label label = null;
        GridData gridData = null;
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 15;
        this.setLayout((Layout)layout);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString("priority"));
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString("message.id"));
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString("message"));
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = this.getLabelPriority(this, Messages.getString("info"), PriorityColorConstant.COLOR_INFO);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.m_textInfoId = new Text((Composite)this, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textInfoId.setLayoutData((Object)gridData);
        this.m_textInfoId.addVerifyListener((VerifyListener)new StringVerifyListener(64));
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.m_textInfoMessage = new Text((Composite)this, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textInfoMessage.setLayoutData((Object)gridData);
        this.m_textInfoMessage.addVerifyListener((VerifyListener)new StringVerifyListener(256));
        label = this.getLabelPriority(this, Messages.getString("warning"), PriorityColorConstant.COLOR_WARNING);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.m_textWarnId = new Text((Composite)this, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textWarnId.setLayoutData((Object)gridData);
        this.m_textWarnId.addVerifyListener((VerifyListener)new StringVerifyListener(64));
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.m_textWarnMessage = new Text((Composite)this, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textWarnMessage.setLayoutData((Object)gridData);
        this.m_textWarnMessage.addVerifyListener((VerifyListener)new StringVerifyListener(256));
        label = this.getLabelPriority(this, Messages.getString("critical"), PriorityColorConstant.COLOR_CRITICAL);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.m_textCriticalId = new Text((Composite)this, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textCriticalId.setLayoutData((Object)gridData);
        this.m_textCriticalId.addVerifyListener((VerifyListener)new StringVerifyListener(64));
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.m_textCriticalMessage = new Text((Composite)this, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textCriticalMessage.setLayoutData((Object)gridData);
        this.m_textCriticalMessage.addVerifyListener((VerifyListener)new StringVerifyListener(256));
    }

    public void setInputData(MonitorInfo info) {
        ArrayList list;
        if (info != null && (list = info.getJudgementInfo()) != null) {
            int index = 0;
            while (index < list.size()) {
                MonitorNumericValueInfo numericValueInfo = (MonitorNumericValueInfo)list.get(index);
                if (numericValueInfo != null) {
                    if (3 == numericValueInfo.getPriority()) {
                        this.m_textInfoId.setText(numericValueInfo.getMessageId());
                        this.m_textInfoMessage.setText(numericValueInfo.getMessage());
                    } else if (2 == numericValueInfo.getPriority()) {
                        this.m_textWarnId.setText(numericValueInfo.getMessageId());
                        this.m_textWarnMessage.setText(numericValueInfo.getMessage());
                    } else if (numericValueInfo.getPriority() == 0) {
                        this.m_textCriticalId.setText(numericValueInfo.getMessageId());
                        this.m_textCriticalMessage.setText(numericValueInfo.getMessage());
                    }
                }
                ++index;
            }
        }
    }

    public ValidateResult createInputData(MonitorInfo info) {
        String id = null;
        String message = null;
        ValidateResult validateResult = null;
        id = this.m_textInfoId.getText();
        validateResult = this.setMonitorNumericValueInfo(info, id, message = this.m_textInfoMessage.getText(), 3);
        if (validateResult != null) {
            return validateResult;
        }
        id = this.m_textWarnId.getText();
        validateResult = this.setMonitorNumericValueInfo(info, id, message = this.m_textWarnMessage.getText(), 2);
        if (validateResult != null) {
            return validateResult;
        }
        id = this.m_textCriticalId.getText();
        validateResult = this.setMonitorNumericValueInfo(info, id, message = this.m_textCriticalMessage.getText(), 0);
        if (validateResult != null) {
            return validateResult;
        }
        return null;
    }

    public ValidateResult setMonitorNumericValueInfo(MonitorInfo info, String id, String message, int priority) {
        boolean find = false;
        MonitorNumericValueInfo numericValueInfo = null;
        ArrayList list = info.getJudgementInfo();
        if (list != null) {
            int index = 0;
            while (index < list.size()) {
                numericValueInfo = (MonitorNumericValueInfo)list.get(index);
                if (numericValueInfo != null && priority == numericValueInfo.getPriority()) {
                    find = true;
                    break;
                }
                ++index;
            }
        }
        if (!find) {
            numericValueInfo = new MonitorNumericValueInfo();
            numericValueInfo.setMonitorId(info.getMonitorId());
            numericValueInfo.setMonitorTypeId(info.getMonitorTypeId());
            numericValueInfo.setPriority(priority);
            numericValueInfo.setMessageId(id);
            numericValueInfo.setMessage(message);
            numericValueInfo.setThresholdLowerLimit(0.0);
            numericValueInfo.setThresholdUpperLimit(0.0);
            list.add(numericValueInfo);
        }
        if (id != null && !"".equals(id.trim())) {
            numericValueInfo.setMessageId(id);
        } else {
            if (3 == priority) {
                return this.setValidateResult(Messages.getString("message.hinemos.1"), Messages.getString("message.monitor.13"));
            }
            if (2 == priority) {
                return this.setValidateResult(Messages.getString("message.hinemos.1"), Messages.getString("message.monitor.15"));
            }
            if (priority == 0) {
                return this.setValidateResult(Messages.getString("message.hinemos.1"), Messages.getString("message.monitor.17"));
            }
        }
        if (message != null && !"".equals(message.trim())) {
            numericValueInfo.setMessage(message);
        } else {
            if (3 == priority) {
                return this.setValidateResult(Messages.getString("message.hinemos.1"), Messages.getString("message.monitor.14"));
            }
            if (2 == priority) {
                return this.setValidateResult(Messages.getString("message.hinemos.1"), Messages.getString("message.monitor.16"));
            }
            if (priority == 0) {
                return this.setValidateResult(Messages.getString("message.hinemos.1"), Messages.getString("message.monitor.18"));
            }
        }
        return null;
    }

    public void setEnabled(boolean enabled) {
        this.m_textInfoId.setEnabled(enabled);
        this.m_textInfoMessage.setEnabled(enabled);
        this.m_textWarnId.setEnabled(enabled);
        this.m_textWarnMessage.setEnabled(enabled);
        this.m_textCriticalId.setEnabled(enabled);
        this.m_textCriticalMessage.setEnabled(enabled);
    }

    protected Label getLabelPriority(Composite parent, String text, Color background) {
        Label label = new Label(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(text) + " : ");
        label.setBackground(background);
        return label;
    }

    protected ValidateResult setValidateResult(String id, String message) {
        ValidateResult validateResult = new ValidateResult();
        validateResult.setValid(false);
        validateResult.setID(id);
        validateResult.setMessage(message);
        return validateResult;
    }
}

