/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.util;

import com.clustercontrol.performance.action.RecordController;
import com.clustercontrol.performance.util.Messages;
import com.clustercontrol.performanceMGR.bean.CollectorItemInfo;
import com.clustercontrol.performanceMGR.util.code.CollectorItemTreeItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class CollectorItemCodeFactory {
    private static HashMap<String, CollectorItemTreeItem> m_codeTable = null;

    private CollectorItemCodeFactory() {
    }

    public static void init() {
        m_codeTable = RecordController.getInstance().getItemCodeTreeMap();
    }

    public static String getItemName(String itemCode) {
        if (m_codeTable == null) {
            CollectorItemCodeFactory.init();
        }
        return m_codeTable.get(itemCode).getItemName();
    }

    public static String getFullItemName(String itemCode, String deviceName) {
        if (m_codeTable == null) {
            CollectorItemCodeFactory.init();
        }
        String name = deviceName == null || deviceName.equals(Messages.getString("NONE")) ? m_codeTable.get(itemCode).getItemName() : String.valueOf(m_codeTable.get(itemCode).getItemName()) + "(" + deviceName + ")";
        return name;
    }

    public static String getFullItemName(CollectorItemInfo collectorItemInfo) {
        String itemCode;
        if (m_codeTable == null) {
            CollectorItemCodeFactory.init();
        }
        if (CollectorItemCodeFactory.isDeviceSupport(itemCode = collectorItemInfo.getCollectorItemCode())) {
            return CollectorItemCodeFactory.getFullItemName(collectorItemInfo.getCollectorItemCode(), collectorItemInfo.getDeviceName());
        }
        return CollectorItemCodeFactory.getItemName(itemCode);
    }

    public static String getMeasure(String itemCode) {
        if (m_codeTable == null) {
            CollectorItemCodeFactory.init();
        }
        return m_codeTable.get(itemCode).getMeasure();
    }

    public static boolean isRangeFixed(String itemCode) {
        if (m_codeTable == null) {
            CollectorItemCodeFactory.init();
        }
        return m_codeTable.get(itemCode).isRangeFixed();
    }

    public static boolean isDeviceSupport(String itemCode) {
        if (m_codeTable == null) {
            CollectorItemCodeFactory.init();
        }
        return m_codeTable.get(itemCode).isDeviceFlag();
    }

    public static String getCategoryName(String itemCode) {
        if (m_codeTable == null) {
            CollectorItemCodeFactory.init();
        }
        return m_codeTable.get(itemCode).getCategory().getCategoryName();
    }

    public static String getCategoryCode(String itemCode) {
        if (m_codeTable == null) {
            CollectorItemCodeFactory.init();
        }
        return m_codeTable.get(itemCode).getCategory().getCategoryCode();
    }

    public static String[] getCodeAll() {
        if (m_codeTable == null) {
            CollectorItemCodeFactory.init();
        }
        TreeSet set = new TreeSet(m_codeTable.keySet());
        return set.toArray(new String[set.size()]);
    }

    public static List getSubItemCode(String itemCode) {
        if (m_codeTable == null) {
            CollectorItemCodeFactory.init();
        }
        ArrayList<String> itemCodeList = new ArrayList<String>();
        CollectorItemTreeItem treeItem = m_codeTable.get(itemCode);
        Iterator itr = treeItem.getChildrens().iterator();
        while (itr.hasNext()) {
            String subItemCode = ((CollectorItemTreeItem)itr.next()).getItemCode();
            itemCodeList.add(subItemCode);
        }
        return itemCodeList;
    }

    public static boolean checkItemList(CollectorItemInfo target, List itemList) {
        List itemCodeList;
        if (m_codeTable == null) {
            CollectorItemCodeFactory.init();
        }
        if ((itemCodeList = CollectorItemCodeFactory.getSubItemCode(target.getCollectorItemCode())) == null || itemCodeList.size() == 0) {
            return false;
        }
        return CollectorItemCodeFactory.selectItemInfo(target, itemList) != null;
    }

    private static List selectItemInfo(CollectorItemInfo target, List itemList) {
        ArrayList<CollectorItemInfo> returnList = new ArrayList<CollectorItemInfo>();
        List itemCodeList = CollectorItemCodeFactory.getSubItemCode(target.getCollectorItemCode());
        int deviceIndex = target.getDeviceIndex();
        for (String itemCode : itemCodeList) {
            CollectorItemInfo buffer = null;
            for (CollectorItemInfo itemInfo : itemList) {
                if (!itemInfo.getCollectorItemCode().equals(itemCode) || itemInfo.getDeviceIndex() != deviceIndex) continue;
                buffer = itemInfo;
            }
            if (buffer == null) {
                return null;
            }
            returnList.add(buffer);
        }
        return returnList;
    }

    public static CollectorItemTreeItem[] getCollectorTree(String facilityId, String collectorId) {
        return RecordController.getInstance().getCollectorTree(facilityId, collectorId);
    }

    public static List getAvailableCollectorItemList(String facilityId) {
        return RecordController.getInstance().getAvailableCollectorItemList(facilityId);
    }
}

