/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.snmptrap.factory;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.snmptrap.bean.MonitorSnmpTrapInfo;
import com.clustercontrol.snmptrap.bean.MonitorSnmpTrapOidInfo;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapInfoLocal;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapInfoPK;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapInfoUtil;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMasterLocal;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMasterPK;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMasterUtil;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapOidInfoLocal;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapOidInfoUtil;
import com.clustercontrol.snmptrap.message.UpdateSnmpTrapInfo;
import com.clustercontrol.snmptrap.util.SendTopic;
import com.clustercontrol.util.apllog.AplLogger;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.jms.JMSException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ModifyMonitorInfo {
    protected static Log m_log = LogFactory.getLog(ModifyMonitorInfo.class);
    protected MonitorSnmpTrapInfo m_monitorInfo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean modify(MonitorSnmpTrapInfo info, String user) throws CreateException, NotSupportedException, RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException, InvalidTransactionException, NamingException, FinderException, RemoveException {
        AccessLock.lock((String)"MONITOR_SNMPTRAP");
        this.m_monitorInfo = info;
        TransactionManager tm = null;
        Transaction tx = null;
        Transaction oldTx = null;
        boolean result = false;
        try {
            InitialContext context = new InitialContext();
            tm = (TransactionManager)context.lookup("java:/TransactionManager");
            if (tm.getTransaction() != null) {
                oldTx = tm.suspend();
            }
            try {
                if (tm.getTransaction() == null) {
                    tm.begin();
                    tx = tm.getTransaction();
                }
                if (result = this.modifyMonitorInfo(user)) {
                    tx.commit();
                }
                try {
                    UpdateSnmpTrapInfo updateInfo = new UpdateSnmpTrapInfo(1, info.getMonitorId());
                    SendTopic sendTopic = new SendTopic("topic/clustercontrol/SnmpTrap/update");
                    sendTopic.put(updateInfo);
                }
                catch (NamingException e) {
                    m_log.error((Object)("modify() : \u9001\u4fe1\u30a8\u30e9\u30fc\u3002" + e.getMessage()));
                }
                catch (JMSException e) {
                    m_log.error((Object)("modify() : \u9001\u4fe1\u30a8\u30e9\u30fc\u3002" + e.getMessage()));
                }
            }
            catch (NotSupportedException e) {
                this.outputLog((Exception)((Object)e), "modify()");
                throw e;
            }
            catch (RollbackException e) {
                this.outputLog((Exception)((Object)e), "modify()");
                throw e;
            }
            catch (HeuristicMixedException e) {
                this.outputLog((Exception)((Object)e), "modify()");
                throw e;
            }
            catch (HeuristicRollbackException e) {
                this.outputLog((Exception)((Object)e), "modify()");
                throw e;
            }
            catch (SystemException e) {
                this.outputLog((Exception)((Object)e), "modify()");
                throw e;
            }
            finally {
                if (tx != null) {
                    if (!result) {
                        tx.rollback();
                    }
                    tx = null;
                }
            }
            if (oldTx == null) return result;
        }
        catch (Throwable throwable) {
            if (oldTx == null) throw throwable;
            try {
                tm.resume(oldTx);
                throw throwable;
            }
            catch (InvalidTransactionException e) {
                this.outputLog((Exception)((Object)e), "modify()");
                throw e;
            }
            catch (IllegalStateException e) {
                this.outputLog(e, "modify()");
                throw e;
            }
            catch (SystemException e) {
                this.outputLog((Exception)((Object)e), "modify()");
                throw e;
            }
        }
        try {
            tm.resume(oldTx);
            return result;
        }
        catch (InvalidTransactionException e) {
            this.outputLog((Exception)((Object)e), "modify()");
            throw e;
        }
        catch (IllegalStateException e) {
            this.outputLog(e, "modify()");
            throw e;
        }
        catch (SystemException e) {
            this.outputLog((Exception)((Object)e), "modify()");
            throw e;
        }
    }

    public boolean modifyMonitorInfo(String user) throws CreateException, NamingException, FinderException, RemoveException {
        boolean result = false;
        try {
            Timestamp now = new Timestamp(new Date().getTime());
            SnmpTrapInfoLocal info = SnmpTrapInfoUtil.getLocalHome().findByPrimaryKey(new SnmpTrapInfoPK(this.m_monitorInfo.getMonitorId()));
            info.setDescription(this.m_monitorInfo.getDescription());
            info.setFacilityId(this.m_monitorInfo.getFacilityId());
            info.setCommunityName(this.m_monitorInfo.getCommunityName());
            info.setNotifyId(this.m_monitorInfo.getNotifyId());
            info.setApplication(this.m_monitorInfo.getApplication());
            info.setValidFlg(this.m_monitorInfo.getValid());
            info.setCalendarId(this.m_monitorInfo.getCalendarId());
            info.setUpdateDate(now);
            info.setUpdateUser(user);
            Collection ct = info.getSnmpTrapOidInfo();
            if (ct != null && ct.size() > 0) {
                Object[] infoArray = ct.toArray();
                for (int j = 0; j < infoArray.length; ++j) {
                    SnmpTrapOidInfoLocal oidInfo = (SnmpTrapOidInfoLocal)infoArray[j];
                    if (oidInfo == null) continue;
                    oidInfo.remove();
                }
            }
            if (this.m_monitorInfo.getOidInfos() != null) {
                for (int i = 0; i < this.m_monitorInfo.getOidInfos().size(); ++i) {
                    MonitorSnmpTrapOidInfo oidInfo = this.m_monitorInfo.getOidInfos().get(i);
                    SnmpTrapMasterLocal master = SnmpTrapMasterUtil.getLocalHome().findByPrimaryKey(new SnmpTrapMasterPK(oidInfo.getMib(), oidInfo.getTrapOid(), oidInfo.getGenericId(), oidInfo.getSpecificId()));
                    String descr = new String();
                    if (oidInfo.getDescr() != null && master.getDescr() != null && !oidInfo.getDescr().equalsIgnoreCase(master.getDescr())) {
                        if (!oidInfo.getDescr().equalsIgnoreCase(master.getDescr())) {
                            descr = oidInfo.getDescr();
                        }
                    } else {
                        descr = oidInfo.getDescr();
                    }
                    SnmpTrapOidInfoUtil.getLocalHome().create(oidInfo.getMonitorId(), oidInfo.getMib(), oidInfo.getTrapOid(), new Integer(oidInfo.getGenericId()), new Integer(oidInfo.getSpecificId()), new Integer(oidInfo.getValidFlg()), new Integer(oidInfo.getPriority()), oidInfo.getLogmsg(), descr);
                }
            }
            result = true;
        }
        catch (CreateException e) {
            this.outputLog((Exception)((Object)e), "modifyMonitorInfo()");
            throw e;
        }
        catch (NamingException e) {
            this.outputLog(e, "modifyMonitorInfo()");
            throw e;
        }
        catch (FinderException e) {
            this.outputLog((Exception)((Object)e), "modifyMonitorInfo()");
            throw e;
        }
        catch (EJBException e) {
            this.outputLog((Exception)((Object)e), "modifyMonitorInfo()");
            throw e;
        }
        catch (RemoveException e) {
            this.outputLog((Exception)((Object)e), "modifyMonitorInfo()");
            throw e;
        }
        return result;
    }

    private void outputLog(Exception e, String method) {
        AplLogger apllog = new AplLogger("TRAP", "trap");
        Object[] args = new String[]{this.m_monitorInfo.getMonitorId()};
        apllog.put("SYS", "002", args);
        m_log.debug((Object)(method + ":" + e.getMessage()));
    }
}

