/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.vm;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.postgresforest.Driver;

public class DistError {
    private static final String ERR_PROPERTY = "org.postgresforest.disterror";
    private static final String ERR_ID_KEY = "error.broken.status";
    private static final String ERR_MSG_KEY = "error.broken";
    private static final String ERR_ROLLBACK_ID_KEY = "error.rollback.status";
    private static final String ERR_ROLLBACK_MSG_KEY = "error.rollback";
    private static final int FIND = 0;
    private static final int MATCH = 1;
    private static DistError m_instance = null;
    private ArrayList m_brokenMatcherList;
    private ArrayList m_idMatcherList;
    private ArrayList m_rollBackMatcherList;
    private ArrayList m_rollBackIdMatcherList;

    public DistError() {
        ResourceBundle bundle;
        try {
            bundle = ResourceBundle.getBundle(ERR_PROPERTY);
        }
        catch (MissingResourceException e) {
            bundle = null;
        }
        this.m_brokenMatcherList = this.readErrProperty(ERR_MSG_KEY, bundle);
        this.m_idMatcherList = this.readErrProperty(ERR_ID_KEY, bundle);
        this.m_rollBackMatcherList = this.readErrProperty(ERR_ROLLBACK_MSG_KEY, bundle);
        this.m_rollBackIdMatcherList = this.readErrProperty(ERR_ROLLBACK_ID_KEY, bundle);
        if (Driver.logInfo) {
            Driver.info("The separation error message list was read.");
        }
    }

    private ArrayList readErrProperty(String key, ResourceBundle bundle) {
        String pattern = bundle.getString(key);
        String[] patternList = pattern.split("\\s+");
        ArrayList<Matcher> matcherList = new ArrayList<Matcher>(patternList.length);
        for (int i = 0; i < patternList.length; ++i) {
            Pattern ps = Pattern.compile(patternList[i]);
            Matcher mt = ps.matcher("");
            matcherList.add(mt);
        }
        return matcherList;
    }

    private static final synchronized DistError getInstance() {
        if (m_instance == null) {
            m_instance = new DistError();
        }
        return m_instance;
    }

    public static final boolean isBroken(SQLException ex) {
        DistError dist = DistError.getInstance();
        String status = ex.getSQLState();
        if (Driver.logDebug) {
            Driver.debug("Error judging SQLException = " + status, ex);
        }
        if (ex.getSQLState() != null) {
            return dist._isBroken(status);
        }
        return dist._isBroken(ex);
    }

    private final boolean _isBroken(SQLException ex) {
        String msg = ex.getMessage();
        return DistError._isBroken(msg, this.m_brokenMatcherList, 0);
    }

    private final boolean _isBroken(String status) {
        return DistError._isBroken(status, this.m_idMatcherList, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean _isBroken(String status, ArrayList matcherList, int type) {
        if (Driver.logDebug) {
            Driver.debug("_isBroken(String status, ArrayList matcherList) in..");
        }
        boolean ret = false;
        Iterator iter = matcherList.iterator();
        while (iter.hasNext()) {
            Matcher mt;
            Matcher matcher = mt = (Matcher)iter.next();
            synchronized (matcher) {
                mt.reset(status);
                ret = type == 0 ? mt.find() : mt.matches();
            }
            if (!ret) continue;
            break;
        }
        if (Driver.logDebug) {
            Driver.debug("  ret:" + ret);
            Driver.debug("_isBroken(String status, ArrayList matcherList) out..");
        }
        return ret;
    }

    public static final boolean isRollBack(SQLException ex) {
        DistError dist = DistError.getInstance();
        String status = ex.getSQLState();
        if (Driver.logDebug) {
            Driver.debug("Error judging SQLException = " + status, ex);
        }
        if (ex.getSQLState() != null) {
            return dist._isRollBack(status);
        }
        return dist._isRollBack(ex);
    }

    private final boolean _isRollBack(SQLException ex) {
        String msg = ex.getMessage();
        return DistError._isBroken(msg, this.m_rollBackMatcherList, 0);
    }

    private final boolean _isRollBack(String status) {
        return DistError._isBroken(status, this.m_rollBackIdMatcherList, 1);
    }
}

