/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.vm;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import org.postgresforest.Driver;
import org.postgresforest.jdbc3.Jdbc3Connection;
import org.postgresforest.vm.GSCdata;
import org.postgresforest.vm.NoPartitionParser;
import org.postgresforest.vm.Parser;
import org.postgresforest.vm.QueryInfo;
import org.postgresforest.vm.ReWriter;

public class NoPartitionReWriter
extends ReWriter {
    public NoPartitionReWriter(GSCdata gsc) {
        super(gsc);
    }

    public void setSrcSql(String sql) throws SQLException {
        this.clearSrcSql();
        this.m_srcSql = sql;
        this.m_paser.parse(this.m_srcSql);
        if (Driver.logInfo) {
            this.m_logUtil.info("Parser was completed. (" + this.m_srcSql + ")");
        }
        if (this.m_paser.getType() == 15) {
            this.makeSelectQuery(this.m_paser);
        } else {
            this.makeOtherQuery();
        }
        if (Driver.logInfo) {
            for (int i = 0; i < this.m_info.size(); ++i) {
                QueryInfo qi = (QueryInfo)this.m_info.get(i);
                Jdbc3Connection con = (Jdbc3Connection)qi.getConnection();
                this.m_logUtil.info("ReWriter Result: Connection URL = " + con.getURL());
                this.m_logUtil.info("ReWriter Result: Partition No = " + qi.getPartNo());
                this.m_logUtil.info("ReWriter Result: The rewritten SQL = " + qi.getSql());
                String[] tables = qi.getTables();
                String allname = "";
                try {
                    for (int j = 0; j < tables.length; ++j) {
                        allname = allname + tables[j] + ",";
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.m_logUtil.info("ReWriter Result: Extraction Table Name = " + allname);
            }
        }
    }

    protected void makeSelectQuery(Parser ps) throws SQLException {
        if (ps.isForUpdate()) {
            this.makeOtherQuery();
        } else {
            if (Driver.forestTestLog) {
                System.out.println("The query type was specified to be dispersion.");
            }
            if (Driver.logInfo) {
                this.m_logUtil.info("The query type was specified to be dispersion.");
            }
            this.m_queyType = 1;
            Connection con = this.m_gsc.getDistServer();
            QueryInfo qf = new QueryInfo();
            qf.setConnection(con);
            qf.setSql(this.m_srcSql);
            this.m_info.add(qf);
        }
    }

    protected void clearSrcSql() {
        this.m_srcSql = null;
        if (this.m_info == null) {
            this.m_info = new ArrayList();
        } else {
            this.m_info.clear();
        }
        if (this.m_paser == null) {
            this.m_paser = new NoPartitionParser(this.m_logUtil);
        }
        this.m_queyType = -1;
    }
}

