/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.calendar.ejb.entity;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Set;

import javax.ejb.FinderException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 *
 * <!-- begin-user-doc --> You can insert your documentation for '<em><b>CalendarAddInfoBean</b></em>'. <!-- end-user-doc --> *
 *
 * <!-- begin-xdoclet-definition -->
 * @ejb.bean name="CalendarAddInfo"
 *	jndi-name="CalendarAddInfo"
 *	type="CMP" 
 *  schema="CalendarAddInfo" 
 *  cmp-version="2.x"
 *  data-source="java:/HinemosDS"
 *  primkey-field="calendar_id","time_from","time_to"
 * 
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @ejb.persistence 
 *   table-name="cc_cal_add_info" 
 * 
 * @ejb.permission
 *     unchecked="true"
 *     
 * @ejb.finder 
 *    query="SELECT OBJECT(a) FROM CalendarAddInfo as a"  
 *    signature="java.util.Collection findAll()"  
 *    
 * @ejb.finder 
 *    query="SELECT OBJECT(a) FROM CalendarAddInfo as a WHERE a.calendar_id = ?1"  
 *    signature="java.util.Collection findByCalendarId(java.lang.String calendarId)"  
 *
 * @ejb.finder 
 *    query="SELECT OBJECT(a) FROM CalendarAddInfo as a WHERE a.calendar_id = ?1 AND ((a.time_from <= ?2 AND a.time_to >= ?2) OR (a.time_from <= ?3 AND a.time_to >= ?3) OR (a.time_from >= ?2 AND a.time_to <= ?3))"  
 *    signature="java.util.Collection findByTimeFromTo(java.lang.String calendarId, java.util.Date from, java.util.Date to)"  
 *
 * @ejb.select
 *    result-type-mapping= "Local" 
 *    method-intf= "LocalHome"
 *    query=""
 *    signature="java.util.Collection ejbSelectGeneric(java.lang.String jbossQL, java.lang.Object[] arg)"
 * @jboss.query
 *    dynamic="true"
 *    signature="java.util.Collection ejbSelectGeneric(java.lang.String jbossQL, java.lang.Object[] arg)"
 *
 * @ejb.pk class="com.clustercontrol.calendar.ejb.entity.CalendarAddInfoPK"
 * <!-- end-xdoclet-definition -->
 * @generated
 **/
public abstract class CalendarAddInfoBean implements javax.ejb.EntityBean {
	protected static Log m_log = LogFactory.getLog( CalendarAddInfoBean.class );
	
	/**
	 *
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.create-method 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public CalendarAddInfoPK ejbCreate(
			String calendar_id, 
			Date time_from, 
			Date time_to, 
			Integer execute_flg, 
			String description, 
			Date reg_date, 
			Date update_date, 
			String reg_user, 
			String update_user
			) throws javax.ejb.CreateException {
		setCalendar_id(calendar_id);
		setTime_from(time_from);
		setTime_to(time_to);
		setExecute_flg(execute_flg);
		setDescription(description);
		setReg_date(reg_date);
		setUpdate_date(update_date);
		setReg_user(reg_user);
		setUpdate_user(update_user);
		return null;
	}
	
	
	/**
	 * <!-- begin-user-doc -->
	 * The container invokes this method immediately after it calls ejbCreate.
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void ejbPostCreate() throws javax.ejb.CreateException {
		// begin-user-code
		// end-user-code
	}
	
	/** 
	 * DynamicQL
	 * 
	 * @param jbossQl JBossQL
	 * @param args query arguments as parameters
	 * 
	 * @jboss.dynamic-ql 
	 */
	public abstract Set ejbSelectGeneric(String jbossQl, Object[] arguments) throws FinderException;
	
	/**
	 * 履歴フィルタ用検索
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.home-method
	 *  view-type= "local"
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	public Collection ejbHomeSelectSchdule(
			String calendarId, 
	        Date checkDate) throws FinderException {
		
    	Calendar checkCalendar = Calendar.getInstance();
    	checkCalendar.setTime(checkDate);
    	checkCalendar.set(Calendar.HOUR_OF_DAY, 0);
    	checkCalendar.set(Calendar.MINUTE, 0);
    	checkCalendar.set(Calendar.SECOND, 0);
        Date start = checkCalendar.getTime();
        
    	checkCalendar.set(Calendar.HOUR_OF_DAY, 23);
    	checkCalendar.set(Calendar.MINUTE, 59);
    	checkCalendar.set(Calendar.SECOND, 59);
        Date end = checkCalendar.getTime();
        
		StringBuffer jbossQl = new StringBuffer();
		jbossQl.append("SELECT OBJECT(a) ");
		jbossQl.append("FROM CalendarAddInfo as a ");
		jbossQl.append("WHERE a.calendar_id = '" + calendarId + "'");
		jbossQl.append(" AND a.execute_flg = 1");
		
		ArrayList arguments = new ArrayList();
		int count = 1;
		
		jbossQl.append(" AND ((a.time_from >= ?" + count);
		arguments.add(start);
		count++;
		
		jbossQl.append(" AND a.time_to <= ?" + count + ")");
		arguments.add(end);
		count++;
		
		jbossQl.append(" OR (a.time_from <= ?" + count);
		arguments.add(start);
		count++;
		
		jbossQl.append(" AND a.time_to >= ?" + count + ")");
		arguments.add(start);
		count++;
		
		jbossQl.append(" OR (a.time_from <= ?" + count);
		arguments.add(end);
		count++;
		
		jbossQl.append(" AND a.time_to >= ?" + count + "))");
		arguments.add(end);
		count++;
		
		Object[] args = arguments.toArray();
		m_log.debug(jbossQl.toString());
		return ejbSelectGeneric(jbossQl.toString(), args);
	}
	
	/**
	 * 履歴フィルタ用検索
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.home-method
	 *  view-type= "local"
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	public Collection ejbHomeSelectNoSchdule(
			String calendarId, 
	        Date start,
	        Date end) throws FinderException {
		
		StringBuffer jbossQl = new StringBuffer();
		jbossQl.append("SELECT OBJECT(a) ");
		jbossQl.append("FROM CalendarAddInfo as a ");
		jbossQl.append("WHERE a.calendar_id = '" + calendarId + "'");
		jbossQl.append(" AND a.execute_flg = 0");
		
		ArrayList arguments = new ArrayList();
		int count = 1;
		
		jbossQl.append(" AND ((a.time_from <= ?" + count);
		arguments.add(start);
		count++;
		
		jbossQl.append(" AND a.time_to >= ?" + count + "))");
		arguments.add(end);
		count++;
		
		Object[] args = arguments.toArray();
		m_log.debug(jbossQl.toString());
		return ejbSelectGeneric(jbossQl.toString(), args);
	}
	
	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field calendar_id
	 *
	 * Returns the calendar_id
	 * @return the calendar_id
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="calendar_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR"
	 *     read-only="false"
	 * 
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getCalendar_id();
	
	/**
	 * <!-- begin-user-doc -->
	 * Sets the calendar_id
	 * 
	 * @param java.lang.String the new calendar_id value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setCalendar_id(java.lang.String calendar_id);
	
	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field time_from
	 *
	 * Returns the time_from
	 * @return the time_from
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="time_from"
	 *     jdbc-type="TIMESTAMP"
	 *     sql-type="TIMESTAMP"
	 *     read-only="false"
	 *  
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.util.Date getTime_from();
	
	/**
	 * <!-- begin-user-doc -->
	 * Sets the time_from
	 * 
	 * @param java.util.Date the new time_from value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setTime_from(java.util.Date time_from);
	
	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field time_to
	 *
	 * Returns the time_to
	 * @return the time_to
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="time_to"
	 *     jdbc-type="TIMESTAMP"
	 *     sql-type="TIMESTAMP"
	 *     read-only="false"
	 *     
	 * @ejb.pk-field 
	 * 
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.util.Date getTime_to();
	
	/**
	 * <!-- begin-user-doc -->
	 * Sets the time_to
	 * 
	 * @param java.util.Date the new time_to value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setTime_to(java.util.Date time_to);
	

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field execute_flg
	 *
	 * Returns the execute_flg
	 * @return the execute_flg
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="execute_flg"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="SMALLINT"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.Integer getExecute_flg();
	
	/**
	 * <!-- begin-user-doc -->
	 * Sets the execute_flg
	 * 
	 * @param java.lang.Integer the new execute_flg value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setExecute_flg(java.lang.Integer execute_flg);
	
	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field description
	 *
	 * Returns the description
	 * @return the description
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="description"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getDescription();
	
	/**
	 * <!-- begin-user-doc -->
	 * Sets the description
	 * 
	 * @param java.lang.String the new description value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setDescription(java.lang.String description);
	
	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field reg_date
	 *
	 * Returns the reg_date
	 * @return the reg_date
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="reg_date"
	 *     jdbc-type="TIMESTAMP"
	 *     sql-type="TIMESTAMP"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.util.Date getReg_date();
	
	/**
	 * <!-- begin-user-doc -->
	 * Sets the reg_date
	 * 
	 * @param java.util.Date the new reg_date value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setReg_date(java.util.Date reg_date);
	
	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field update_date
	 *
	 * Returns the update_date
	 * @return the update_date
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="update_date"
	 *     jdbc-type="TIMESTAMP"
	 *     sql-type="TIMESTAMP"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.util.Date getUpdate_date();
	
	/**
	 * <!-- begin-user-doc -->
	 * Sets the update_date
	 * 
	 * @param java.util.Date the new update_date value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setUpdate_date(java.util.Date update_date);
	
	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field reg_user
	 *
	 * Returns the reg_user
	 * @return the reg_user
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="reg_user"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getReg_user();
	
	/**
	 * <!-- begin-user-doc -->
	 * Sets the description
	 * 
	 * @param java.lang.String the new reg_user value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setReg_user(java.lang.String reg_user);
	
	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field update_user
	 *
	 * Returns the update_user
	 * @return the update_user
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="update_user"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getUpdate_user();
	
	/**
	 * <!-- begin-user-doc -->
	 * Sets the description
	 * 
	 * @param java.lang.String the new update_user value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setUpdate_user(java.lang.String update_user);
	
	//	==========================================
	//	 CMR fields
	//	==========================================
	
    /**
     * @ejb.interface-method view-type="local"
     * 
     * @ejb.relation 
     * name="CalendarInfo-CalendarAddInfo"
     * role-name="CalendarAddInfo-CalendarInfo(multi)"
     * cascade-delete="yes"
     * 
	 * @jboss.relation
	 * related-pk-field="calendar_id"
	 * fk-column="calendar_id"
     */
    public abstract CalendarInfoLocal getCalendarInfo();
    
    /**
     * 
     * @ejb.interface-method view-type="local"
     */
    public abstract void setCalendarInfo(CalendarInfoLocal calendarInfo);
}
