/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.accesscontrol.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Locale;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.accesscontrol.ejb.session.AccessController;
import com.clustercontrol.accesscontrol.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * アクセス[ユーザ]ビューのテーブル定義を取得するクラスです。
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class GetUserListTableDefine {
	
    /**
     * マネージャにSessionBean経由でアクセスし、<BR>
     * アクセス[ユーザ]ビューのテーブル定義を取得します。
     * 
     * @return テーブル定義情報（{@link com.clustercontrol.bean.TableColumnInfo}のリスト）
     * 
     * @see com.clustercontrol.accesscontrol.util.EjbConnectionManager
	 * @see com.clustercontrol.accesscontrol.ejb.session.AccessController#getUserListTableDefine(java.util.Locale)
     */
    public static ArrayList get() {
    	AccessController access = EjbConnectionManager
                .getConnectionManager().getAccessController();

        ArrayList tableDefine = null;
        try {
            tableDefine = access
                    .getUserListTableDefine(Locale.getDefault());
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        }
        return tableDefine;
    }
}