/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.accesscontrol.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;

import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.eclipse.jface.dialogs.MessageDialog;
import org.jboss.security.Util;

import com.clustercontrol.accesscontrol.ejb.session.AccessController;
import com.clustercontrol.accesscontrol.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * ユーザのパスワードを変更するクラスです。
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class ModifyPassword {

    /**
     * マネージャにSessionBean経由でアクセスし、<BR>
     * 指定されたユーザIDのユーザのパスワード変更を行います。
     * 
     * @param uid ユーザID
     * @param password パスワード
     * @return 変更に成功した場合、true
     * 
     * @see com.clustercontrol.accesscontrol.util.EjbConnectionManager
	 * @see com.clustercontrol.accesscontrol.ejb.session.AccessController#changePassword(java.lang.String, java.lang.String)
     */
    public boolean change(String uid, String password) {
		AccessController access = 
			EjbConnectionManager.getConnectionManager().getAccessController();
		
        try {
        	String passwordHash = Util.createPasswordHash("MD5", Util.BASE64_ENCODING, null, uid, password);
			
        	access.changePassword(uid, passwordHash);
            return true;
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        } catch (NamingException e) {
        } catch (FinderException e) {
        } catch (RemoveException e) {
		}
        return false;
    }
}