/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.calendar.view;

import java.util.Calendar;
import java.util.Date;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;

import com.clustercontrol.accesscontrol.view.action.ModifyPasswordAction;
import com.clustercontrol.accesscontrol.view.action.UserDeleteAction;
import com.clustercontrol.accesscontrol.view.action.UserModifyAction;
import com.clustercontrol.calendar.composite.CalendarListComposite;
import com.clustercontrol.calendar.composite.CalendarScheduleComposite;
import com.clustercontrol.calendar.view.action.CalendarAddAction;
import com.clustercontrol.calendar.view.action.CalendarDeleteAction;
import com.clustercontrol.calendar.view.action.CalendarModifyAction;
import com.clustercontrol.view.CommonViewPart;

/**
 * カレンダ一覧ビュークラス
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class CalendarListView extends CommonViewPart {
    public static final String ID = "com.clustercontrol.calendar.view.CalendarListView";

	private SashForm m_sash = null;
	
    private CalendarListComposite m_calendarList = null;
    
	private CalendarScheduleComposite m_schedule = null;
	
    protected Date m_base = null;
	
    /**
     * コンストラクタ
     */
    public CalendarListView() {
        super();
    }

    /**
     * ViewPartへのコントロール作成処理
     * 
     * @see org.eclipse.ui.IWorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
     */
    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;

		// サッシュフォーム作成及び設定
        m_sash = new SashForm(parent, SWT.HORIZONTAL);
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		gridData.horizontalSpan = 1;
		m_sash.setLayoutData(gridData);
		
        m_calendarList = new CalendarListComposite(m_sash, SWT.NONE);

        Calendar baseCalendar = Calendar.getInstance();
        baseCalendar.setTime(new Date());
        baseCalendar.add(Calendar.WEEK_OF_MONTH, -1);
        m_base = new Date();
        m_schedule = new CalendarScheduleComposite(m_sash, SWT.NONE, baseCalendar.getTime());
        
		// Sashの境界を調整 左部50% 右部50%
//        m_sash.setWeights(new int[] { 5, 5 });
		
        //ポップアップメニュー作成
        createContextMenu();

        //ビューを更新
        this.update();
    }

    /**
     * ポップアップメニュー作成
     * 
     *  
     */
    protected void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener() {
            /*
             * (non-Javadoc)
             * 
             * @see org.eclipse.jface.action.IMenuListener#menuAboutToShow(org.eclipse.jface.action.IMenuManager)
             */
            public void menuAboutToShow(IMenuManager manager) {
                //メニュー項目設定
                fillContextMenu(manager);
            }
        });

        Menu menu = menuManager.createContextMenu(m_calendarList.getTable());
        m_calendarList.getTable().setMenu(menu);
    }

    /**
     * メニュー項目追加
     * 
     * @param manager
     */
    protected void fillContextMenu(IMenuManager manager) {
        //ビューのアクションのインスタンスを取得
        IToolBarManager toolbar = this.getViewSite().getActionBars()
                .getToolBarManager();
    	ActionContributionItem add = 
    		(ActionContributionItem) toolbar.find(CalendarAddAction.ID);
    	ActionContributionItem modify = 
    		(ActionContributionItem) toolbar.find(CalendarModifyAction.ID);
    	ActionContributionItem delete = 
    		(ActionContributionItem) toolbar.find(CalendarDeleteAction.ID);
    	
    	//ポップアップメニューにアクションを追加
    	manager.add(add.getAction());
    	manager.add(modify.getAction());
    	manager.add(delete.getAction());
    }

    /**
     * カレンダ一覧ビュー更新
     */
    public void update() {
    	m_calendarList.update();
    	
    	Calendar now = Calendar.getInstance();
    	
		Calendar baseCalendar = Calendar.getInstance();
		baseCalendar.setTime(m_base);
		baseCalendar.set(Calendar.HOUR, now.get(Calendar.HOUR));
		baseCalendar.set(Calendar.MINUTE, now.get(Calendar.MINUTE));
		baseCalendar.set(Calendar.SECOND, now.get(Calendar.SECOND));
		m_base = baseCalendar.getTime();
		
    	if(!m_base.equals(m_schedule.getBaseDate())){
    		//ScheduleComposite作成
    		CreateScheduleComposite();
    	}
    	
    	m_schedule.update();
    }
    
    /**
     * ScheduleComposite作成
     */
    public void CreateScheduleComposite() {
		//ScheduleComposite解放
    	m_schedule.dispose();
		
        m_schedule = new CalendarScheduleComposite(m_sash, SWT.NONE, m_base);
	    
	    //SashForm再描画
        m_sash.layout(true, true);
    }
    
    /**
     * コンポジット取得処理
     * 
     * @return
     */
    public CalendarListComposite getListComposite() {
        return m_calendarList;
    }
    
    /**
     * コンポジット取得処理
     * 
     * @return
     */
    public CalendarScheduleComposite getScheduleComposite() {
        return m_schedule;
    }
    
	/**
	 * 表示します。
	 */
	public void showSchedule() {
		m_sash.setMaximizedControl(null);
	}
	
	/**
	 * 隠します。
	 */
	public void hideSchedule() {
		m_sash.setMaximizedControl(m_calendarList);
	}
    
	/**
	 * @return
	 */
	public Date getBaseDate() {
		return m_base;
	}
	
	/**
	 * @param base
	 */
	public void setBaseDate(Date base) {
		m_base = base;
	}
	
    /**
     * ビューのアクションの有効/無効を設定します。
     * 
     * @param num 選択イベント数
     * @param selection ボタン（アクション）を有効にするための情報
     */
    public void setEnabledAction(int num, ISelection selection) {
    	//ビューアクションの使用可/不可を設定
    	super.setEnabledAction(CalendarModifyAction.ID, selection);
    	super.setEnabledAction(CalendarDeleteAction.ID, selection);
    	
    	if (num > 0){
        	super.setEnabledAction(CalendarModifyAction.ID, true);
        	super.setEnabledAction(CalendarDeleteAction.ID, true);
    	} else {
        	super.setEnabledAction(CalendarModifyAction.ID, false);
        	super.setEnabledAction(CalendarDeleteAction.ID, false);
    	}
    }
}