/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.calendar.view.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.calendar.view.CalendarListView;
import com.clustercontrol.dialog.CalendarDialog;

/**
 * カレンダの作成・変更ダイアログによる、カレンダ登録を行うアクションクラスです。
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class ChangeBaseDateAction implements IViewActionDelegate {
	public static final String ID = "com.clustercontrol.calendar.view.action.ChangeBaseDateAction";
	
    private IViewPart viewPart;

    /**
     * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
     */
    public void init(IViewPart viewPart) {
        this.viewPart = viewPart;
    }

    /**
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     */
    public void run(IAction action) {
    	// ダイアログを生成
    	CalendarDialog dialog = new CalendarDialog(this.viewPart.getSite().getShell());
    	
    	// ダイアログにて変更が選択された場合、入力内容をもって登録を行う。
    	if(dialog.open() == IDialogConstants.OK_ID){
    		CalendarListView view = 
    			(CalendarListView)this.viewPart.getAdapter(CalendarListView.class);
    		view.setBaseDate(dialog.getDate());
    		view.update();
    	}
    }

    /**
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
     *      org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {
    }
}