--
-- PostgreSQL database dump
--

SET client_encoding = 'SQL_ASCII';
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- Name: SCHEMA public; Type: COMMENT; Schema: -; Owner: hinemos
--

COMMENT ON SCHEMA public IS 'Standard public schema';


SET search_path = public, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: calculated_data; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE calculated_data (
    collectorid character varying(256) NOT NULL,
    item_code character varying(256) NOT NULL,
    device_index bigint NOT NULL,
    date_time timestamp without time zone NOT NULL,
    facilityid character varying(64) NOT NULL,
    value double precision
);


ALTER TABLE public.calculated_data OWNER TO hinemos;

--
-- Name: cc_acc_lock; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_acc_lock (
    lock_id character varying(64) NOT NULL
);


ALTER TABLE public.cc_acc_lock OWNER TO hinemos;

--
-- Name: cc_cal_add_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_cal_add_info (
    calendar_id character varying(64) NOT NULL,
    time_from timestamp without time zone NOT NULL,
    time_to timestamp without time zone NOT NULL,
    execute_flg smallint NOT NULL,
    description character varying(256),
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    reg_user character varying(64),
    update_user character varying(64)
);


ALTER TABLE public.cc_cal_add_info OWNER TO hinemos;

--
-- Name: cc_cal_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_cal_info (
    calendar_id character varying(64) NOT NULL,
    calendar_name character varying(256) NOT NULL,
    description character varying(256),
    start_time time without time zone,
    valid_time_from timestamp without time zone NOT NULL,
    valid_time_to timestamp without time zone NOT NULL,
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    reg_user character varying(64),
    update_user character varying(64)
);


ALTER TABLE public.cc_cal_info OWNER TO hinemos;

--
-- Name: cc_cal_weekday_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_cal_weekday_info (
    calendar_id character varying(64) NOT NULL,
    weekday smallint NOT NULL,
    time_from time without time zone NOT NULL,
    time_to time without time zone NOT NULL,
    description character varying(256),
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    reg_user character varying(64),
    update_user character varying(64)
);


ALTER TABLE public.cc_cal_weekday_info OWNER TO hinemos;

--
-- Name: cc_crun_cmd_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_crun_cmd_mst (
    command_id character varying(64) NOT NULL,
    type_id character varying(64),
    order_no smallint NOT NULL,
    name_id character varying(256),
    command_type smallint NOT NULL,
    command character varying(256)
);


ALTER TABLE public.cc_crun_cmd_mst OWNER TO hinemos;

--
-- Name: cc_crun_cmd_param_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_crun_cmd_param_mst (
    command_id character varying(64) NOT NULL,
    param_id character varying(64) NOT NULL,
    order_no smallint NOT NULL,
    param_prefix character varying(64)
);


ALTER TABLE public.cc_crun_cmd_param_mst OWNER TO hinemos;

--
-- Name: cc_crun_end_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_crun_end_mst (
    command_id character varying(64) NOT NULL,
    end_status smallint NOT NULL,
    end_value_from smallint NOT NULL,
    end_value_to smallint NOT NULL
);


ALTER TABLE public.cc_crun_end_mst OWNER TO hinemos;

--
-- Name: cc_crun_param_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_crun_param_mst (
    param_id character varying(64) NOT NULL,
    name_id character varying(256) NOT NULL,
    param_type smallint NOT NULL
);


ALTER TABLE public.cc_crun_param_mst OWNER TO hinemos;

--
-- Name: cc_crun_param_select_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_crun_param_select_mst (
    param_id character varying(64) NOT NULL,
    order_no smallint NOT NULL,
    name_id character varying(256) NOT NULL,
    param_value character varying(4096)
);


ALTER TABLE public.cc_crun_param_select_mst OWNER TO hinemos;

--
-- Name: cc_crun_session; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_crun_session (
    session_id character varying(64) NOT NULL,
    start_date timestamp without time zone,
    end_date timestamp without time zone,
    type_id character varying(64) NOT NULL,
    command_id character varying(64),
    facility_id character varying(64) NOT NULL,
    scope_text character varying(256),
    node_cnt smallint NOT NULL,
    wait_cnt smallint NOT NULL,
    running_cnt smallint NOT NULL,
    end_nomal_cnt smallint NOT NULL,
    end_warning_cnt smallint NOT NULL,
    end_abnomal_cnt smallint NOT NULL,
    status smallint NOT NULL
);


ALTER TABLE public.cc_crun_session OWNER TO hinemos;

--
-- Name: cc_crun_session_detail; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_crun_session_detail (
    session_id character varying(64) NOT NULL,
    facility_id character varying(64) NOT NULL,
    start_date timestamp without time zone,
    end_date timestamp without time zone,
    facility_name character varying(256),
    message text,
    error_message text,
    status smallint NOT NULL,
    end_status smallint,
    end_value smallint
);


ALTER TABLE public.cc_crun_session_detail OWNER TO hinemos;

--
-- Name: cc_crun_session_param; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_crun_session_param (
    session_id character varying(64) NOT NULL,
    param_id character varying(64) NOT NULL,
    param_value character varying(4096)
);


ALTER TABLE public.cc_crun_session_param OWNER TO hinemos;

--
-- Name: cc_crun_type_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_crun_type_mst (
    type_id character varying(64) NOT NULL,
    name_id character varying(256) NOT NULL,
    order_no smallint NOT NULL
);


ALTER TABLE public.cc_crun_type_mst OWNER TO hinemos;

--
-- Name: cc_event_log; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_event_log (
    monitor_id character varying(64) NOT NULL,
    plugin_id character varying(64) NOT NULL,
    generation_date timestamp without time zone NOT NULL,
    facility_id character varying(64) NOT NULL,
    scope_text character varying(256) NOT NULL,
    application character varying(64) NOT NULL,
    message_id character varying(64) NOT NULL,
    message character varying(256) NOT NULL,
    message_org text,
    priority smallint NOT NULL,
    confirm_flg smallint NOT NULL,
    confirm_date timestamp without time zone,
    duplication_count smallint NOT NULL,
    output_date timestamp without time zone NOT NULL,
    inhibited_flg smallint NOT NULL
);


ALTER TABLE public.cc_event_log OWNER TO hinemos;

--
-- Name: cc_event_multi_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_event_multi_info (
    monitor_id character varying(64) NOT NULL,
    plugin_id character varying(64) NOT NULL,
    facility_id character varying(64) NOT NULL,
    output_date timestamp without time zone NOT NULL,
    multi_id character varying(64) NOT NULL,
    duplication_count smallint NOT NULL
);


ALTER TABLE public.cc_event_multi_info OWNER TO hinemos;

--
-- Name: cc_job_command_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_command_info (
    session_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    facility_id character varying(64) NOT NULL,
    process_mode smallint NOT NULL,
    start_command character varying(1024),
    stop_command character varying(1024),
    effective_user character varying(64),
    error_end_flg smallint NOT NULL,
    error_end_value smallint NOT NULL,
    argument_job_id character varying(64),
    argument character varying(1024)
);


ALTER TABLE public.cc_job_command_info OWNER TO hinemos;

--
-- Name: cc_job_command_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_command_mst (
    job_id character varying(64) NOT NULL,
    facility_id character varying(64) NOT NULL,
    process_mode smallint NOT NULL,
    start_command character varying(1024),
    stop_command character varying(1024),
    effective_user character varying(64),
    error_end_flg smallint NOT NULL,
    error_end_value smallint NOT NULL,
    argument_job_id character varying(64),
    argument character varying(1024)
);


ALTER TABLE public.cc_job_command_mst OWNER TO hinemos;

--
-- Name: cc_job_end_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_end_info (
    session_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    end_status smallint NOT NULL,
    end_value smallint NOT NULL,
    end_value_from smallint NOT NULL,
    end_value_to smallint NOT NULL
);


ALTER TABLE public.cc_job_end_info OWNER TO hinemos;

--
-- Name: cc_job_end_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_end_mst (
    job_id character varying(64) NOT NULL,
    end_status smallint NOT NULL,
    end_value smallint NOT NULL,
    end_value_from smallint NOT NULL,
    end_value_to smallint NOT NULL
);


ALTER TABLE public.cc_job_end_mst OWNER TO hinemos;

--
-- Name: cc_job_file_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_file_info (
    session_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    process_mode smallint NOT NULL,
    src_facility_id character varying(64) NOT NULL,
    dest_facility_id character varying(64) NOT NULL,
    src_file character varying(4096) NOT NULL,
    src_work_dir character varying(4096) NOT NULL,
    dest_directory character varying(4096) NOT NULL,
    dest_work_dir character varying(4096) NOT NULL,
    compression_flg smallint NOT NULL,
    check_flg smallint NOT NULL,
    effective_user character varying(64) NOT NULL
);


ALTER TABLE public.cc_job_file_info OWNER TO hinemos;

--
-- Name: cc_job_file_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_file_mst (
    job_id character varying(64) NOT NULL,
    process_mode smallint NOT NULL,
    src_facility_id character varying(64) NOT NULL,
    dest_facility_id character varying(64) NOT NULL,
    src_file character varying(4096) NOT NULL,
    src_work_dir character varying(4096) NOT NULL,
    dest_directory character varying(4096) NOT NULL,
    dest_work_dir character varying(4096) NOT NULL,
    compression_flg smallint NOT NULL,
    check_flg smallint NOT NULL,
    effective_user character varying(64) NOT NULL
);


ALTER TABLE public.cc_job_file_mst OWNER TO hinemos;

--
-- Name: cc_job_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_info (
    session_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    job_name character varying(64) NOT NULL,
    description character varying(256) NOT NULL,
    job_type smallint NOT NULL,
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    reg_user character varying(64),
    update_user character varying(64)
);


ALTER TABLE public.cc_job_info OWNER TO hinemos;

--
-- Name: cc_job_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_mst (
    job_id character varying(64) NOT NULL,
    job_name character varying(64) NOT NULL,
    description character varying(256) NOT NULL,
    job_type smallint NOT NULL,
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    reg_user character varying(64),
    update_user character varying(64)
);


ALTER TABLE public.cc_job_mst OWNER TO hinemos;

--
-- Name: cc_job_notice_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_notice_info (
    session_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    notice_type smallint NOT NULL,
    priority smallint NOT NULL,
    notify_id character varying(64)
);


ALTER TABLE public.cc_job_notice_info OWNER TO hinemos;

--
-- Name: cc_job_notice_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_notice_mst (
    job_id character varying(64) NOT NULL,
    notice_type smallint NOT NULL,
    priority smallint NOT NULL,
    notify_id character varying(64)
);


ALTER TABLE public.cc_job_notice_mst OWNER TO hinemos;

--
-- Name: cc_job_param_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_param_info (
    session_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    param_id character varying(64) NOT NULL,
    param_type smallint NOT NULL,
    description character varying(256),
    value character varying(1024)
);


ALTER TABLE public.cc_job_param_info OWNER TO hinemos;

--
-- Name: cc_job_param_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_param_mst (
    job_id character varying(64) NOT NULL,
    param_id character varying(64) NOT NULL,
    param_type smallint NOT NULL,
    description character varying(256),
    value character varying(1024)
);


ALTER TABLE public.cc_job_param_mst OWNER TO hinemos;

--
-- Name: cc_job_relation_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_relation_info (
    session_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    parent_job_id character varying(64) NOT NULL
);


ALTER TABLE public.cc_job_relation_info OWNER TO hinemos;

--
-- Name: cc_job_relation_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_relation_mst (
    job_id character varying(64) NOT NULL,
    parent_job_id character varying(64) NOT NULL
);


ALTER TABLE public.cc_job_relation_mst OWNER TO hinemos;

--
-- Name: cc_job_session; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_session (
    session_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    schedule_date timestamp without time zone,
    operation_flg smallint NOT NULL
);


ALTER TABLE public.cc_job_session OWNER TO hinemos;

--
-- Name: cc_job_session_job; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_session_job (
    session_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    scope_text character varying(256),
    status smallint NOT NULL,
    start_date timestamp without time zone,
    end_date timestamp without time zone,
    end_value smallint,
    end_status smallint,
    result character varying(1024),
    end_staus_check_flg smallint,
    delay_notify_flg smallint
);


ALTER TABLE public.cc_job_session_job OWNER TO hinemos;

--
-- Name: cc_job_session_node; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_session_node (
    session_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    facility_id character varying(64) NOT NULL,
    node_name character varying(256),
    status smallint NOT NULL,
    start_date timestamp without time zone,
    end_date timestamp without time zone,
    end_value smallint,
    message text,
    agent_check smallint,
    check_date timestamp without time zone,
    retry_count smallint,
    result character varying(1024),
    status_buffer smallint
);


ALTER TABLE public.cc_job_session_node OWNER TO hinemos;

--
-- Name: cc_job_start_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_start_info (
    session_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    condition_type smallint NOT NULL,
    suspend smallint NOT NULL,
    skip smallint NOT NULL,
    skip_end_status smallint NOT NULL,
    skip_end_value smallint NOT NULL,
    unmatch_end_flg smallint NOT NULL,
    unmatch_end_status smallint NOT NULL,
    unmatch_end_value smallint NOT NULL,
    calendar smallint NOT NULL,
    calendar_id character varying(64),
    calendar_end_value smallint NOT NULL,
    start_delay smallint NOT NULL,
    start_delay_session smallint NOT NULL,
    start_delay_session_value smallint NOT NULL,
    start_delay_time smallint NOT NULL,
    start_delay_time_value time without time zone,
    start_delay_condition_type smallint NOT NULL,
    start_delay_notify smallint NOT NULL,
    start_delay_notify_priority smallint NOT NULL,
    start_delay_operation smallint NOT NULL,
    start_delay_operation_type smallint NOT NULL,
    start_delay_operation_end_value smallint NOT NULL,
    end_delay smallint NOT NULL,
    end_delay_session smallint NOT NULL,
    end_delay_session_value smallint NOT NULL,
    end_delay_job smallint NOT NULL,
    end_delay_job_value smallint NOT NULL,
    end_delay_time smallint NOT NULL,
    end_delay_time_value time without time zone,
    end_delay_condition_type smallint NOT NULL,
    end_delay_notify smallint NOT NULL,
    end_delay_notify_priority smallint NOT NULL,
    end_delay_operation smallint NOT NULL,
    end_delay_operation_type smallint NOT NULL,
    end_delay_operation_end_value smallint NOT NULL
);


ALTER TABLE public.cc_job_start_info OWNER TO hinemos;

--
-- Name: cc_job_start_job_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_start_job_info (
    session_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    target_job_id character varying(64) NOT NULL,
    target_job_type smallint NOT NULL,
    target_job_end_value smallint NOT NULL
);


ALTER TABLE public.cc_job_start_job_info OWNER TO hinemos;

--
-- Name: cc_job_start_job_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_start_job_mst (
    job_id character varying(64) NOT NULL,
    target_job_id character varying(64) NOT NULL,
    target_job_type smallint NOT NULL,
    target_job_end_value smallint NOT NULL
);


ALTER TABLE public.cc_job_start_job_mst OWNER TO hinemos;

--
-- Name: cc_job_start_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_start_mst (
    job_id character varying(64) NOT NULL,
    condition_type smallint NOT NULL,
    suspend smallint NOT NULL,
    skip smallint NOT NULL,
    skip_end_status smallint NOT NULL,
    skip_end_value smallint NOT NULL,
    unmatch_end_flg smallint NOT NULL,
    unmatch_end_status smallint NOT NULL,
    unmatch_end_value smallint NOT NULL,
    calendar smallint NOT NULL,
    calendar_id character varying(64),
    calendar_end_value smallint NOT NULL,
    start_delay smallint NOT NULL,
    start_delay_session smallint NOT NULL,
    start_delay_session_value smallint NOT NULL,
    start_delay_time smallint NOT NULL,
    start_delay_time_value time without time zone,
    start_delay_condition_type smallint NOT NULL,
    start_delay_notify smallint NOT NULL,
    start_delay_notify_priority smallint NOT NULL,
    start_delay_operation smallint NOT NULL,
    start_delay_operation_type smallint NOT NULL,
    start_delay_operation_end_value smallint NOT NULL,
    end_delay smallint NOT NULL,
    end_delay_session smallint NOT NULL,
    end_delay_session_value smallint NOT NULL,
    end_delay_job smallint NOT NULL,
    end_delay_job_value smallint NOT NULL,
    end_delay_time smallint NOT NULL,
    end_delay_time_value time without time zone,
    end_delay_condition_type smallint NOT NULL,
    end_delay_notify smallint NOT NULL,
    end_delay_notify_priority smallint NOT NULL,
    end_delay_operation smallint NOT NULL,
    end_delay_operation_type smallint NOT NULL,
    end_delay_operation_end_value smallint NOT NULL
);


ALTER TABLE public.cc_job_start_mst OWNER TO hinemos;

--
-- Name: cc_job_start_time_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_start_time_info (
    session_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    start_time time without time zone NOT NULL
);


ALTER TABLE public.cc_job_start_time_info OWNER TO hinemos;

--
-- Name: cc_job_start_time_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_start_time_mst (
    job_id character varying(64) NOT NULL,
    start_time time without time zone NOT NULL
);


ALTER TABLE public.cc_job_start_time_mst OWNER TO hinemos;

--
-- Name: cc_log_transfer_file_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_log_transfer_file_info (
    transfer_id character varying(64) NOT NULL,
    file_path character varying(4096) NOT NULL,
    run_interval smallint,
    existence_flg smallint,
    valid_flg smallint NOT NULL
);


ALTER TABLE public.cc_log_transfer_file_info OWNER TO hinemos;

--
-- Name: cc_log_transfer_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_log_transfer_info (
    transfer_id character varying(64) NOT NULL,
    description character varying(256),
    facility_id character varying(64),
    valid_flg smallint NOT NULL,
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    reg_user character varying(64),
    update_user character varying(64)
);


ALTER TABLE public.cc_log_transfer_info OWNER TO hinemos;

--
-- Name: cc_monitor_agent_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_monitor_agent_info (
    monitor_type_id character varying(64) NOT NULL,
    monitor_id character varying(64) NOT NULL,
    check_job_agent smallint,
    check_log_agent smallint
);


ALTER TABLE public.cc_monitor_agent_info OWNER TO hinemos;

--
-- Name: cc_monitor_http_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_monitor_http_info (
    monitor_type_id character varying(64) NOT NULL,
    monitor_id character varying(64) NOT NULL,
    request_url character varying(2083) NOT NULL,
    url_replace smallint,
    proxy_set smallint,
    proxy_host character varying(64),
    proxy_port smallint,
    timeout smallint
);


ALTER TABLE public.cc_monitor_http_info OWNER TO hinemos;

--
-- Name: cc_monitor_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_monitor_info (
    monitor_type_id character varying(64) NOT NULL,
    monitor_id character varying(64) NOT NULL,
    monitor_type smallint NOT NULL,
    description character varying(256),
    facility_id character varying(64),
    run_interval smallint,
    calendar_id character varying(64),
    monitor_block smallint,
    determination_id character varying(64),
    failure_priority smallint,
    notify_id character varying(64),
    application character varying(64),
    job_run smallint,
    failure_message_id character varying(64),
    failure_message character varying(256),
    failure_job_run smallint,
    failure_job_id character varying(64),
    failure_job_inhibition_flg smallint,
    failure_job_failure_priority smallint,
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    reg_user character varying(64),
    update_user character varying(64),
    timeout smallint
);


ALTER TABLE public.cc_monitor_info OWNER TO hinemos;

--
-- Name: cc_monitor_numeric_value_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_monitor_numeric_value_info (
    monitor_type_id character varying(64) NOT NULL,
    monitor_id character varying(64) NOT NULL,
    priority smallint NOT NULL,
    threshold_upper_limit double precision NOT NULL,
    threshold_lower_limit double precision NOT NULL,
    message_id character varying(64),
    message character varying(256),
    job_run smallint,
    job_id character varying(64),
    job_inhibition_flg smallint,
    job_failure_priority smallint
);


ALTER TABLE public.cc_monitor_numeric_value_info OWNER TO hinemos;

--
-- Name: cc_monitor_perf_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_monitor_perf_info (
    monitor_type_id character varying(64) NOT NULL,
    monitor_id character varying(64) NOT NULL,
    collector_id character varying(256),
    item_code character varying(256),
    device_index smallint,
    device_name character varying(256)
);


ALTER TABLE public.cc_monitor_perf_info OWNER TO hinemos;

--
-- Name: cc_monitor_ping_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_monitor_ping_info (
    monitor_type_id character varying(64) NOT NULL,
    monitor_id character varying(64) NOT NULL,
    run_count smallint,
    run_interval smallint,
    timeout smallint
);


ALTER TABLE public.cc_monitor_ping_info OWNER TO hinemos;

--
-- Name: cc_monitor_process_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_monitor_process_info (
    monitor_type_id character varying(64) NOT NULL,
    monitor_id character varying(64) NOT NULL,
    command character varying(256) NOT NULL,
    param character varying(256)
);


ALTER TABLE public.cc_monitor_process_info OWNER TO hinemos;

--
-- Name: cc_monitor_snmp_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_monitor_snmp_info (
    monitor_type_id character varying(64) NOT NULL,
    monitor_id character varying(64) NOT NULL,
    community_name character varying(64) NOT NULL,
    snmp_oid character varying(64) NOT NULL,
    convert_flg smallint NOT NULL
);


ALTER TABLE public.cc_monitor_snmp_info OWNER TO hinemos;

--
-- Name: cc_monitor_snmp_value; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_monitor_snmp_value (
    monitor_id character varying(64) NOT NULL,
    facility_id character varying(64) NOT NULL,
    value double precision NOT NULL,
    get_date timestamp without time zone NOT NULL
);


ALTER TABLE public.cc_monitor_snmp_value OWNER TO hinemos;

--
-- Name: cc_monitor_sql_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_monitor_sql_info (
    monitor_type_id character varying(64) NOT NULL,
    monitor_id character varying(64) NOT NULL,
    connection_url character varying(256) NOT NULL,
    connection_user character varying(64) NOT NULL,
    connection_password character varying(64) NOT NULL,
    query character varying(1024) NOT NULL,
    jdbc_driver character varying(256) NOT NULL
);


ALTER TABLE public.cc_monitor_sql_info OWNER TO hinemos;

--
-- Name: cc_monitor_string_value_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_monitor_string_value_info (
    monitor_type_id character varying(64) NOT NULL,
    monitor_id character varying(64) NOT NULL,
    order_no smallint NOT NULL,
    description character varying(256),
    process_type smallint NOT NULL,
    pattern character varying(1024) NOT NULL,
    priority smallint NOT NULL,
    message_id character varying(64),
    message character varying(256),
    notify_id character varying(64),
    job_run smallint,
    job_id character varying(64),
    job_inhibition_flg smallint,
    job_failure_priority smallint,
    valid_flg smallint NOT NULL
);


ALTER TABLE public.cc_monitor_string_value_info OWNER TO hinemos;

--
-- Name: cc_monitor_truth_value_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_monitor_truth_value_info (
    monitor_type_id character varying(64) NOT NULL,
    monitor_id character varying(64) NOT NULL,
    priority smallint NOT NULL,
    truth_value smallint NOT NULL,
    message_id character varying(64),
    message character varying(256),
    job_run smallint,
    job_id character varying(64),
    job_inhibition_flg smallint,
    job_failure_priority smallint
);


ALTER TABLE public.cc_monitor_truth_value_info OWNER TO hinemos;

--
-- Name: cc_notify_event_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_notify_event_info (
    notify_id character varying(64) NOT NULL,
    priority smallint NOT NULL,
    event_normal_flg smallint NOT NULL,
    event_normal_state smallint NOT NULL,
    event_inhibition_flg smallint NOT NULL,
    event_inhibition_state smallint,
    mail_flg smallint NOT NULL,
    mail_address character varying(1024)
);


ALTER TABLE public.cc_notify_event_info OWNER TO hinemos;

--
-- Name: cc_notify_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_notify_info (
    notify_id character varying(64) NOT NULL,
    description character varying(256),
    status_flg smallint NOT NULL,
    status_valid_period smallint,
    status_invalid_flg smallint,
    status_update_priority smallint,
    event_flg smallint NOT NULL,
    inhibition_flg smallint NOT NULL,
    inhibition_frequency smallint,
    inhibition_period smallint,
    reg_date timestamp without time zone,
    update_date timestamp without time zone
);


ALTER TABLE public.cc_notify_info OWNER TO hinemos;

--
-- Name: cc_priority_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_priority_info (
    judgment_id character varying(64) NOT NULL,
    description character varying(256),
    pattern_01 smallint,
    pattern_02 smallint,
    pattern_03 smallint,
    pattern_04 smallint,
    pattern_05 smallint,
    pattern_06 smallint,
    pattern_07 smallint,
    pattern_08 smallint,
    pattern_09 smallint,
    pattern_10 smallint,
    pattern_11 smallint,
    pattern_12 smallint,
    pattern_13 smallint,
    pattern_14 smallint,
    pattern_15 smallint,
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    reg_user character varying(64),
    update_user character varying(64)
);


ALTER TABLE public.cc_priority_info OWNER TO hinemos;

--
-- Name: cc_snmp_trap_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_snmp_trap_info (
    monitor_id character varying(64) NOT NULL,
    description character varying(256),
    facility_id character varying(64),
    community_name character varying(64),
    notify_id character varying(64),
    application character varying(64),
    valid_flg smallint NOT NULL,
    calendar_id character varying(64),
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    reg_user character varying(64),
    update_user character varying(64)
);


ALTER TABLE public.cc_snmp_trap_info OWNER TO hinemos;

--
-- Name: cc_snmp_trap_mib_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_snmp_trap_mib_mst (
    mib character varying(64) NOT NULL,
    order_no smallint,
    description character varying(256),
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    reg_user character varying(64),
    update_user character varying(64)
);


ALTER TABLE public.cc_snmp_trap_mib_mst OWNER TO hinemos;

--
-- Name: cc_snmp_trap_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_snmp_trap_mst (
    mib character varying(64) NOT NULL,
    trap_oid character varying(64) NOT NULL,
    generic_id smallint NOT NULL,
    specific_id integer NOT NULL,
    uei character varying(256),
    logmsg character varying(256),
    descr text,
    priority smallint
);


ALTER TABLE public.cc_snmp_trap_mst OWNER TO hinemos;

--
-- Name: cc_snmp_trap_oid_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_snmp_trap_oid_info (
    monitor_id character varying(64) NOT NULL,
    mib character varying(64) NOT NULL,
    trap_oid character varying(64) NOT NULL,
    generic_id smallint NOT NULL,
    specific_id integer NOT NULL,
    valid_flg smallint,
    priority smallint,
    logmsg character varying(256),
    descr text
);


ALTER TABLE public.cc_snmp_trap_oid_info OWNER TO hinemos;

--
-- Name: cc_status_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_status_info (
    facility_id character varying(64) NOT NULL,
    monitor_id character varying(64) NOT NULL,
    plugin_id character varying(64) NOT NULL,
    application character varying(64) NOT NULL,
    message_id character varying(64) NOT NULL,
    message character varying(256) NOT NULL,
    priority smallint NOT NULL,
    generation_date timestamp without time zone NOT NULL,
    output_date timestamp without time zone NOT NULL,
    expiration_flg smallint,
    expiration_date timestamp without time zone
);


ALTER TABLE public.cc_status_info OWNER TO hinemos;

--
-- Name: cc_syslog_monitor_rule; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_syslog_monitor_rule (
    order_no smallint NOT NULL,
    description character varying(256),
    facility_id character varying(64),
    pattern character varying(1024),
    process_type smallint NOT NULL,
    priority smallint NOT NULL,
    monitor_id character varying(64),
    application character varying(64),
    message_id character varying(64),
    message character varying(256),
    notify_id character varying(64),
    calendar_id character varying(64),
    valid_flg smallint NOT NULL,
    job_run smallint,
    job_id character varying(64),
    job_inhibition_flg smallint,
    job_failure_priority smallint,
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    reg_user character varying(64),
    update_user character varying(64)
);


ALTER TABLE public.cc_syslog_monitor_rule OWNER TO hinemos;

--
-- Name: cc_system_notify_event_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_system_notify_event_info (
    notify_id character varying(64) NOT NULL,
    priority smallint NOT NULL,
    event_normal_flg smallint NOT NULL,
    event_normal_state smallint NOT NULL,
    event_inhibition_flg smallint NOT NULL,
    event_inhibition_state smallint,
    mail_flg smallint NOT NULL,
    mail_address character varying(1024)
);


ALTER TABLE public.cc_system_notify_event_info OWNER TO hinemos;

--
-- Name: cc_system_notify_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_system_notify_info (
    notify_id character varying(64) NOT NULL,
    description character varying(256),
    status_flg smallint NOT NULL,
    status_valid_period smallint,
    status_invalid_flg smallint,
    status_update_priority smallint,
    event_flg smallint NOT NULL,
    inhibition_flg smallint NOT NULL,
    inhibition_frequency smallint,
    inhibition_period smallint,
    reg_date timestamp without time zone,
    update_date timestamp without time zone
);


ALTER TABLE public.cc_system_notify_info OWNER TO hinemos;

--
-- Name: collector_item; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE collector_item (
    collectorid character varying(256) NOT NULL,
    itemid bigint NOT NULL,
    item_code character varying(256),
    device_index bigint,
    device_name character varying(256),
    monitor_flag boolean
);


ALTER TABLE public.collector_item OWNER TO hinemos;

--
-- Name: collector_profile; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE collector_profile (
    collectorid character varying(256) NOT NULL,
    collector_type smallint,
    label character varying(1024),
    start_date timestamp without time zone,
    stop_date timestamp without time zone,
    target_facilityid character varying(64),
    scope_path character varying(1024),
    "interval" integer,
    period integer,
    presave_period integer
);


ALTER TABLE public.collector_profile OWNER TO hinemos;

--
-- Name: collector_status; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE collector_status (
    collectorid character varying(256) NOT NULL,
    run_status smallint,
    error_status smallint,
    end_status smallint,
    count bigint,
    last_collect_date timestamp without time zone
);


ALTER TABLE public.collector_status OWNER TO hinemos;

--
-- Name: device; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE device (
    collectorid character varying(256) NOT NULL,
    facilityid character varying(64) NOT NULL,
    device_name character varying(256) NOT NULL,
    objectid character varying(256),
    "index" bigint,
    device_type character varying(256)
);


ALTER TABLE public.device OWNER TO hinemos;

--
-- Name: jms_message_log; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE jms_message_log (
    messageid integer NOT NULL,
    destination character varying(255) NOT NULL,
    txid integer,
    txop character(1),
    lateclone character(1),
    messageblob bytea
);


ALTER TABLE public.jms_message_log OWNER TO hinemos;

--
-- Name: jms_reference_log; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE jms_reference_log (
    messageid integer NOT NULL,
    destination character varying(256) NOT NULL,
    txid integer,
    txop character(1),
    redelivered character(1),
    redelivers integer
);


ALTER TABLE public.jms_reference_log OWNER TO hinemos;

--
-- Name: jms_transaction_log; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE jms_transaction_log (
    txid integer
);


ALTER TABLE public.jms_transaction_log OWNER TO hinemos;

--
-- Name: monitor_setting; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE monitor_setting (
    collectorid character varying(256) NOT NULL,
    itemid bigint NOT NULL,
    monitorid bigint NOT NULL,
    monitor_label character varying(50),
    threshold_value double precision,
    threshold_option bigint,
    notify_address character varying(256),
    severity bigint,
    except_option bigint,
    except_time bigint,
    except_count bigint,
    message character varying(2000),
    event_code character varying(500),
    device_index bigint
);


ALTER TABLE public.monitor_setting OWNER TO hinemos;

--
-- Name: performance_data; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE performance_data (
    collectorid character varying(256) NOT NULL,
    objectid character varying(256) NOT NULL,
    date_time timestamp without time zone NOT NULL,
    facilityid character varying(64) NOT NULL,
    value bigint
);


ALTER TABLE public.performance_data OWNER TO hinemos;

--
-- Name: qrtz_blob_triggers; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE qrtz_blob_triggers (
    trigger_name character varying(80) NOT NULL,
    trigger_group character varying(80) NOT NULL,
    blob_data bytea
);


ALTER TABLE public.qrtz_blob_triggers OWNER TO hinemos;

--
-- Name: qrtz_calendars; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE qrtz_calendars (
    calendar_name character varying(80) NOT NULL,
    calendar bytea NOT NULL
);


ALTER TABLE public.qrtz_calendars OWNER TO hinemos;

--
-- Name: qrtz_cron_triggers; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE qrtz_cron_triggers (
    trigger_name character varying(80) NOT NULL,
    trigger_group character varying(80) NOT NULL,
    cron_expression character varying(80) NOT NULL,
    time_zone_id character varying(80)
);


ALTER TABLE public.qrtz_cron_triggers OWNER TO hinemos;

--
-- Name: qrtz_fired_triggers; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE qrtz_fired_triggers (
    entry_id character varying(95) NOT NULL,
    trigger_name character varying(80) NOT NULL,
    trigger_group character varying(80) NOT NULL,
    is_volatile boolean NOT NULL,
    instance_name character varying(80) NOT NULL,
    fired_time bigint NOT NULL,
    state character varying(16) NOT NULL,
    job_name character varying(80),
    job_group character varying(80),
    is_stateful boolean,
    requests_recovery boolean
);


ALTER TABLE public.qrtz_fired_triggers OWNER TO hinemos;

--
-- Name: qrtz_job_details; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE qrtz_job_details (
    job_name character varying(80) NOT NULL,
    job_group character varying(80) NOT NULL,
    description character varying(120),
    job_class_name character varying(128) NOT NULL,
    is_durable boolean NOT NULL,
    is_volatile boolean NOT NULL,
    is_stateful boolean NOT NULL,
    requests_recovery boolean NOT NULL,
    job_data bytea
);


ALTER TABLE public.qrtz_job_details OWNER TO hinemos;

--
-- Name: qrtz_job_listeners; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE qrtz_job_listeners (
    job_name character varying(80) NOT NULL,
    job_group character varying(80) NOT NULL,
    job_listener character varying(80) NOT NULL
);


ALTER TABLE public.qrtz_job_listeners OWNER TO hinemos;

--
-- Name: qrtz_locks; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE qrtz_locks (
    lock_name character varying(40) NOT NULL
);


ALTER TABLE public.qrtz_locks OWNER TO hinemos;

--
-- Name: qrtz_paused_trigger_grps; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE qrtz_paused_trigger_grps (
    trigger_group character varying(80) NOT NULL
);


ALTER TABLE public.qrtz_paused_trigger_grps OWNER TO hinemos;

--
-- Name: qrtz_scheduler_state; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE qrtz_scheduler_state (
    instance_name character varying(80) NOT NULL,
    last_checkin_time bigint NOT NULL,
    checkin_interval bigint NOT NULL,
    recoverer character varying(80)
);


ALTER TABLE public.qrtz_scheduler_state OWNER TO hinemos;

--
-- Name: qrtz_simple_triggers; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE qrtz_simple_triggers (
    trigger_name character varying(80) NOT NULL,
    trigger_group character varying(80) NOT NULL,
    repeat_count bigint NOT NULL,
    repeat_interval bigint NOT NULL,
    times_triggered bigint NOT NULL
);


ALTER TABLE public.qrtz_simple_triggers OWNER TO hinemos;

--
-- Name: qrtz_trigger_listeners; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE qrtz_trigger_listeners (
    trigger_name character varying(80) NOT NULL,
    trigger_group character varying(80) NOT NULL,
    trigger_listener character varying(80) NOT NULL
);


ALTER TABLE public.qrtz_trigger_listeners OWNER TO hinemos;

--
-- Name: qrtz_triggers; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE qrtz_triggers (
    trigger_name character varying(80) NOT NULL,
    trigger_group character varying(80) NOT NULL,
    job_name character varying(80) NOT NULL,
    job_group character varying(80) NOT NULL,
    is_volatile boolean NOT NULL,
    description character varying(120),
    next_fire_time bigint,
    prev_fire_time bigint,
    trigger_state character varying(16) NOT NULL,
    trigger_type character varying(8) NOT NULL,
    start_time bigint NOT NULL,
    end_time bigint,
    calendar_name character varying(80),
    misfire_instr smallint
);


ALTER TABLE public.qrtz_triggers OWNER TO hinemos;

--
-- Name: scope_relation; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE scope_relation (
    collectorid character varying(256) NOT NULL,
    facilityid character varying(64) NOT NULL,
    parent_facilityid character varying(64) NOT NULL
);


ALTER TABLE public.scope_relation OWNER TO hinemos;

--
-- Name: scope_snap; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE scope_snap (
    collectorid character varying(256) NOT NULL,
    facilityid character varying(64) NOT NULL,
    facility_name character varying(256),
    facility_type character varying(16)
);


ALTER TABLE public.scope_snap OWNER TO hinemos;

--
-- Name: maintenance_type_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE maintenance_type_mst (
    type_id character varying(64) NOT NULL,
    name_id character varying(256) NOT NULL,
    order_no smallint NOT NULL
);

ALTER TABLE public.maintenance_type_mst OWNER TO hinemos;

ALTER TABLE ONLY maintenance_type_mst
    ADD CONSTRAINT p_key_maintenance_type_mst PRIMARY KEY (type_id);



--
-- Name: maintenance_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE maintenance_info (

    maintenance_id character varying(64) NOT NULL,
    description character varying(256),
	type_id character varying(64) NOT NULL,
    calendar_id character varying(64),
    schedule_date timestamp without time zone,
    notify_id character varying(64),
    application character varying(64),
    valid_flg smallint NOT NULL,
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    reg_user character varying(256),
    update_user character varying(256)
    
);


ALTER TABLE public.maintenance_info OWNER TO hinemos;

ALTER TABLE ONLY maintenance_info
    ADD CONSTRAINT p_key_maintenance_info PRIMARY KEY (maintenance_id);
    
ALTER TABLE ONLY maintenance_info
    ADD CONSTRAINT ref_maintenance_type_mst FOREIGN KEY (type_id) REFERENCES maintenance_type_mst(type_id);



--
-- Data for Name: calculated_data; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY calculated_data (collectorid, item_code, device_index, date_time, facilityid, value) FROM stdin;
\.


--
-- Data for Name: cc_acc_lock; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_acc_lock (lock_id) FROM stdin;
REPOSITORY
JOB
CRUN
MONITOR
MONITOR_SQL
MONITOR_PROCESS
MONITOR_PING
MONITOR_SNMP
MONITOR_AGENT
MONITOR_SYSLOG
ACCESS
CALENDER
NOTIFY
PERFORMANCE
PRIORITY_JUDGMENT
LOG_TRANSFER
MONITOR_SNMPTRAP
MAINTENANCE
\.


--
-- Data for Name: cc_cal_add_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_cal_add_info (calendar_id, time_from, time_to, execute_flg, description, reg_date, update_date, reg_user, update_user) FROM stdin;
\.


--
-- Data for Name: cc_cal_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_cal_info (calendar_id, calendar_name, description, start_time, valid_time_from, valid_time_to, reg_date, update_date, reg_user, update_user) FROM stdin;
\.


--
-- Data for Name: cc_cal_weekday_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_cal_weekday_info (calendar_id, weekday, time_from, time_to, description, reg_date, update_date, reg_user, update_user) FROM stdin;
\.


--
-- Data for Name: cc_crun_cmd_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_crun_cmd_mst (command_id, type_id, order_no, name_id, command_type, command) FROM stdin;
ADD_USER	USER	0	add.user	1	/opt/hinemos/lib/cr/useradd.sh
DELETE_USER	USER	2	delete.user	0	/usr/sbin/userdel -r
MODIFY_USER	USER	1	modify.user	1	/opt/hinemos/lib/cr/usermod.sh
REBOOT_LINUX	START_STOP	0	reboot.linux	0	/sbin/reboot
SHUTDOWN_LINUX	START_STOP	1	shutdown.linux	0	/sbin/poweroff
START_APACHE	START_STOP	2	start.apache	0	/etc/init.d/httpd start
STOP_APACHE	START_STOP	3	stop.apache	0	/etc/init.d/httpd stop
COPY_FILE	FILE	0	copy.file	1	/opt/hinemos/lib/cr/cp.sh
MAKE_DIRECTORY	FILE	1	make.directory	1	/opt/hinemos/lib/cr/mkdir.sh
REMOVE_FILE	FILE	2	remove.file.directory	1	/opt/hinemos/lib/cr/rm.sh
RPM_INSTALL	INSTALL	0	rpm.installation	1	/opt/hinemos/lib/cr/rpminstall.sh
AGENT_INSTALL	AGENT	0	agent.installation	1	/opt/hinemos/lib/cr/agent_install.sh
FILEJOB_SETTING	AGENT	1	setting.file.transfer	1	/opt/hinemos/lib/cr/file_transfer_setting.sh
\.


--
-- Data for Name: cc_crun_cmd_param_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_crun_cmd_param_mst (command_id, param_id, order_no, param_prefix) FROM stdin;
ADD_USER	UID	0	-u
ADD_USER	PASSWORD	2	-p
ADD_USER	GROUP_NAME	3	-g
ADD_USER	SECONDARY_GROUP_NAME	4	-G
ADD_USER	LOGIN_SHELL	5	-s
ADD_USER	HOME_DIRECTORY	6	-d
ADD_USER	USER_NAME	1	\N
MODIFY_USER	PASSWORD	1	-p
MODIFY_USER	USER_NAME	0	\N
MODIFY_USER	LOGIN_SHELL	4	-s
MODIFY_USER	GROUP_NAME	2	-g
MODIFY_USER	SECONDARY_GROUP_NAME	3	-G
DELETE_USER	USER_NAME	0	\N
RPM_INSTALL	FILE	0	\N
COPY_FILE	SOURCE_FILE	0	\N
COPY_FILE	DESTINATION	1	-d
COPY_FILE	FILE_PERMISSION	4	-m
COPY_FILE	GROUP_NAME	3	-g
COPY_FILE	USER_NAME	2	-u
REMOVE_FILE	FILE_DIRECTORY	0	\N
REMOVE_FILE	USER_NAME	1	-u
MAKE_DIRECTORY	DIRECTORY_NAME	0	\N
MAKE_DIRECTORY	USER_NAME	1	-u
MAKE_DIRECTORY	GROUP_NAME	2	-g
MAKE_DIRECTORY	DIRECTORY_PERMISSION	3	-m
AGENT_INSTALL	MANAGER_IP	0	-i
AGENT_INSTALL	MANAGER_ROOT_PASSWORD	1	-p
AGENT_INSTALL	AGENT_PATH	2	-a
AGENT_INSTALL	AGENT_PLACE	3	-w
AGENT_INSTALL	JRE_LICENSE	4	-j
AGENT_INSTALL	COLLECTIVERUN_MEAN	5	-c
FILEJOB_SETTING	TRANSFER_IP	0	-i
FILEJOB_SETTING	ROOT_PASSWORD	1	-r
FILEJOB_SETTING	FILE_TRANSFER_USER	2	-u
FILEJOB_SETTING	TRANSFER_PASSWORD	3	-p
\.


--
-- Data for Name: cc_crun_end_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_crun_end_mst (command_id, end_status, end_value_from, end_value_to) FROM stdin;
COPY_FILE	0	0	0
COPY_FILE	1	1	9
REMOVE_FILE	0	0	0
MAKE_DIRECTORY	0	0	0
MAKE_DIRECTORY	1	1	9
RPM_INSTALL	0	0	0
REBOOT_LINUX	0	0	0
SHUTDOWN_LINUX	0	0	0
START_APACHE	0	0	0
STOP_APACHE	0	0	0
ADD_USER	0	0	0
ADD_USER	1	1	2
MODIFY_USER	0	0	0
MODIFY_USER	1	1	2
DELETE_USER	0	0	0
RPM_INSTALL	1	1	9
AGENT_INSTALL	0	0	0
AGENT_INSTALL	1	1	9
FILEJOB_SETTING	0	0	0
FILEJOB_SETTING	1	1	9
\.


--
-- Data for Name: cc_crun_param_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_crun_param_mst (param_id, name_id, param_type) FROM stdin;
SOURCE_FILE	source.file	0
USER_NAME	user.name	0
GROUP_NAME	group.name	0
DIRECTORY_NAME	directory.name	0
FILE	file	0
FILE_DIRECTORY	file.directory	0
DESTINATION	destination	0
DIRECTORY_PERMISSION	file.access.permission	2
FILE_PERMISSION	file.access.permission	2
UID	uid	0
PASSWORD	password	1
SECONDARY_GROUP_NAME	secondary.group.name	0
LOGIN_SHELL	login.shell	2
HOME_DIRECTORY	home.directory	0
MANAGER_IP	manager.ip.address	0
MANAGER_ROOT_PASSWORD	manager.root.password	1
AGENT_PATH	agent.path	0
AGENT_PLACE	agent.place	0
JRE_LICENSE	jre.license	2
COLLECTIVERUN_MEAN	collectiverun.mean	2
TRANSFER_IP	transfer.ip.address	0
ROOT_PASSWORD	transfer.root.password	1
FILE_TRANSFER_USER	file.transfer.user	0
TRANSFER_PASSWORD	file.transfer.password	1
\.


--
-- Data for Name: cc_crun_param_select_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_crun_param_select_mst (param_id, order_no, name_id, param_value) FROM stdin;
LOGIN_SHELL	0	/bin/sh	/bin/sh
LOGIN_SHELL	1	/bin/bash	/bin/bash
LOGIN_SHELL	2	/bin/ksh	/bin/ksh
LOGIN_SHELL	3	/bin/tcsh	/bin/tcsh
LOGIN_SHELL	4	/bin/csh	/bin/csh
DIRECTORY_PERMISSION	0	rwx------	700
DIRECTORY_PERMISSION	1	rwxrwx---	770
DIRECTORY_PERMISSION	2	rwxr-x---	750
DIRECTORY_PERMISSION	3	rwxr-xr-x	755
DIRECTORY_PERMISSION	4	r-x------	500
DIRECTORY_PERMISSION	5	r-xr-x---	550
DIRECTORY_PERMISSION	6	r-xr-xr-x	555
FILE_PERMISSION	0	rwx------	700
FILE_PERMISSION	1	rwxrwx---	770
FILE_PERMISSION	2	rwxr-x---	750
FILE_PERMISSION	3	rwxr-xr-x	755
FILE_PERMISSION	4	rw-------	600
FILE_PERMISSION	5	rw-rw----	660
FILE_PERMISSION	6	rw-r-----	640
FILE_PERMISSION	7	rw-r--r--	644
FILE_PERMISSION	8	r--------	400
FILE_PERMISSION	9	r--r-----	440
FILE_PERMISSION	10	r--r--r--	444
JRE_LICENSE	0	YES	yes
JRE_LICENSE	1	NO	no
COLLECTIVERUN_MEAN	0	SSH	1
COLLECTIVERUN_MEAN	1	RSH	2
\.


--
-- Data for Name: cc_crun_session; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_crun_session (session_id, start_date, end_date, type_id, command_id, facility_id, scope_text, node_cnt, wait_cnt, running_cnt, end_nomal_cnt, end_warning_cnt, end_abnomal_cnt, status) FROM stdin;
\.


--
-- Data for Name: cc_crun_session_detail; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_crun_session_detail (session_id, facility_id, start_date, end_date, facility_name, message, error_message, status, end_status, end_value) FROM stdin;
\.


--
-- Data for Name: cc_crun_session_param; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_crun_session_param (session_id, param_id, param_value) FROM stdin;
\.


--
-- Data for Name: cc_crun_type_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_crun_type_mst (type_id, name_id, order_no) FROM stdin;
FILE	filesystem.management	0
INSTALL	installation.management	1
START_STOP	start.stop.management	2
USER	user.management	3
AGENT	agent.management	4
\.


--
-- Data for Name: cc_event_log; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_event_log (monitor_id, plugin_id, generation_date, facility_id, scope_text, application, message_id, message, message_org, priority, confirm_flg, confirm_date, duplication_count, output_date, inhibited_flg) FROM stdin;
\.


--
-- Data for Name: cc_event_multi_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_event_multi_info (monitor_id, plugin_id, facility_id, output_date, multi_id, duplication_count) FROM stdin;
\.


--
-- Data for Name: cc_job_command_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_command_info (session_id, job_id, facility_id, process_mode, start_command, stop_command, effective_user, error_end_flg, error_end_value, argument_job_id, argument) FROM stdin;
\.


--
-- Data for Name: cc_job_command_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_command_mst (job_id, facility_id, process_mode, start_command, stop_command, effective_user, error_end_flg, error_end_value, argument_job_id, argument) FROM stdin;
\.


--
-- Data for Name: cc_job_end_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_end_info (session_id, job_id, end_status, end_value, end_value_from, end_value_to) FROM stdin;
\.


--
-- Data for Name: cc_job_end_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_end_mst (job_id, end_status, end_value, end_value_from, end_value_to) FROM stdin;
\.


--
-- Data for Name: cc_job_file_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_file_info (session_id, job_id, process_mode, src_facility_id, dest_facility_id, src_file, src_work_dir, dest_directory, dest_work_dir, compression_flg, check_flg, effective_user) FROM stdin;
\.


--
-- Data for Name: cc_job_file_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_file_mst (job_id, process_mode, src_facility_id, dest_facility_id, src_file, src_work_dir, dest_directory, dest_work_dir, compression_flg, check_flg, effective_user) FROM stdin;
\.


--
-- Data for Name: cc_job_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_info (session_id, job_id, job_name, description, job_type, reg_date, update_date, reg_user, update_user) FROM stdin;
\.


--
-- Data for Name: cc_job_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_mst (job_id, job_name, description, job_type, reg_date, update_date, reg_user, update_user) FROM stdin;
\.


--
-- Data for Name: cc_job_notice_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_notice_info (session_id, job_id, notice_type, priority, notify_id) FROM stdin;
\.


--
-- Data for Name: cc_job_notice_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_notice_mst (job_id, notice_type, priority, notify_id) FROM stdin;
\.


--
-- Data for Name: cc_job_param_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_param_info (session_id, job_id, param_id, param_type, description, value) FROM stdin;
\.


--
-- Data for Name: cc_job_param_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_param_mst (job_id, param_id, param_type, description, value) FROM stdin;
\.


--
-- Data for Name: cc_job_relation_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_relation_info (session_id, job_id, parent_job_id) FROM stdin;
\.


--
-- Data for Name: cc_job_relation_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_relation_mst (job_id, parent_job_id) FROM stdin;
\.


--
-- Data for Name: cc_job_session; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_session (session_id, job_id, schedule_date, operation_flg) FROM stdin;
\.


--
-- Data for Name: cc_job_session_job; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_session_job (session_id, job_id, scope_text, status, start_date, end_date, end_value, end_status, result, end_staus_check_flg, delay_notify_flg) FROM stdin;
\.


--
-- Data for Name: cc_job_session_node; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_session_node (session_id, job_id, facility_id, node_name, status, start_date, end_date, end_value, message, agent_check, check_date, retry_count, result, status_buffer) FROM stdin;
\.


--
-- Data for Name: cc_job_start_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_start_info (session_id, job_id, condition_type, suspend, skip, skip_end_status, skip_end_value, unmatch_end_flg, unmatch_end_status, unmatch_end_value, calendar, calendar_id, calendar_end_value, start_delay, start_delay_session, start_delay_session_value, start_delay_time, start_delay_time_value, start_delay_condition_type, start_delay_notify, start_delay_notify_priority, start_delay_operation, start_delay_operation_type, start_delay_operation_end_value, end_delay, end_delay_session, end_delay_session_value, end_delay_job, end_delay_job_value, end_delay_time, end_delay_time_value, end_delay_condition_type, end_delay_notify, end_delay_notify_priority, end_delay_operation, end_delay_operation_type, end_delay_operation_end_value) FROM stdin;
\.


--
-- Data for Name: cc_job_start_job_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_start_job_info (session_id, job_id, target_job_id, target_job_type, target_job_end_value) FROM stdin;
\.


--
-- Data for Name: cc_job_start_job_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_start_job_mst (job_id, target_job_id, target_job_type, target_job_end_value) FROM stdin;
\.


--
-- Data for Name: cc_job_start_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_start_mst (job_id, condition_type, suspend, skip, skip_end_status, skip_end_value, unmatch_end_flg, unmatch_end_status, unmatch_end_value, calendar, calendar_id, calendar_end_value, start_delay, start_delay_session, start_delay_session_value, start_delay_time, start_delay_time_value, start_delay_condition_type, start_delay_notify, start_delay_notify_priority, start_delay_operation, start_delay_operation_type, start_delay_operation_end_value, end_delay, end_delay_session, end_delay_session_value, end_delay_job, end_delay_job_value, end_delay_time, end_delay_time_value, end_delay_condition_type, end_delay_notify, end_delay_notify_priority, end_delay_operation, end_delay_operation_type, end_delay_operation_end_value) FROM stdin;
\.


--
-- Data for Name: cc_job_start_time_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_start_time_info (session_id, job_id, start_time) FROM stdin;
\.


--
-- Data for Name: cc_job_start_time_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_start_time_mst (job_id, start_time) FROM stdin;
\.


--
-- Data for Name: cc_log_transfer_file_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_log_transfer_file_info (transfer_id, file_path, run_interval, existence_flg, valid_flg) FROM stdin;
\.


--
-- Data for Name: cc_log_transfer_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_log_transfer_info (transfer_id, description, facility_id, valid_flg, reg_date, update_date, reg_user, update_user) FROM stdin;
\.


--
-- Data for Name: cc_monitor_agent_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_monitor_agent_info (monitor_type_id, monitor_id, check_job_agent, check_log_agent) FROM stdin;
\.


--
-- Data for Name: cc_monitor_http_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_monitor_http_info (monitor_type_id, monitor_id, request_url, url_replace, proxy_set, proxy_host, proxy_port, timeout) FROM stdin;
\.


--
-- Data for Name: cc_monitor_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_monitor_info (monitor_type_id, monitor_id, monitor_type, description, facility_id, run_interval, calendar_id, monitor_block, determination_id, failure_priority, notify_id, application, job_run, failure_message_id, failure_message, failure_job_run, failure_job_id, failure_job_inhibition_flg, failure_job_failure_priority, reg_date, update_date, reg_user, update_user, timeout) FROM stdin;
\.


--
-- Data for Name: cc_monitor_numeric_value_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_monitor_numeric_value_info (monitor_type_id, monitor_id, priority, threshold_upper_limit, threshold_lower_limit, message_id, message, job_run, job_id, job_inhibition_flg, job_failure_priority) FROM stdin;
\.


--
-- Data for Name: cc_monitor_perf_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_monitor_perf_info (monitor_type_id, monitor_id, collector_id, item_code, device_index, device_name) FROM stdin;
\.


--
-- Data for Name: cc_monitor_ping_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_monitor_ping_info (monitor_type_id, monitor_id, run_count, run_interval, timeout) FROM stdin;
\.


--
-- Data for Name: cc_monitor_process_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_monitor_process_info (monitor_type_id, monitor_id, command, param) FROM stdin;
\.


--
-- Data for Name: cc_monitor_snmp_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_monitor_snmp_info (monitor_type_id, monitor_id, community_name, snmp_oid, convert_flg) FROM stdin;
\.


--
-- Data for Name: cc_monitor_snmp_value; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_monitor_snmp_value (monitor_id, facility_id, value, get_date) FROM stdin;
\.


--
-- Data for Name: cc_monitor_sql_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_monitor_sql_info (monitor_type_id, monitor_id, connection_url, connection_user, connection_password, query, jdbc_driver) FROM stdin;
\.


--
-- Data for Name: cc_monitor_string_value_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_monitor_string_value_info (monitor_type_id, monitor_id, order_no, description, process_type, pattern, priority, message_id, message, notify_id, job_run, job_id, job_inhibition_flg, job_failure_priority, valid_flg) FROM stdin;
\.


--
-- Data for Name: cc_monitor_truth_value_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_monitor_truth_value_info (monitor_type_id, monitor_id, priority, truth_value, message_id, message, job_run, job_id, job_inhibition_flg, job_failure_priority) FROM stdin;
\.


--
-- Data for Name: cc_notify_event_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_notify_event_info (notify_id, priority, event_normal_flg, event_normal_state, event_inhibition_flg, event_inhibition_state, mail_flg, mail_address) FROM stdin;
001	3	0	0	0	1	0	\N
001	2	0	0	0	1	0	\N
001	0	1	0	0	1	0	\N
001	1	0	0	0	1	0	\N
002	3	1	0	1	1	0	\N
002	2	1	0	0	1	0	\N
002	0	1	0	0	1	0	\N
002	1	1	0	0	1	0	\N
\.


--
-- Data for Name: cc_notify_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_notify_info (notify_id, description, status_flg, status_valid_period, status_invalid_flg, status_update_priority, event_flg, inhibition_flg, inhibition_frequency, inhibition_period, reg_date, update_date) FROM stdin;
001	status.monitoring	1	10	12	1	1	0	\N	\N	2007-01-31 00:00:00.000	2007-01-31 00:00:00.000
002	event.monitoring	0	10	12	2	1	2	\N	30	2007-01-31 00:00:00.000	2007-01-31 00:00:00.000
\.


--
-- Data for Name: cc_priority_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_priority_info (judgment_id, description, pattern_01, pattern_02, pattern_03, pattern_04, pattern_05, pattern_06, pattern_07, pattern_08, pattern_09, pattern_10, pattern_11, pattern_12, pattern_13, pattern_14, pattern_15, reg_date, update_date, reg_user, update_user) FROM stdin;
DEFAULT	\N	3	1	2	1	2	1	0	0	0	0	0	0	0	0	1	\N	2006-06-07 14:58:31.156	\N	hinemos
\.


--
-- Data for Name: cc_snmp_trap_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_snmp_trap_info (monitor_id, description, facility_id, community_name, notify_id, application, valid_flg, calendar_id, reg_date, update_date, reg_user, update_user) FROM stdin;
\.


--
-- Data for Name: cc_snmp_trap_mib_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_snmp_trap_mib_mst (mib, order_no, description, reg_date, update_date, reg_user, update_user) FROM stdin;
\.


--
-- Data for Name: cc_snmp_trap_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_snmp_trap_mst (mib, trap_oid, generic_id, specific_id, uei, logmsg, descr, priority) FROM stdin;
\.


--
-- Data for Name: cc_snmp_trap_oid_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_snmp_trap_oid_info (monitor_id, mib, trap_oid, generic_id, specific_id, valid_flg, priority, logmsg, descr) FROM stdin;
\.


--
-- Data for Name: cc_status_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_status_info (facility_id, monitor_id, plugin_id, application, message_id, message, priority, generation_date, output_date, expiration_flg, expiration_date) FROM stdin;
\.


--
-- Data for Name: cc_syslog_monitor_rule; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_syslog_monitor_rule (order_no, description, facility_id, pattern, process_type, priority, monitor_id, application, message_id, message, notify_id, calendar_id, valid_flg, job_run, job_id, job_inhibition_flg, job_failure_priority, reg_date, update_date, reg_user, update_user) FROM stdin;
\.


--
-- Data for Name: cc_system_notify_event_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_system_notify_event_info (notify_id, priority, event_normal_flg, event_normal_state, event_inhibition_flg, event_inhibition_state, mail_flg, mail_address) FROM stdin;
\.


--
-- Data for Name: cc_system_notify_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_system_notify_info (notify_id, description, status_flg, status_valid_period, status_invalid_flg, status_update_priority, event_flg, inhibition_flg, inhibition_frequency, inhibition_period, reg_date, update_date) FROM stdin;
\.


--
-- Data for Name: collector_item; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY collector_item (collectorid, itemid, item_code, device_index, device_name, monitor_flag) FROM stdin;
\.


--
-- Data for Name: collector_profile; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY collector_profile (collectorid, collector_type, label, start_date, stop_date, target_facilityid, scope_path, "interval", period, presave_period) FROM stdin;
\.


--
-- Data for Name: collector_status; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY collector_status (collectorid, run_status, error_status, end_status, count, last_collect_date) FROM stdin;
\.


--
-- Data for Name: device; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY device (collectorid, facilityid, device_name, objectid, "index", device_type) FROM stdin;
\.


--
-- Data for Name: jms_message_log; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY jms_message_log (messageid, destination, txid, txop, lateclone, messageblob) FROM stdin;
\.


--
-- Data for Name: jms_reference_log; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY jms_reference_log (messageid, destination, txid, txop, redelivered, redelivers) FROM stdin;
\.


--
-- Data for Name: jms_transaction_log; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY jms_transaction_log (txid) FROM stdin;
\.


--
-- Data for Name: monitor_setting; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY monitor_setting (collectorid, itemid, monitorid, monitor_label, threshold_value, threshold_option, notify_address, severity, except_option, except_time, except_count, message, event_code, device_index) FROM stdin;
\.


--
-- Data for Name: performance_data; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY performance_data (collectorid, objectid, date_time, facilityid, value) FROM stdin;
\.


--
-- Data for Name: qrtz_blob_triggers; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY qrtz_blob_triggers (trigger_name, trigger_group, blob_data) FROM stdin;
\.


--
-- Data for Name: qrtz_calendars; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY qrtz_calendars (calendar_name, calendar) FROM stdin;
\.


--
-- Data for Name: qrtz_cron_triggers; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY qrtz_cron_triggers (trigger_name, trigger_group, cron_expression, time_zone_id) FROM stdin;
CollectorRunController	PERF_COLLECT	7 0 5 * * ? *	Asia/Tokyo
JobRunManagement	JOB_MANAGEMENT	0 */1 * * * ? *	Asia/Tokyo
CollectiveRunController	CRUN_MANAGEMENT	*/30 * * * * ? *	Asia/Tokyo
MonitorController	MON	0 */5 * * * ? *	Asia/Tokyo
\.


--
-- Data for Name: qrtz_fired_triggers; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY qrtz_fired_triggers (entry_id, trigger_name, trigger_group, is_volatile, instance_name, fired_time, state, job_name, job_group, is_stateful, requests_recovery) FROM stdin;
\.


--
-- Data for Name: qrtz_job_details; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY qrtz_job_details (job_name, job_group, description, job_class_name, is_durable, is_volatile, is_stateful, requests_recovery, job_data) FROM stdin;
MonitorController	MON	\N	org.quartz.jobs.ee.ejb.EJBInvokerJob	t	f	f	f	\\254\\355\\000\\005sr\\000\\025org.quartz.JobDataMap\\237\\260\\203\\350\\277\\251\\260\\313\\002\\000\\001Z\\000\\023allowsTransientDataxr\\000\\035org.quartz.utils.DirtyFlagMap\\023\\346.\\255(v\\012\\316\\002\\000\\002Z\\000\\005dirtyL\\000\\003mapt\\000\\017Ljava/util/Map;xp\\001sr\\000\\021java.util.HashMap\\005\\007\\332\\301\\303\\026`\\321\\003\\000\\002F\\000\\012loadFactorI\\000\\011thresholdxp?@\\000\\000\\000\\000\\000\\014w\\010\\000\\000\\000\\020\\000\\000\\000\\002t\\000\\003ejbt\\000\\021MonitorControllert\\000\\006methodt\\000\\014manageStatusx\\000
CollectiveRunController	CRUN_MANAGEMENT	\N	org.quartz.jobs.ee.ejb.EJBInvokerJob	t	f	f	t	\\254\\355\\000\\005sr\\000\\025org.quartz.JobDataMap\\237\\260\\203\\350\\277\\251\\260\\313\\002\\000\\001Z\\000\\023allowsTransientDataxr\\000\\035org.quartz.utils.DirtyFlagMap\\023\\346.\\255(v\\012\\316\\002\\000\\002Z\\000\\005dirtyL\\000\\003mapt\\000\\017Ljava/util/Map;xp\\001sr\\000\\021java.util.HashMap\\005\\007\\332\\301\\303\\026`\\321\\003\\000\\002F\\000\\012loadFactorI\\000\\011thresholdxp?@\\000\\000\\000\\000\\000\\014w\\010\\000\\000\\000\\020\\000\\000\\000\\003t\\000\\003ejbt\\000\\027CollectiveRunControllert\\000\\004argsur\\000\\023[Ljava.lang.Object;\\220\\316X\\237\\020s)l\\002\\000\\000xp\\000\\000\\000\\000t\\000\\006methodt\\000\\017checkEndSessionx\\000
JobRunManagement	JOB_MANAGEMENT	\N	org.quartz.jobs.ee.ejb.EJBInvokerJob	t	f	f	t	\\254\\355\\000\\005sr\\000\\025org.quartz.JobDataMap\\237\\260\\203\\350\\277\\251\\260\\313\\002\\000\\001Z\\000\\023allowsTransientDataxr\\000\\035org.quartz.utils.DirtyFlagMap\\023\\346.\\255(v\\012\\316\\002\\000\\002Z\\000\\005dirtyL\\000\\003mapt\\000\\017Ljava/util/Map;xp\\001sr\\000\\021java.util.HashMap\\005\\007\\332\\301\\303\\026`\\321\\003\\000\\002F\\000\\012loadFactorI\\000\\011thresholdxp?@\\000\\000\\000\\000\\000\\014w\\010\\000\\000\\000\\020\\000\\000\\000\\003t\\000\\003ejbt\\000\\020JobRunManagementt\\000\\004argsur\\000\\023[Ljava.lang.Object;\\220\\316X\\237\\020s)l\\002\\000\\000xp\\000\\000\\000\\000t\\000\\006methodt\\000\\003runx\\000
CollectorRunController	PERF_COLLECT	\N	org.quartz.jobs.ee.ejb.EJBInvokerJob	t	f	f	f	\\254\\355\\000\\005sr\\000\\025org.quartz.JobDataMap\\237\\260\\203\\350\\277\\251\\260\\313\\002\\000\\001Z\\000\\023allowsTransientDataxr\\000\\035org.quartz.utils.DirtyFlagMap\\023\\346.\\255(v\\012\\316\\002\\000\\002Z\\000\\005dirtyL\\000\\003mapt\\000\\017Ljava/util/Map;xp\\001sr\\000\\021java.util.HashMap\\005\\007\\332\\301\\303\\026`\\321\\003\\000\\002F\\000\\012loadFactorI\\000\\011thresholdxp?@\\000\\000\\000\\000\\000\\014w\\010\\000\\000\\000\\020\\000\\000\\000\\002t\\000\\003ejbt\\000\\026CollectorRunControllert\\000\\006methodt\\000\\023managePresavePeriodx\\000
\.


--
-- Data for Name: qrtz_job_listeners; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY qrtz_job_listeners (job_name, job_group, job_listener) FROM stdin;
\.


--
-- Data for Name: qrtz_locks; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY qrtz_locks (lock_name) FROM stdin;
TRIGGER_ACCESS
JOB_ACCESS
CALENDAR_ACCESS
STATE_ACCESS
MISFIRE_ACCESS
\.


--
-- Data for Name: qrtz_paused_trigger_grps; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY qrtz_paused_trigger_grps (trigger_group) FROM stdin;
\.


--
-- Data for Name: qrtz_scheduler_state; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY qrtz_scheduler_state (instance_name, last_checkin_time, checkin_interval, recoverer) FROM stdin;
NON_CLUSTERED	1141382690372	20000	\N
\.


--
-- Data for Name: qrtz_simple_triggers; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY qrtz_simple_triggers (trigger_name, trigger_group, repeat_count, repeat_interval, times_triggered) FROM stdin;
\.


--
-- Data for Name: qrtz_trigger_listeners; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY qrtz_trigger_listeners (trigger_name, trigger_group, trigger_listener) FROM stdin;
\.


--
-- Data for Name: qrtz_triggers; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY qrtz_triggers (trigger_name, trigger_group, job_name, job_group, is_volatile, description, next_fire_time, prev_fire_time, trigger_state, trigger_type, start_time, end_time, calendar_name, misfire_instr) FROM stdin;
CollectiveRunController	CRUN_MANAGEMENT	CollectiveRunController	CRUN_MANAGEMENT	f	\N	1156219530000	1156219500000	WAITING	CRON	0	0	\N	0
JobRunManagement	JOB_MANAGEMENT	JobRunManagement	JOB_MANAGEMENT	f	\N	1156219560000	1156219500000	WAITING	CRON	0	0	\N	0
MonitorController	MON	MonitorController	MON	f	\N	1156219800000	1156219500000	WAITING	CRON	0	0	\N	0
CollectorRunController	PERF_COLLECT	CollectorRunController	PERF_COLLECT	f	\N	1157343007000	1157342407000	WAITING	CRON	0	0	\N	0
\.


--
-- Data for Name: scope_relation; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY scope_relation (collectorid, facilityid, parent_facilityid) FROM stdin;
\.


--
-- Data for Name: scope_snap; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY scope_snap (collectorid, facilityid, facility_name, facility_type) FROM stdin;
\.


--
-- Data for Name: maintenance_type_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY maintenance_type_mst (type_id, name_id, order_no) FROM stdin;
DELETE_EVENT_LOG	delete_event_log.management	0
DELETE_JOB_HISTORY	delete_job_history.management	1
DELETE_CRUN_HISTORY	delete_crun_history.management	2
\.



--
-- Name: jms_message_log_pkey; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY jms_message_log
    ADD CONSTRAINT jms_message_log_pkey PRIMARY KEY (messageid, destination);


--
-- Name: jms_reference_log_pkey; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY jms_reference_log
    ADD CONSTRAINT jms_reference_log_pkey PRIMARY KEY (messageid, destination);


--
-- Name: p_key_cc_acc_lock; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_acc_lock
    ADD CONSTRAINT p_key_cc_acc_lock PRIMARY KEY (lock_id);


--
-- Name: p_key_cc_cal_add_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_cal_add_info
    ADD CONSTRAINT p_key_cc_cal_add_info PRIMARY KEY (calendar_id, time_from, time_to);


--
-- Name: p_key_cc_cal_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_cal_info
    ADD CONSTRAINT p_key_cc_cal_info PRIMARY KEY (calendar_id);


--
-- Name: p_key_cc_cal_weekday_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_cal_weekday_info
    ADD CONSTRAINT p_key_cc_cal_weekday_info PRIMARY KEY (calendar_id, weekday, time_from, time_to);


--
-- Name: p_key_cc_crun_cmd_mst; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_crun_cmd_mst
    ADD CONSTRAINT p_key_cc_crun_cmd_mst PRIMARY KEY (command_id);


--
-- Name: p_key_cc_crun_cmd_param_mst; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_crun_cmd_param_mst
    ADD CONSTRAINT p_key_cc_crun_cmd_param_mst PRIMARY KEY (command_id, param_id);


--
-- Name: p_key_cc_crun_end_mst; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_crun_end_mst
    ADD CONSTRAINT p_key_cc_crun_end_mst PRIMARY KEY (command_id, end_status);


--
-- Name: p_key_cc_crun_param_mst; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_crun_param_mst
    ADD CONSTRAINT p_key_cc_crun_param_mst PRIMARY KEY (param_id);


--
-- Name: p_key_cc_crun_param_select_mst; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_crun_param_select_mst
    ADD CONSTRAINT p_key_cc_crun_param_select_mst PRIMARY KEY (param_id, order_no);


--
-- Name: p_key_cc_crun_session; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_crun_session
    ADD CONSTRAINT p_key_cc_crun_session PRIMARY KEY (session_id);


--
-- Name: p_key_cc_crun_session_detail; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_crun_session_detail
    ADD CONSTRAINT p_key_cc_crun_session_detail PRIMARY KEY (session_id, facility_id);


--
-- Name: p_key_cc_crun_session_param; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_crun_session_param
    ADD CONSTRAINT p_key_cc_crun_session_param PRIMARY KEY (session_id, param_id);


--
-- Name: p_key_cc_crun_type_mst; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_crun_type_mst
    ADD CONSTRAINT p_key_cc_crun_type_mst PRIMARY KEY (type_id);


--
-- Name: p_key_cc_event_log; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_event_log
    ADD CONSTRAINT p_key_cc_event_log PRIMARY KEY (monitor_id, plugin_id, output_date, facility_id);


--
-- Name: p_key_cc_event_multi_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_event_multi_info
    ADD CONSTRAINT p_key_cc_event_multi_info PRIMARY KEY (monitor_id, plugin_id, output_date, facility_id, multi_id);


--
-- Name: p_key_cc_job_command_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_job_command_info
    ADD CONSTRAINT p_key_cc_job_command_info PRIMARY KEY (session_id, job_id);


--
-- Name: p_key_cc_job_command_mst; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_job_command_mst
    ADD CONSTRAINT p_key_cc_job_command_mst PRIMARY KEY (job_id);


--
-- Name: p_key_cc_job_end_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_job_end_info
    ADD CONSTRAINT p_key_cc_job_end_info PRIMARY KEY (session_id, job_id, end_status);


--
-- Name: p_key_cc_job_end_mst; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_job_end_mst
    ADD CONSTRAINT p_key_cc_job_end_mst PRIMARY KEY (job_id, end_status);


--
-- Name: p_key_cc_job_file_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_job_file_info
    ADD CONSTRAINT p_key_cc_job_file_info PRIMARY KEY (session_id, job_id);


--
-- Name: p_key_cc_job_file_mst; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_job_file_mst
    ADD CONSTRAINT p_key_cc_job_file_mst PRIMARY KEY (job_id);


--
-- Name: p_key_cc_job_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_job_info
    ADD CONSTRAINT p_key_cc_job_info PRIMARY KEY (session_id, job_id);


--
-- Name: p_key_cc_job_mst; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_job_mst
    ADD CONSTRAINT p_key_cc_job_mst PRIMARY KEY (job_id);


--
-- Name: p_key_cc_job_notice_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_job_notice_info
    ADD CONSTRAINT p_key_cc_job_notice_info PRIMARY KEY (session_id, job_id, notice_type);


--
-- Name: p_key_cc_job_notice_mst; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_job_notice_mst
    ADD CONSTRAINT p_key_cc_job_notice_mst PRIMARY KEY (job_id, notice_type);


--
-- Name: p_key_cc_job_param_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_job_param_info
    ADD CONSTRAINT p_key_cc_job_param_info PRIMARY KEY (session_id, job_id, param_id);


--
-- Name: p_key_cc_job_param_mst; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_job_param_mst
    ADD CONSTRAINT p_key_cc_job_param_mst PRIMARY KEY (job_id, param_id);


--
-- Name: p_key_cc_job_relation_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_job_relation_info
    ADD CONSTRAINT p_key_cc_job_relation_info PRIMARY KEY (session_id, job_id, parent_job_id);


--
-- Name: p_key_cc_job_relation_mst; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_job_relation_mst
    ADD CONSTRAINT p_key_cc_job_relation_mst PRIMARY KEY (job_id, parent_job_id);


--
-- Name: p_key_cc_job_session; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_job_session
    ADD CONSTRAINT p_key_cc_job_session PRIMARY KEY (session_id);


--
-- Name: p_key_cc_job_session_job; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_job_session_job
    ADD CONSTRAINT p_key_cc_job_session_job PRIMARY KEY (session_id, job_id);


--
-- Name: p_key_cc_job_session_node; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_job_session_node
    ADD CONSTRAINT p_key_cc_job_session_node PRIMARY KEY (session_id, job_id, facility_id);


--
-- Name: p_key_cc_job_start_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_job_start_info
    ADD CONSTRAINT p_key_cc_job_start_info PRIMARY KEY (session_id, job_id);


--
-- Name: p_key_cc_job_start_job_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_job_start_job_info
    ADD CONSTRAINT p_key_cc_job_start_job_info PRIMARY KEY (session_id, job_id, target_job_id, target_job_type, target_job_end_value);


--
-- Name: p_key_cc_job_start_job_mst; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_job_start_job_mst
    ADD CONSTRAINT p_key_cc_job_start_job_mst PRIMARY KEY (job_id, target_job_id, target_job_type, target_job_end_value);


--
-- Name: p_key_cc_job_start_mst; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_job_start_mst
    ADD CONSTRAINT p_key_cc_job_start_mst PRIMARY KEY (job_id);


--
-- Name: p_key_cc_job_start_time_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_job_start_time_info
    ADD CONSTRAINT p_key_cc_job_start_time_info PRIMARY KEY (session_id, job_id);


--
-- Name: p_key_cc_job_start_time_mst; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_job_start_time_mst
    ADD CONSTRAINT p_key_cc_job_start_time_mst PRIMARY KEY (job_id);


--
-- Name: p_key_cc_log_transfer_file_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_log_transfer_file_info
    ADD CONSTRAINT p_key_cc_log_transfer_file_info PRIMARY KEY (transfer_id, file_path);


--
-- Name: p_key_cc_log_transfer_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_log_transfer_info
    ADD CONSTRAINT p_key_cc_log_transfer_info PRIMARY KEY (transfer_id);


--
-- Name: p_key_cc_monitor_agent_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_monitor_agent_info
    ADD CONSTRAINT p_key_cc_monitor_agent_info PRIMARY KEY (monitor_type_id, monitor_id);


--
-- Name: p_key_cc_monitor_http_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_monitor_http_info
    ADD CONSTRAINT p_key_cc_monitor_http_info PRIMARY KEY (monitor_type_id, monitor_id);


--
-- Name: p_key_cc_monitor_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_monitor_info
    ADD CONSTRAINT p_key_cc_monitor_info PRIMARY KEY (monitor_type_id, monitor_id);


--
-- Name: p_key_cc_monitor_numeric_value_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_monitor_numeric_value_info
    ADD CONSTRAINT p_key_cc_monitor_numeric_value_info PRIMARY KEY (monitor_type_id, monitor_id, priority);


--
-- Name: p_key_cc_monitor_perf_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_monitor_perf_info
    ADD CONSTRAINT p_key_cc_monitor_perf_info PRIMARY KEY (monitor_type_id, monitor_id);


--
-- Name: p_key_cc_monitor_ping_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_monitor_ping_info
    ADD CONSTRAINT p_key_cc_monitor_ping_info PRIMARY KEY (monitor_type_id, monitor_id);


--
-- Name: p_key_cc_monitor_process_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_monitor_process_info
    ADD CONSTRAINT p_key_cc_monitor_process_info PRIMARY KEY (monitor_type_id, monitor_id);


--
-- Name: p_key_cc_monitor_snmp_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_monitor_snmp_info
    ADD CONSTRAINT p_key_cc_monitor_snmp_info PRIMARY KEY (monitor_type_id, monitor_id);


--
-- Name: p_key_cc_monitor_snmp_value; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_monitor_snmp_value
    ADD CONSTRAINT p_key_cc_monitor_snmp_value PRIMARY KEY (monitor_id, facility_id);


--
-- Name: p_key_cc_monitor_sql_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_monitor_sql_info
    ADD CONSTRAINT p_key_cc_monitor_sql_info PRIMARY KEY (monitor_type_id, monitor_id);


--
-- Name: p_key_cc_monitor_string_value_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_monitor_string_value_info
    ADD CONSTRAINT p_key_cc_monitor_string_value_info PRIMARY KEY (monitor_type_id, monitor_id, order_no);


--
-- Name: p_key_cc_monitor_truth_value_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_monitor_truth_value_info
    ADD CONSTRAINT p_key_cc_monitor_truth_value_info PRIMARY KEY (monitor_type_id, monitor_id, priority, truth_value);


--
-- Name: p_key_cc_notify_event_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_notify_event_info
    ADD CONSTRAINT p_key_cc_notify_event_info PRIMARY KEY (notify_id, priority);


--
-- Name: p_key_cc_notify_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_notify_info
    ADD CONSTRAINT p_key_cc_notify_info PRIMARY KEY (notify_id);


--
-- Name: p_key_cc_priority_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_priority_info
    ADD CONSTRAINT p_key_cc_priority_info PRIMARY KEY (judgment_id);


--
-- Name: p_key_cc_snmp_trap_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_snmp_trap_info
    ADD CONSTRAINT p_key_cc_snmp_trap_info PRIMARY KEY (monitor_id);


--
-- Name: p_key_cc_snmp_trap_mib_mst; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_snmp_trap_mib_mst
    ADD CONSTRAINT p_key_cc_snmp_trap_mib_mst PRIMARY KEY (mib);


--
-- Name: p_key_cc_snmp_trap_mst; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_snmp_trap_mst
    ADD CONSTRAINT p_key_cc_snmp_trap_mst PRIMARY KEY (mib, trap_oid, generic_id, specific_id);


--
-- Name: p_key_cc_snmp_trap_oid_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_snmp_trap_oid_info
    ADD CONSTRAINT p_key_cc_snmp_trap_oid_info PRIMARY KEY (monitor_id, mib, trap_oid, generic_id, specific_id);


--
-- Name: p_key_cc_status_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_status_info
    ADD CONSTRAINT p_key_cc_status_info PRIMARY KEY (facility_id, monitor_id, plugin_id);


--
-- Name: p_key_cc_syslog_monitor_rule; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_syslog_monitor_rule
    ADD CONSTRAINT p_key_cc_syslog_monitor_rule PRIMARY KEY (order_no);


--
-- Name: p_key_cc_system_notify_event_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_system_notify_event_info
    ADD CONSTRAINT p_key_cc_system_notify_event_info PRIMARY KEY (notify_id, priority);


--
-- Name: p_key_cc_system_notify_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_system_notify_info
    ADD CONSTRAINT p_key_cc_system_notify_info PRIMARY KEY (notify_id);


--
-- Name: pk_cd; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY calculated_data
    ADD CONSTRAINT pk_cd PRIMARY KEY (collectorid, item_code, device_index, date_time, facilityid);


--
-- Name: pk_ci; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY collector_item
    ADD CONSTRAINT pk_ci PRIMARY KEY (collectorid, itemid);


--
-- Name: pk_cp; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY collector_profile
    ADD CONSTRAINT pk_cp PRIMARY KEY (collectorid);


--
-- Name: pk_cs; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY collector_status
    ADD CONSTRAINT pk_cs PRIMARY KEY (collectorid);


--
-- Name: pk_d; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY device
    ADD CONSTRAINT pk_d PRIMARY KEY (collectorid, facilityid, device_name);


--
-- Name: pk_ms; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY monitor_setting
    ADD CONSTRAINT pk_ms PRIMARY KEY (collectorid, itemid, monitorid);


--
-- Name: pk_pd; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY performance_data
    ADD CONSTRAINT pk_pd PRIMARY KEY (collectorid, objectid, date_time, facilityid);


--
-- Name: pk_sr; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY scope_relation
    ADD CONSTRAINT pk_sr PRIMARY KEY (collectorid, facilityid, parent_facilityid);


--
-- Name: pk_ss; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY scope_snap
    ADD CONSTRAINT pk_ss PRIMARY KEY (collectorid, facilityid);


--
-- Name: qrtz_blob_triggers_pkey; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY qrtz_blob_triggers
    ADD CONSTRAINT qrtz_blob_triggers_pkey PRIMARY KEY (trigger_name, trigger_group);


--
-- Name: qrtz_calendars_pkey; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY qrtz_calendars
    ADD CONSTRAINT qrtz_calendars_pkey PRIMARY KEY (calendar_name);


--
-- Name: qrtz_cron_triggers_pkey; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY qrtz_cron_triggers
    ADD CONSTRAINT qrtz_cron_triggers_pkey PRIMARY KEY (trigger_name, trigger_group);


--
-- Name: qrtz_fired_triggers_pkey; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY qrtz_fired_triggers
    ADD CONSTRAINT qrtz_fired_triggers_pkey PRIMARY KEY (entry_id);


--
-- Name: qrtz_job_details_pkey; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY qrtz_job_details
    ADD CONSTRAINT qrtz_job_details_pkey PRIMARY KEY (job_name, job_group);


--
-- Name: qrtz_job_listeners_pkey; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY qrtz_job_listeners
    ADD CONSTRAINT qrtz_job_listeners_pkey PRIMARY KEY (job_name, job_group, job_listener);


--
-- Name: qrtz_locks_pkey; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY qrtz_locks
    ADD CONSTRAINT qrtz_locks_pkey PRIMARY KEY (lock_name);


--
-- Name: qrtz_paused_trigger_grps_pkey; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY qrtz_paused_trigger_grps
    ADD CONSTRAINT qrtz_paused_trigger_grps_pkey PRIMARY KEY (trigger_group);


--
-- Name: qrtz_scheduler_state_pkey; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY qrtz_scheduler_state
    ADD CONSTRAINT qrtz_scheduler_state_pkey PRIMARY KEY (instance_name);


--
-- Name: qrtz_simple_triggers_pkey; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY qrtz_simple_triggers
    ADD CONSTRAINT qrtz_simple_triggers_pkey PRIMARY KEY (trigger_name, trigger_group);


--
-- Name: qrtz_trigger_listeners_pkey; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY qrtz_trigger_listeners
    ADD CONSTRAINT qrtz_trigger_listeners_pkey PRIMARY KEY (trigger_name, trigger_group, trigger_listener);


--
-- Name: qrtz_triggers_pkey; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY qrtz_triggers
    ADD CONSTRAINT qrtz_triggers_pkey PRIMARY KEY (trigger_name, trigger_group);


--
-- Name: idx_cc_event_log_1; Type: INDEX; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE INDEX idx_cc_event_log_1 ON cc_event_log USING btree (monitor_id, plugin_id, generation_date, facility_id);


--
-- Name: idx_cc_event_log_2; Type: INDEX; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE INDEX idx_cc_event_log_2 ON cc_event_log USING btree (monitor_id, plugin_id, generation_date, facility_id, inhibited_flg);


--
-- Name: idx_cc_job_relation_info_1; Type: INDEX; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE INDEX idx_cc_job_relation_info_1 ON cc_job_relation_info USING btree (session_id, parent_job_id);


--
-- Name: idx_cc_job_relation_mst_1; Type: INDEX; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE INDEX idx_cc_job_relation_mst_1 ON cc_job_relation_mst USING btree (parent_job_id);


--
-- Name: idx_cc_job_session_job_1; Type: INDEX; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE INDEX idx_cc_job_session_job_1 ON cc_job_session_job USING btree (status);


--
-- Name: idx_qrtz_ft_job_group; Type: INDEX; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE INDEX idx_qrtz_ft_job_group ON qrtz_fired_triggers USING btree (job_group);


--
-- Name: idx_qrtz_ft_job_name; Type: INDEX; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE INDEX idx_qrtz_ft_job_name ON qrtz_fired_triggers USING btree (job_name);


--
-- Name: idx_qrtz_ft_trig_group; Type: INDEX; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE INDEX idx_qrtz_ft_trig_group ON qrtz_fired_triggers USING btree (trigger_group);


--
-- Name: idx_qrtz_ft_trig_inst_name; Type: INDEX; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE INDEX idx_qrtz_ft_trig_inst_name ON qrtz_fired_triggers USING btree (instance_name);


--
-- Name: idx_qrtz_ft_trig_n_g; Type: INDEX; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE INDEX idx_qrtz_ft_trig_n_g ON qrtz_fired_triggers USING btree (trigger_name, trigger_group);


--
-- Name: idx_qrtz_ft_trig_name; Type: INDEX; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE INDEX idx_qrtz_ft_trig_name ON qrtz_fired_triggers USING btree (trigger_name);


--
-- Name: idx_qrtz_t_next_fire_time; Type: INDEX; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE INDEX idx_qrtz_t_next_fire_time ON qrtz_triggers USING btree (next_fire_time);


--
-- Name: idx_qrtz_t_nf_st; Type: INDEX; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE INDEX idx_qrtz_t_nf_st ON qrtz_triggers USING btree (trigger_state, next_fire_time);


--
-- Name: idx_qrtz_t_state; Type: INDEX; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE INDEX idx_qrtz_t_state ON qrtz_triggers USING btree (trigger_state);


--
-- Name: ref_ci; Type: INDEX; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE INDEX ref_ci ON collector_item USING btree (collectorid);


--
-- Name: ref_ms; Type: INDEX; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE INDEX ref_ms ON monitor_setting USING btree (collectorid, itemid);


--
-- Name: ref_pd; Type: INDEX; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE INDEX ref_pd ON performance_data USING btree (facilityid, collectorid);


--
-- Name: ref_ss; Type: INDEX; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE INDEX ref_ss ON scope_snap USING btree (collectorid);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY qrtz_job_listeners
    ADD CONSTRAINT "$1" FOREIGN KEY (job_name, job_group) REFERENCES qrtz_job_details(job_name, job_group);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY qrtz_triggers
    ADD CONSTRAINT "$1" FOREIGN KEY (job_name, job_group) REFERENCES qrtz_job_details(job_name, job_group);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY qrtz_simple_triggers
    ADD CONSTRAINT "$1" FOREIGN KEY (trigger_name, trigger_group) REFERENCES qrtz_triggers(trigger_name, trigger_group);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY qrtz_cron_triggers
    ADD CONSTRAINT "$1" FOREIGN KEY (trigger_name, trigger_group) REFERENCES qrtz_triggers(trigger_name, trigger_group);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY qrtz_blob_triggers
    ADD CONSTRAINT "$1" FOREIGN KEY (trigger_name, trigger_group) REFERENCES qrtz_triggers(trigger_name, trigger_group);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY qrtz_trigger_listeners
    ADD CONSTRAINT "$1" FOREIGN KEY (trigger_name, trigger_group) REFERENCES qrtz_triggers(trigger_name, trigger_group);


--
-- Name: ref_ci_cp; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY collector_item
    ADD CONSTRAINT ref_ci_cp FOREIGN KEY (collectorid) REFERENCES collector_profile(collectorid);


--
-- Name: ref_d_ss; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY device
    ADD CONSTRAINT ref_d_ss FOREIGN KEY (collectorid, facilityid) REFERENCES scope_snap(collectorid, facilityid);


--
-- Name: ref_sr_ss; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY scope_relation
    ADD CONSTRAINT ref_sr_ss FOREIGN KEY (collectorid, facilityid) REFERENCES scope_snap(collectorid, facilityid);


--
-- Name: ref_ss_cp; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY scope_snap
    ADD CONSTRAINT ref_ss_cp FOREIGN KEY (collectorid) REFERENCES collector_profile(collectorid);


--
-- Name: refcc_cal_info1; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_cal_weekday_info
    ADD CONSTRAINT refcc_cal_info1 FOREIGN KEY (calendar_id) REFERENCES cc_cal_info(calendar_id);


--
-- Name: refcc_cal_info2; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_cal_add_info
    ADD CONSTRAINT refcc_cal_info2 FOREIGN KEY (calendar_id) REFERENCES cc_cal_info(calendar_id);


--
-- Name: refcc_crun_cmd_mst41; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_crun_end_mst
    ADD CONSTRAINT refcc_crun_cmd_mst41 FOREIGN KEY (command_id) REFERENCES cc_crun_cmd_mst(command_id);


--
-- Name: refcc_crun_cmd_mst51; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_crun_cmd_param_mst
    ADD CONSTRAINT refcc_crun_cmd_mst51 FOREIGN KEY (command_id) REFERENCES cc_crun_cmd_mst(command_id);


--
-- Name: refcc_crun_param_mst61; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_crun_cmd_param_mst
    ADD CONSTRAINT refcc_crun_param_mst61 FOREIGN KEY (param_id) REFERENCES cc_crun_param_mst(param_id);


--
-- Name: refcc_crun_param_mst71; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_crun_param_select_mst
    ADD CONSTRAINT refcc_crun_param_mst71 FOREIGN KEY (param_id) REFERENCES cc_crun_param_mst(param_id);


--
-- Name: refcc_crun_session131; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_crun_session_param
    ADD CONSTRAINT refcc_crun_session131 FOREIGN KEY (session_id) REFERENCES cc_crun_session(session_id);


--
-- Name: refcc_crun_session81; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_crun_session_detail
    ADD CONSTRAINT refcc_crun_session81 FOREIGN KEY (session_id) REFERENCES cc_crun_session(session_id);


--
-- Name: refcc_crun_type_mst14; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_crun_cmd_mst
    ADD CONSTRAINT refcc_crun_type_mst14 FOREIGN KEY (type_id) REFERENCES cc_crun_type_mst(type_id);


--
-- Name: refcc_event_log1; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_event_multi_info
    ADD CONSTRAINT refcc_event_log1 FOREIGN KEY (monitor_id, plugin_id, output_date, facility_id) REFERENCES cc_event_log(monitor_id, plugin_id, output_date, facility_id);


--
-- Name: refcc_job_info10; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_job_notice_info
    ADD CONSTRAINT refcc_job_info10 FOREIGN KEY (session_id, job_id) REFERENCES cc_job_info(session_id, job_id);


--
-- Name: refcc_job_info12; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_job_start_job_info
    ADD CONSTRAINT refcc_job_info12 FOREIGN KEY (session_id, job_id) REFERENCES cc_job_info(session_id, job_id);


--
-- Name: refcc_job_info13; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_job_start_time_info
    ADD CONSTRAINT refcc_job_info13 FOREIGN KEY (session_id, job_id) REFERENCES cc_job_info(session_id, job_id);


--
-- Name: refcc_job_info14; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_job_command_info
    ADD CONSTRAINT refcc_job_info14 FOREIGN KEY (session_id, job_id) REFERENCES cc_job_info(session_id, job_id);


--
-- Name: refcc_job_info15; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_job_file_info
    ADD CONSTRAINT refcc_job_info15 FOREIGN KEY (session_id, job_id) REFERENCES cc_job_info(session_id, job_id);


--
-- Name: refcc_job_info17; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_job_param_info
    ADD CONSTRAINT refcc_job_info17 FOREIGN KEY (session_id, job_id) REFERENCES cc_job_info(session_id, job_id);


--
-- Name: refcc_job_info9; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_job_end_info
    ADD CONSTRAINT refcc_job_info9 FOREIGN KEY (session_id, job_id) REFERENCES cc_job_info(session_id, job_id);


--
-- Name: refcc_job_mst10; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_job_param_mst
    ADD CONSTRAINT refcc_job_mst10 FOREIGN KEY (job_id) REFERENCES cc_job_mst(job_id);


--
-- Name: refcc_job_mst2; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_job_end_mst
    ADD CONSTRAINT refcc_job_mst2 FOREIGN KEY (job_id) REFERENCES cc_job_mst(job_id);


--
-- Name: refcc_job_mst3; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_job_notice_mst
    ADD CONSTRAINT refcc_job_mst3 FOREIGN KEY (job_id) REFERENCES cc_job_mst(job_id);


--
-- Name: refcc_job_mst4; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_job_start_mst
    ADD CONSTRAINT refcc_job_mst4 FOREIGN KEY (job_id) REFERENCES cc_job_mst(job_id);


--
-- Name: refcc_job_mst5; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_job_start_job_mst
    ADD CONSTRAINT refcc_job_mst5 FOREIGN KEY (job_id) REFERENCES cc_job_mst(job_id);


--
-- Name: refcc_job_mst6; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_job_start_time_mst
    ADD CONSTRAINT refcc_job_mst6 FOREIGN KEY (job_id) REFERENCES cc_job_mst(job_id);


--
-- Name: refcc_job_mst7; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_job_command_mst
    ADD CONSTRAINT refcc_job_mst7 FOREIGN KEY (job_id) REFERENCES cc_job_mst(job_id);


--
-- Name: refcc_job_mst8; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_job_relation_mst
    ADD CONSTRAINT refcc_job_mst8 FOREIGN KEY (job_id) REFERENCES cc_job_mst(job_id);


--
-- Name: refcc_job_mst9; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_job_file_mst
    ADD CONSTRAINT refcc_job_mst9 FOREIGN KEY (job_id) REFERENCES cc_job_mst(job_id);


--
-- Name: refcc_job_session16; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_job_session_job
    ADD CONSTRAINT refcc_job_session16 FOREIGN KEY (session_id) REFERENCES cc_job_session(session_id);


--
-- Name: refcc_job_session_job19; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_job_session_node
    ADD CONSTRAINT refcc_job_session_job19 FOREIGN KEY (session_id, job_id) REFERENCES cc_job_session_job(session_id, job_id);


--
-- Name: refcc_job_session_job20; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_job_info
    ADD CONSTRAINT refcc_job_session_job20 FOREIGN KEY (session_id, job_id) REFERENCES cc_job_session_job(session_id, job_id);


--
-- Name: refcc_job_session_job22; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_job_relation_info
    ADD CONSTRAINT refcc_job_session_job22 FOREIGN KEY (session_id, job_id) REFERENCES cc_job_session_job(session_id, job_id);


--
-- Name: refcc_log_transfer_info1; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_log_transfer_file_info
    ADD CONSTRAINT refcc_log_transfer_info1 FOREIGN KEY (transfer_id) REFERENCES cc_log_transfer_info(transfer_id);


--
-- Name: refcc_monitor_info1; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_monitor_truth_value_info
    ADD CONSTRAINT refcc_monitor_info1 FOREIGN KEY (monitor_type_id, monitor_id) REFERENCES cc_monitor_info(monitor_type_id, monitor_id);


--
-- Name: refcc_monitor_info2; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_monitor_numeric_value_info
    ADD CONSTRAINT refcc_monitor_info2 FOREIGN KEY (monitor_type_id, monitor_id) REFERENCES cc_monitor_info(monitor_type_id, monitor_id);


--
-- Name: refcc_monitor_info3; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_monitor_process_info
    ADD CONSTRAINT refcc_monitor_info3 FOREIGN KEY (monitor_type_id, monitor_id) REFERENCES cc_monitor_info(monitor_type_id, monitor_id);


--
-- Name: refcc_monitor_info4; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_monitor_sql_info
    ADD CONSTRAINT refcc_monitor_info4 FOREIGN KEY (monitor_type_id, monitor_id) REFERENCES cc_monitor_info(monitor_type_id, monitor_id);


--
-- Name: refcc_monitor_info5; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_monitor_ping_info
    ADD CONSTRAINT refcc_monitor_info5 FOREIGN KEY (monitor_type_id, monitor_id) REFERENCES cc_monitor_info(monitor_type_id, monitor_id);


--
-- Name: refcc_monitor_info6; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_monitor_snmp_info
    ADD CONSTRAINT refcc_monitor_info6 FOREIGN KEY (monitor_type_id, monitor_id) REFERENCES cc_monitor_info(monitor_type_id, monitor_id);


--
-- Name: refcc_monitor_info7; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_monitor_string_value_info
    ADD CONSTRAINT refcc_monitor_info7 FOREIGN KEY (monitor_type_id, monitor_id) REFERENCES cc_monitor_info(monitor_type_id, monitor_id);


--
-- Name: refcc_monitor_info8; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_monitor_http_info
    ADD CONSTRAINT refcc_monitor_info8 FOREIGN KEY (monitor_type_id, monitor_id) REFERENCES cc_monitor_info(monitor_type_id, monitor_id);


--
-- Name: refcc_monitor_info9; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_monitor_perf_info
    ADD CONSTRAINT refcc_monitor_info9 FOREIGN KEY (monitor_type_id, monitor_id) REFERENCES cc_monitor_info(monitor_type_id, monitor_id);


--
-- Name: refcc_monitor_info9; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_monitor_agent_info
    ADD CONSTRAINT refcc_monitor_info9 FOREIGN KEY (monitor_type_id, monitor_id) REFERENCES cc_monitor_info(monitor_type_id, monitor_id);


--
-- Name: refcc_notify_info1; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_notify_event_info
    ADD CONSTRAINT refcc_notify_info1 FOREIGN KEY (notify_id) REFERENCES cc_notify_info(notify_id);


--
-- Name: refcc_notify_info2; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_monitor_info
    ADD CONSTRAINT refcc_notify_info2 FOREIGN KEY (notify_id) REFERENCES cc_notify_info(notify_id);


--
-- Name: refcc_notify_info3; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_syslog_monitor_rule
    ADD CONSTRAINT refcc_notify_info3 FOREIGN KEY (notify_id) REFERENCES cc_notify_info(notify_id);


--
-- Name: refcc_notify_info4; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_snmp_trap_info
    ADD CONSTRAINT refcc_notify_info4 FOREIGN KEY (notify_id) REFERENCES cc_notify_info(notify_id);


--
-- Name: refcc_snmp_trap_info1; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_snmp_trap_oid_info
    ADD CONSTRAINT refcc_snmp_trap_info1 FOREIGN KEY (monitor_id) REFERENCES cc_snmp_trap_info(monitor_id);


--
-- Name: refcc_snmp_trap_mib_mst1; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_snmp_trap_mst
    ADD CONSTRAINT refcc_snmp_trap_mib_mst1 FOREIGN KEY (mib) REFERENCES cc_snmp_trap_mib_mst(mib);


--
-- Name: refcc_snmp_trap_mst1; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_snmp_trap_oid_info
    ADD CONSTRAINT refcc_snmp_trap_mst1 FOREIGN KEY (mib, trap_oid, generic_id, specific_id) REFERENCES cc_snmp_trap_mst(mib, trap_oid, generic_id, specific_id);


--
-- Name: refcc_system_notify_info1; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_system_notify_event_info
    ADD CONSTRAINT refcc_system_notify_info1 FOREIGN KEY (notify_id) REFERENCES cc_system_notify_info(notify_id);


--
-- Name: public; Type: ACL; Schema: -; Owner: hinemos
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM hinemos;
GRANT ALL ON SCHEMA public TO hinemos;
GRANT ALL ON SCHEMA public TO PUBLIC;


--
-- PostgreSQL database dump complete
--

