/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.action;

import java.util.ArrayList;
import java.util.HashMap;

import com.clustercontrol.bean.DataRangeConstant;
import com.clustercontrol.bean.JobParamTypeConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.jobmanagement.bean.SystemParameterConstant;
import com.clustercontrol.util.Messages;

/**
 * ジョブ変数用プロパティを作成するクラスです
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class ParameterProperty {
	
	/** パラメータID（システム変数） */
	public static final String ID_SYSTEM_PARAM_ID = "systemId";
	
	/** パラメータID（ユーザ変数） */
	public static final String ID_USER_PARAM_ID = "useId";
	
	/** 種別 */
	public static final String ID_TYPE = "type";
	
	/** 値 */
	public static final String ID_VALUE = "value";
	
	/** 説明 */
	public static final String ID_DESCRIPTION = "description";
	
	/**
	 * ジョブ変数用プロパティを返します。
	 * 
	 * <p>
	 * <ol>
	 *  <li>ジョブ変数の設定項目毎にID, 名前, 処理定数（{@link com.clustercontrol.bean.PropertyConstant}）を指定し、
	 *      プロパティ（{@link com.clustercontrol.bean.Property}）を生成します。</li>
	 *  <li>各設定項目のプロパティをツリー状に定義します。</li>
	 * </ol>
	 * 
	 * <p>プロパティに定義するジョブ変数設定項目は、下記の通りです。
	 * <p>
	 * <ul>
	 *  <li>プロパティ（親。ダミー）
	 *  <ul>
	 *   <li>種別（子。コンボボックス）
	 *   <ul>
	 *    <li>システム（種別の選択肢）
	 *    <ul>
	 *     <li>名前（孫。コンボボックス）
	 *     <li>説明（孫。テキスト）
	 *    </ul>
	 *    <li>ユーザ（種別の選択肢）
	 *    <ul>
	 *     <li>名前（孫。テキスト）
	 *     <li>値（孫。テキスト）
	 *     <li>説明（孫。テキスト）
	 *    </ul>
	 *   </ul>
	 *  </ul>
	 * </ul>
	 * 
	 * @param type ジョブ変数の種別
	 * @return ジョブ変数用プロパティ
	 * 
	 * @see com.clustercontrol.bean.Property
	 * @see com.clustercontrol.bean.PropertyConstant
	 * @see com.clustercontrol.bean.JobParamTypeConstant
	 * @see com.clustercontrol.jobmanagement.bean.SystemParameterConstant
	 */
	@SuppressWarnings("unchecked")
	public Property getProperty(int type) {
		//プロパティ項目定義
		Property sysytemId = new Property(ID_SYSTEM_PARAM_ID, Messages.getString("name"), 
				PropertyConstant.EDITOR_SELECT);
		Property useId = new Property(ID_USER_PARAM_ID, Messages.getString("name"), 
				PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_64);
		Property paramType = new Property(ID_TYPE, Messages.getString("type"), 
				PropertyConstant.EDITOR_SELECT);
		Property value = new Property(ID_VALUE, Messages.getString("value"), 
				PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		Property description = new Property(ID_DESCRIPTION, Messages.getString("description"), 
				PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_256);
		
		//システムパラメータ
		ArrayList systemList = new ArrayList();
		systemList.add(sysytemId);
		systemList.add(description);
		
		HashMap systemListMap = new HashMap();
		systemListMap.put("value", JobParamTypeConstant.STRING_SYSTEM);
		systemListMap.put("property", systemList);
		
		//ユーザパラメータ
		ArrayList userList = new ArrayList();
		userList.add(useId);
		userList.add(value);
		userList.add(description);
		
		HashMap userListMap = new HashMap();
		userListMap.put("value", JobParamTypeConstant.STRING_USER);
		userListMap.put("property", userList);
		
		//種別コンボボックスの選択項目
		Object typeValues[][] = {
				{ JobParamTypeConstant.STRING_SYSTEM, 
					JobParamTypeConstant.STRING_USER},
					{ systemListMap, 
						userListMap} };
		
		Object systemIdList[][] = {
				{ SystemParameterConstant.FACILITY_ID,
					SystemParameterConstant.PLUGIN_ID,
					SystemParameterConstant.MONITOR_ID,
					SystemParameterConstant.MESSAGE_ID,
					SystemParameterConstant.APPLICATION,
					SystemParameterConstant.PRIORITY,
					SystemParameterConstant.MESSAGE,
					SystemParameterConstant.ORG_MESSAGE,
					SystemParameterConstant.START_DATE },
					{ SystemParameterConstant.FACILITY_ID,
						SystemParameterConstant.PLUGIN_ID,
						SystemParameterConstant.MONITOR_ID,
						SystemParameterConstant.MESSAGE_ID,
						SystemParameterConstant.APPLICATION,
						SystemParameterConstant.PRIORITY,
						SystemParameterConstant.MESSAGE,
						SystemParameterConstant.ORG_MESSAGE,
						SystemParameterConstant.START_DATE  } };
		
		paramType.setSelectValues(typeValues);
		sysytemId.setSelectValues(systemIdList);
		
		//値を初期化
		sysytemId.setValue(SystemParameterConstant.FACILITY_ID);
		useId.setValue("");
		paramType.setValue("");
		value.setValue("");
		description.setValue("");
		
		//変更の可/不可を設定
		sysytemId.setModify(PropertyConstant.MODIFY_OK);
		useId.setModify(PropertyConstant.MODIFY_OK);
		paramType.setModify(PropertyConstant.MODIFY_OK);
		value.setModify(PropertyConstant.MODIFY_OK);
		description.setModify(PropertyConstant.MODIFY_OK);
		
		Property property = new Property(null, null, null);
		
		if (type == JobParamTypeConstant.TYPE_SYSTEM) {
			paramType.setValue(JobParamTypeConstant.STRING_SYSTEM);
			
			// 初期表示ツリーを構成。
			property.removeChildren();
			property.addChildren(paramType);
			
			// 判定対象ツリー
			paramType.removeChildren();
			paramType.addChildren(sysytemId);
			paramType.addChildren(description);
		}
		else if (type == JobParamTypeConstant.TYPE_USER) {
			paramType.setValue(JobParamTypeConstant.STRING_USER);
			
			// 初期表示ツリーを構成。
			property.removeChildren();
			property.addChildren(paramType);
			
			// 判定対象ツリー
			paramType.removeChildren();
			paramType.addChildren(useId);
			paramType.addChildren(value);
			paramType.addChildren(description);
		}
		
		return property;
	}
}