/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.view.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.jobmanagement.action.RegisterJob;
import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.jobmanagement.composite.JobTreeComposite;
import com.clustercontrol.jobmanagement.util.JobUtil;
import com.clustercontrol.jobmanagement.view.JobListView;
import com.clustercontrol.util.Messages;

/**
 * ジョブ[一覧]ビューの「登録」のアクションクラスです。
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class RegisterJobAction implements IViewActionDelegate {
	/** ビュー */
    protected IViewPart m_view;

    /**
     * ビューを保持します。ワークベンチにロードされた際に呼ばれます。
     * 
     * @param view ビューのインスタンス
     * 
     * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
     */
    public void init(IViewPart view) {
        m_view = view;
    }

    /**
     * ジョブ[一覧]ビューの「登録」が押された場合に、ジョブを登録します。
     * <p>
	 * <ol>
	 * <li>登録の確認ダイアログを表示します。</li>
	 * <li>ジョブ[一覧]ビューからジョブツリーアイテムを取得します。</li>
	 * <li>ジョブツリーアイテムを登録します。</li>
	 * </ol>
     * 
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     * @see com.clustercontrol.jobmanagement.view.JobListView
     * @see com.clustercontrol.jobmanagement.composite.JobTreeComposite
     * @see com.clustercontrol.jobmanagement.action.RegisterJob#registerJob(JobTreeItem)
     */
    public void run(IAction action) {
        if (m_view instanceof JobListView) {
            // 確認ダイアログを生成
            if (MessageDialog.openQuestion(
        			null, 
        			Messages.getString("confirmed"), 
        			Messages.getString("message.job.31"))) {
            	
                JobListView view = (JobListView) m_view
                        .getAdapter(JobListView.class);
                JobTreeComposite tree = view.getJobTreeComposite();
                JobTreeItem item = (JobTreeItem) tree.getTreeViewer()
                        .getInput();
                
                if(JobUtil.checkWaitRule(item)){
                    RegisterJob registerJob = new RegisterJob();
                    if (registerJob.registerJob(item)) {
                        view.update();
                    }
                }
            }
        }
    }

    /* (non-Javadoc)
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {

    }
}