

-- 
-- TABLE: cc_job_command_info 
--

CREATE TABLE cc_job_command_info(
    session_id        VARCHAR(64)      NOT NULL,
    job_id            VARCHAR(64)      NOT NULL,
    facility_id       VARCHAR(64)      NOT NULL,
    process_mode      SMALLINT         NOT NULL,
    start_command     VARCHAR(1024),
    stop_command      VARCHAR(1024),
    effective_user    VARCHAR(64),
    error_end_flg     SMALLINT        NOT NULL,
    error_end_value   SMALLINT        NOT NULL,
    argument_job_id   VARCHAR(64),
    argument          VARCHAR(1024),
    CONSTRAINT p_key_cc_job_command_info PRIMARY KEY (session_id, job_id)
) 
;


-- 
-- TABLE: cc_job_command_mst 
--

CREATE TABLE cc_job_command_mst(
    job_id            VARCHAR(64)      NOT NULL,
    facility_id       VARCHAR(64)      NOT NULL,
    process_mode      SMALLINT         NOT NULL,
    start_command     VARCHAR(1024),
    stop_command      VARCHAR(1024),
    effective_user    VARCHAR(64),
    error_end_flg     SMALLINT        NOT NULL,
    error_end_value   SMALLINT        NOT NULL,
    argument_job_id   VARCHAR(64),
    argument          VARCHAR(1024),
    CONSTRAINT p_key_cc_job_command_mst PRIMARY KEY (job_id)
) 
;


-- 
-- TABLE: cc_job_end_info 
--

CREATE TABLE cc_job_end_info(
    session_id        VARCHAR(64)    NOT NULL,
    job_id            VARCHAR(64)    NOT NULL,
    end_status        SMALLINT    NOT NULL,
    end_value         SMALLINT    NOT NULL,
    end_value_from    SMALLINT    NOT NULL,
    end_value_to      SMALLINT    NOT NULL,
    CONSTRAINT p_key_cc_job_end_info PRIMARY KEY (session_id, job_id, end_status)
) 
;


-- 
-- TABLE: cc_job_end_mst 
--

CREATE TABLE cc_job_end_mst(
    job_id            VARCHAR(64)    NOT NULL,
    end_status        SMALLINT    NOT NULL,
    end_value         SMALLINT    NOT NULL,
    end_value_from    SMALLINT    NOT NULL,
    end_value_to      SMALLINT    NOT NULL,
    CONSTRAINT p_key_cc_job_end_mst PRIMARY KEY (job_id, end_status)
) 
;


-- 
-- TABLE: cc_job_info 
--

CREATE TABLE cc_job_info(
    session_id      VARCHAR(64)     NOT NULL,
    job_id          VARCHAR(64)     NOT NULL,
    job_name        VARCHAR(64)     NOT NULL,
    description     VARCHAR(256)    NOT NULL,
    job_type        SMALLINT     NOT NULL,
    reg_date        TIMESTAMP,
    update_date     TIMESTAMP,
    reg_user        VARCHAR(64),
    update_user     VARCHAR(64),
    CONSTRAINT p_key_cc_job_info PRIMARY KEY (session_id, job_id)
) 
;


-- 
-- TABLE: cc_job_mst 
--

CREATE TABLE cc_job_mst(
    job_id          VARCHAR(64)     NOT NULL,
    job_name        VARCHAR(64)     NOT NULL,
    description    VARCHAR(256)    NOT NULL,
    job_type        SMALLINT     NOT NULL,
    reg_date        TIMESTAMP,
    update_date     TIMESTAMP,
    reg_user        VARCHAR(64),
    update_user     VARCHAR(64),
    CONSTRAINT p_key_cc_job_mst PRIMARY KEY (job_id)
) 
;


-- 
-- TABLE: cc_job_notice_info 
--

CREATE TABLE cc_job_notice_info(
    session_id      VARCHAR(64)      NOT NULL,
    job_id          VARCHAR(64)      NOT NULL,
    notice_type     SMALLINT      NOT NULL,
    priority        SMALLINT      NOT NULL,
    notify_id       varchar(64),
    CONSTRAINT p_key_cc_job_notice_info PRIMARY KEY (session_id, job_id, notice_type)
) 
;


-- 
-- TABLE: cc_job_notice_mst 
--

CREATE TABLE cc_job_notice_mst(
    job_id          VARCHAR(64)      NOT NULL,
    notice_type     SMALLINT      NOT NULL,
    priority        SMALLINT      NOT NULL,
    notify_id       varchar(64),
    CONSTRAINT p_key_cc_job_notice_mst PRIMARY KEY (job_id, notice_type)
) 
;


-- 
-- TABLE: cc_job_relation_info 
--

CREATE TABLE cc_job_relation_info(
    session_id       VARCHAR(64)    NOT NULL,
    job_id           VARCHAR(64)    NOT NULL,
    parent_job_id    VARCHAR(64)    NOT NULL,
    CONSTRAINT p_key_cc_job_relation_info PRIMARY KEY (session_id, job_id, parent_job_id)
) 
;


-- 
-- TABLE: cc_job_relation_mst 
--

CREATE TABLE cc_job_relation_mst(
    job_id           VARCHAR(64)    NOT NULL,
    parent_job_id    VARCHAR(64)    NOT NULL,
    CONSTRAINT p_key_cc_job_relation_mst PRIMARY KEY (job_id, parent_job_id)
) 
;


-- 
-- TABLE: cc_job_session_job 
--

CREATE TABLE cc_job_session_job(
    session_id    VARCHAR(64)     NOT NULL,
    job_id        VARCHAR(64)     NOT NULL,
    scope_text    VARCHAR(256),
    status        SMALLINT     NOT NULL,
    start_date    TIMESTAMP,
    end_date      TIMESTAMP,
    end_value     SMALLINT,
    end_status    SMALLINT,
    result        VARCHAR(1024),
    end_staus_check_flg SMALLINT,
    delay_notify_flg SMALLINT,
    CONSTRAINT p_key_cc_job_session_job PRIMARY KEY (session_id, job_id)
) 
;


-- 
-- TABLE: cc_job_session_node 
--

CREATE TABLE cc_job_session_node(
    session_id     VARCHAR(64)     NOT NULL,
    job_id         VARCHAR(64)     NOT NULL,
    facility_id    VARCHAR(64)     NOT NULL,
    node_name      VARCHAR(256),
    status         SMALLINT     NOT NULL,
    start_date     TIMESTAMP,
    end_date       TIMESTAMP,
    end_value      SMALLINT,
    message        TEXT,
    agent_check    SMALLINT,
    check_date     TIMESTAMP,
    retry_count    SMALLINT,
    result         VARCHAR(1024),
    status_buffer  SMALLINT,
    CONSTRAINT p_key_cc_job_session_node PRIMARY KEY (session_id, job_id, facility_id)
) 
;


-- 
-- TABLE: cc_job_session 
--

CREATE TABLE cc_job_session(
    session_id       VARCHAR(64)    NOT NULL,
    job_id           VARCHAR(64)    NOT NULL,
    schedule_date    TIMESTAMP,
    operation_flg    SMALLINT    NOT NULL,
    CONSTRAINT p_key_cc_job_session PRIMARY KEY (session_id)
) 
;


-- 
-- TABLE: cc_job_start_info 
--

CREATE TABLE cc_job_start_info(
    session_id            VARCHAR(64)    NOT NULL,
    job_id                VARCHAR(64)    NOT NULL,
    condition_type        SMALLINT    NOT NULL,
    suspend               SMALLINT    NOT NULL,
    skip                  SMALLINT    NOT NULL,
    skip_end_status       SMALLINT    NOT NULL,
    skip_end_value        SMALLINT    NOT NULL,
    unmatch_end_flg       SMALLINT    NOT NULL,
    unmatch_end_status    SMALLINT    NOT NULL,
    unmatch_end_value     SMALLINT    NOT NULL,
    calendar              SMALLINT    NOT NULL,
    calendar_id           VARCHAR(64),
    calendar_end_value    SMALLINT    NOT NULL,
    start_delay                        SMALLINT    NOT NULL,
    start_delay_session                SMALLINT    NOT NULL,
    start_delay_session_value          SMALLINT    NOT NULL,
    start_delay_time                   SMALLINT    NOT NULL,
    start_delay_time_value             TIME,
    start_delay_condition_type         SMALLINT    NOT NULL,
    start_delay_notify                 SMALLINT    NOT NULL,
    start_delay_notify_priority        SMALLINT    NOT NULL,
    start_delay_operation              SMALLINT    NOT NULL,
    start_delay_operation_type         SMALLINT    NOT NULL,
    start_delay_operation_end_value    SMALLINT    NOT NULL,
    end_delay                          SMALLINT    NOT NULL,
    end_delay_session                  SMALLINT    NOT NULL,
    end_delay_session_value            SMALLINT    NOT NULL,
    end_delay_job                      SMALLINT    NOT NULL,
    end_delay_job_value                SMALLINT    NOT NULL,
    end_delay_time                     SMALLINT    NOT NULL,
    end_delay_time_value               TIME,
    end_delay_condition_type           SMALLINT    NOT NULL,
    end_delay_notify                   SMALLINT    NOT NULL,
    end_delay_notify_priority          SMALLINT    NOT NULL,
    end_delay_operation                SMALLINT    NOT NULL,
    end_delay_operation_type           SMALLINT    NOT NULL,
    end_delay_operation_end_value      SMALLINT    NOT NULL,
    CONSTRAINT p_key_cc_job_start_info PRIMARY KEY (session_id, job_id)
) 
;


-- 
-- TABLE: cc_job_start_job_info 
--

CREATE TABLE cc_job_start_job_info(
    session_id               VARCHAR(64)    NOT NULL,
    job_id                   VARCHAR(64)    NOT NULL,
    target_job_id            VARCHAR(64)    NOT NULL,
    target_job_type          SMALLINT    NOT NULL,
    target_job_end_value     SMALLINT    NOT NULL,
    CONSTRAINT p_key_cc_job_start_job_info PRIMARY KEY (session_id, job_id, target_job_id, target_job_type, target_job_end_value)
) 
;


-- 
-- TABLE: cc_job_start_job_mst 
--

CREATE TABLE cc_job_start_job_mst(
    job_id                   VARCHAR(64)    NOT NULL,
    target_job_id            VARCHAR(64)    NOT NULL,
    target_job_type          SMALLINT    NOT NULL,
    target_job_end_value     SMALLINT    NOT NULL,
    CONSTRAINT p_key_cc_job_start_job_mst PRIMARY KEY (job_id, target_job_id, target_job_type, target_job_end_value)
) 
;


-- 
-- TABLE: cc_job_start_mst 
--

CREATE TABLE cc_job_start_mst(
    job_id                VARCHAR(64)    NOT NULL,
    condition_type        SMALLINT    NOT NULL,
    suspend               SMALLINT    NOT NULL,
    skip                  SMALLINT    NOT NULL,
    skip_end_status       SMALLINT    NOT NULL,
    skip_end_value        SMALLINT    NOT NULL,
    unmatch_end_flg       SMALLINT    NOT NULL,
    unmatch_end_status    SMALLINT    NOT NULL,
    unmatch_end_value     SMALLINT    NOT NULL,
    calendar              SMALLINT    NOT NULL,
    calendar_id           VARCHAR(64),
    calendar_end_value    SMALLINT    NOT NULL,
    start_delay                        SMALLINT    NOT NULL,
    start_delay_session                SMALLINT    NOT NULL,
    start_delay_session_value          SMALLINT    NOT NULL,
    start_delay_time                   SMALLINT    NOT NULL,
    start_delay_time_value             TIME,
    start_delay_condition_type         SMALLINT    NOT NULL,
    start_delay_notify                 SMALLINT    NOT NULL,
    start_delay_notify_priority        SMALLINT    NOT NULL,
    start_delay_operation              SMALLINT    NOT NULL,
    start_delay_operation_type         SMALLINT    NOT NULL,
    start_delay_operation_end_value    SMALLINT    NOT NULL,
    end_delay                          SMALLINT    NOT NULL,
    end_delay_session                  SMALLINT    NOT NULL,
    end_delay_session_value            SMALLINT    NOT NULL,
    end_delay_job                      SMALLINT    NOT NULL,
    end_delay_job_value                SMALLINT    NOT NULL,
    end_delay_time                     SMALLINT    NOT NULL,
    end_delay_time_value               TIME,
    end_delay_condition_type           SMALLINT    NOT NULL,
    end_delay_notify                   SMALLINT    NOT NULL,
    end_delay_notify_priority          SMALLINT    NOT NULL,
    end_delay_operation                SMALLINT    NOT NULL,
    end_delay_operation_type           SMALLINT    NOT NULL,
    end_delay_operation_end_value      SMALLINT    NOT NULL,
    CONSTRAINT p_key_cc_job_start_mst PRIMARY KEY (job_id)
) 
;


-- 
-- TABLE: cc_job_start_time_info 
--

CREATE TABLE cc_job_start_time_info(
    session_id    VARCHAR(64)    NOT NULL,
    job_id        VARCHAR(64)    NOT NULL,
    start_time    TIME            NOT NULL,
    CONSTRAINT p_key_cc_job_start_time_info PRIMARY KEY (session_id, job_id)
) 
;


-- 
-- TABLE: cc_job_start_time_mst 
--

CREATE TABLE cc_job_start_time_mst(
    job_id        VARCHAR(64)    NOT NULL,
    start_time    TIME            NOT NULL,
    CONSTRAINT p_key_cc_job_start_time_mst PRIMARY KEY (job_id)
) 
;


-- 
-- TABLE: cc_job_file_info 
--

CREATE TABLE cc_job_file_info(
    session_id        VARCHAR(64)      NOT NULL,
    job_id            VARCHAR(64)      NOT NULL,
    process_mode      SMALLINT         NOT NULL,
    src_facility_id   VARCHAR(64)      NOT NULL,
    dest_facility_id  VARCHAR(64)      NOT NULL,
    src_file          VARCHAR(1024)    NOT NULL,
    src_work_dir      VARCHAR(1024)    NOT NULL,
    dest_directory    VARCHAR(1024)    NOT NULL,
    dest_work_dir     VARCHAR(1024)    NOT NULL,
    compression_flg   SMALLINT         NOT NULL,
    check_flg         SMALLINT         NOT NULL,
    effective_user    VARCHAR(64)      NOT NULL,
    CONSTRAINT p_key_cc_job_file_info PRIMARY KEY (session_id, job_id)
) 
;


-- 
-- TABLE: cc_job_file_mst 
--

CREATE TABLE cc_job_file_mst(
    job_id            VARCHAR(64)      NOT NULL,
    process_mode      SMALLINT         NOT NULL,
    src_facility_id   VARCHAR(64)      NOT NULL,
    dest_facility_id  VARCHAR(64)      NOT NULL,
    src_file          VARCHAR(1024)    NOT NULL,
    src_work_dir      VARCHAR(1024)    NOT NULL,
    dest_directory    VARCHAR(1024)    NOT NULL,
    dest_work_dir     VARCHAR(1024)    NOT NULL,
    compression_flg   SMALLINT         NOT NULL,
    check_flg         SMALLINT         NOT NULL,
    effective_user    VARCHAR(64)      NOT NULL,
    CONSTRAINT p_key_cc_job_file_mst PRIMARY KEY (job_id)
) 
;


-- 
-- TABLE: cc_job_param_info 
--

CREATE TABLE cc_job_param_info(
    session_id        VARCHAR(64)      NOT NULL,
    job_id            VARCHAR(64)      NOT NULL,
    param_id          VARCHAR(64)      NOT NULL,
    param_type        SMALLINT         NOT NULL,
    description       VARCHAR(256),
    value             VARCHAR(1024),
    CONSTRAINT p_key_cc_job_param_info PRIMARY KEY (session_id, job_id, param_id)
) 
;


-- 
-- TABLE: cc_job_param_mst 
--

CREATE TABLE cc_job_param_mst(
    job_id            VARCHAR(64)      NOT NULL,
    param_id          VARCHAR(64)      NOT NULL,
    param_type        SMALLINT         NOT NULL,
    description       VARCHAR(256),
    value             VARCHAR(1024),
    CONSTRAINT p_key_cc_job_param_mst PRIMARY KEY (job_id, param_id)
) 
;


-- 
-- TABLE: cc_job_command_info 
--

ALTER TABLE cc_job_command_info ADD CONSTRAINT Refcc_job_info14 
    FOREIGN KEY (session_id, job_id)
    REFERENCES cc_job_info(session_id, job_id)
;


-- 
-- TABLE: cc_job_command_mst 
--

ALTER TABLE cc_job_command_mst ADD CONSTRAINT Refcc_job_mst7 
    FOREIGN KEY (job_id)
    REFERENCES cc_job_mst(job_id)
;


-- 
-- TABLE: cc_job_end_info 
--

ALTER TABLE cc_job_end_info ADD CONSTRAINT Refcc_job_info9 
    FOREIGN KEY (session_id, job_id)
    REFERENCES cc_job_info(session_id, job_id)
;


-- 
-- TABLE: cc_job_end_mst 
--

ALTER TABLE cc_job_end_mst ADD CONSTRAINT Refcc_job_mst2 
    FOREIGN KEY (job_id)
    REFERENCES cc_job_mst(job_id)
;


-- 
-- TABLE: cc_job_info 
--

ALTER TABLE cc_job_info ADD CONSTRAINT Refcc_job_session_job20 
    FOREIGN KEY (session_id, job_id)
    REFERENCES cc_job_session_job(session_id, job_id)
;


-- 
-- TABLE: cc_job_notice_info 
--

ALTER TABLE cc_job_notice_info ADD CONSTRAINT Refcc_job_info10 
    FOREIGN KEY (session_id, job_id)
    REFERENCES cc_job_info(session_id, job_id)
;


-- 
-- TABLE: cc_job_notice_mst 
--

ALTER TABLE cc_job_notice_mst ADD CONSTRAINT Refcc_job_mst3 
    FOREIGN KEY (job_id)
    REFERENCES cc_job_mst(job_id)
;


-- 
-- TABLE: cc_job_relation_info 
--

ALTER TABLE cc_job_relation_info ADD CONSTRAINT Refcc_job_session_job22 
    FOREIGN KEY (session_id, job_id)
    REFERENCES cc_job_session_job(session_id, job_id)
;


-- 
-- TABLE: cc_job_relation_mst 
--

ALTER TABLE cc_job_relation_mst ADD CONSTRAINT Refcc_job_mst8 
    FOREIGN KEY (job_id)
    REFERENCES cc_job_mst(job_id)
;


-- 
-- TABLE: cc_job_session_job 
--

ALTER TABLE cc_job_session_job ADD CONSTRAINT Refcc_job_session16 
    FOREIGN KEY (session_id)
    REFERENCES cc_job_session(session_id)
;


-- 
-- TABLE: cc_job_session_node 
--

ALTER TABLE cc_job_session_node ADD CONSTRAINT Refcc_job_session_job19 
    FOREIGN KEY (session_id, job_id)
    REFERENCES cc_job_session_job(session_id, job_id)
;


-- 
-- TABLE: cc_job_start_info 
--

ALTER TABLE cc_job_start_info ADD CONSTRAINT Refcc_job_info11 
    FOREIGN KEY (session_id, job_id)
    REFERENCES cc_job_info(session_id, job_id)
;


-- 
-- TABLE: cc_job_start_job_info 
--

ALTER TABLE cc_job_start_job_info ADD CONSTRAINT Refcc_job_info12 
    FOREIGN KEY (session_id, job_id)
    REFERENCES cc_job_info(session_id, job_id)
;


-- 
-- TABLE: cc_job_start_job_mst 
--

ALTER TABLE cc_job_start_job_mst ADD CONSTRAINT Refcc_job_mst5 
    FOREIGN KEY (job_id)
    REFERENCES cc_job_mst(job_id)
;


-- 
-- TABLE: cc_job_start_mst 
--

ALTER TABLE cc_job_start_mst ADD CONSTRAINT Refcc_job_mst4 
    FOREIGN KEY (job_id)
    REFERENCES cc_job_mst(job_id)
;


-- 
-- TABLE: cc_job_start_time_info 
--

ALTER TABLE cc_job_start_time_info ADD CONSTRAINT Refcc_job_info13 
    FOREIGN KEY (session_id, job_id)
    REFERENCES cc_job_info(session_id, job_id)
;


-- 
-- TABLE: cc_job_start_time_mst 
--

ALTER TABLE cc_job_start_time_mst ADD CONSTRAINT Refcc_job_mst6 
    FOREIGN KEY (job_id)
    REFERENCES cc_job_mst(job_id)
;


-- 
-- TABLE: cc_job_file_info 
--

ALTER TABLE cc_job_file_info ADD CONSTRAINT Refcc_job_info15 
    FOREIGN KEY (session_id, job_id)
    REFERENCES cc_job_info(session_id, job_id)
;


-- 
-- TABLE: cc_job_file_mst 
--

ALTER TABLE cc_job_file_mst ADD CONSTRAINT Refcc_job_mst9 
    FOREIGN KEY (job_id)
    REFERENCES cc_job_mst(job_id)
;


-- 
-- TABLE: cc_job_param_info 
--

ALTER TABLE cc_job_param_info ADD CONSTRAINT Refcc_job_info17 
    FOREIGN KEY (session_id, job_id)
    REFERENCES cc_job_info(session_id, job_id)
;


-- 
-- TABLE: cc_job_param_mst 
--

ALTER TABLE cc_job_param_mst ADD CONSTRAINT Refcc_job_mst10 
    FOREIGN KEY (job_id)
    REFERENCES cc_job_mst(job_id)
;


-- Index: idx_cc_job_relation_mst_1

-- DROP INDEX idx_cc_job_relation_mst_1;

CREATE INDEX idx_cc_job_relation_mst_1
  ON cc_job_relation_mst
  USING btree
  (parent_job_id);


-- Index: idx_cc_job_relation_info_1

-- DROP INDEX idx_cc_job_relation_info_1;

CREATE INDEX idx_cc_job_relation_info_1
  ON cc_job_relation_info
  USING btree
  (session_id, parent_job_id);


-- Index: idx_cc_job_session_job_1

-- DROP INDEX idx_cc_job_session_job_1;

CREATE INDEX idx_cc_job_session_job_1
  ON cc_job_session_job
  USING btree
  (status);

