/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.bean;

import java.io.Serializable;

/**
 * ジョブファイル転送情報クラス
 * ジョブのファイル転送に関する情報を格納するクラスです。
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class JobFileInfo implements Serializable, Cloneable {
	/** シリアライズ可能クラスに定義するUID */
	private static final long serialVersionUID = 6448926354392693297L;
	
	/** スコープ処理方法 */
	protected int m_processingMethod;
	
	/** 転送ファシリティID */
	protected String m_srcFacilityID;
	
	/** 受信ファシリティID */
	protected String m_destFacilityID;
	
	/** 転送スコープ */
	protected String m_srcScope;
	
	/** 受信スコープ */
	protected String m_destScope;
	
	/** ファイル */
	protected String m_srcFile;
	
	/** 転送作業ディレクトリ */
	protected String m_srcWorkDir;
	
	/** 受信ディレクトリ */
	protected String m_destDirectory;
	
	/** 受信作業ディレクトリ */
	protected String m_destWorkDir;
	
	/** ファイル圧縮 */
	protected int m_compressionFlg;
	
	/** ファイルチェック */
	protected int m_checkFlg;
	
	/** 実効ユーザ */
	protected String m_user;
	
	/**
	 * ファイル圧縮を返す
	 * @return ファイル圧縮
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public int getCompressionFlg() {
		return m_compressionFlg;
	}
	
	/**
	 * ファイル圧縮を設定する
	 * @param compressionFlg ファイル圧縮
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public void setCompressionFlg(int compressionFlg) {
		this.m_compressionFlg = compressionFlg;
	}
	
	/**
	 * ファイルチェックを返す
	 * @return ファイルチェック
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public int getCheckFlg() {
		return m_checkFlg;
	}
	
	/**
	 * ファイルチェックを設定する
	 * @param checkFlg ファイルチェック
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public void setCheckFlg(int checkFlg) {
		this.m_checkFlg = checkFlg;
	}
	
	/**
	 * 転送スコープを返す
	 * @return 転送スコープ
	 */
	public String getSrcScope() {
		return m_srcScope;
	}
	
	/**
	 * 転送スコープを設定する
	 * @param srcScope 転送スコープ
	 */
	public void setSrcScope(String srcScope) {
		this.m_srcScope = srcScope;
	}
	
	/**
	 * 受信スコープを返す
	 * @return 受信スコープ
	 */
	public String getDestScope() {
		return m_destScope;
	}
	
	/**
	 * 受信スコープを設定する
	 * @param destScope 受信スコープ
	 */
	public void setDestScope(String destScope) {
		this.m_destScope = destScope;
	}
	
	/**
	 * 転送ファシリティIDを返す
	 * @return 転送ファシリティID
	 */
	public String getSrcFacilityID() {
		return m_srcFacilityID;
	}
	
	/**
	 * 転送ファシリティIDを設定する
	 * @param srcFacilityID 転送ファシリティID
	 */
	public void setSrcFacilityID(String srcFacilityID) {
		this.m_srcFacilityID = srcFacilityID;
	}
	
	/**
	 * 受信ファシリティIDを返す
	 * @return 受信ファシリティID
	 */
	public String getDestFacilityID() {
		return m_destFacilityID;
	}
	
	/**
	 * 受信ファシリティIDを設定する
	 * @param destFacilityID 受信ファシリティID
	 */
	public void setDestFacilityID(String destFacilityID) {
		this.m_destFacilityID = destFacilityID;
	}
	
	/**
	 * ファイルを返す
	 * @return ファイル
	 */
	public String getSrcFile() {
		return m_srcFile;
	}
	
	/**
	 * ファイルを設定する
	 * @param srcFile ファイル
	 */
	public void setSrcFile(String srcFile) {
		this.m_srcFile = srcFile;
	}
	
	/**
	 * 転送作業ディレクトリを返す
	 * @return 転送作業ディレクトリ
	 */
	public String getSrcWorkDir() {
		return m_srcWorkDir;
	}
	
	/**
	 * 転送作業ディレクトリを設定する
	 * @param srcWorkDir 転送作業ディレクトリ
	 */
	public void setSrcWorkDir(String srcWorkDir) {
		this.m_srcWorkDir = srcWorkDir;
	}
	
	/**
	 * 受信ディレクトリを返す
	 * @return 受信ディレクトリ
	 */
	public String getDestDirectory() {
		return m_destDirectory;
	}
	
	/**
	 * 受信ディレクトリを設定する
	 * @param destDirectory 受信ディレクトリ
	 */
	public void setDestDirectory(String destDirectory) {
		this.m_destDirectory = destDirectory;
	}
	
	/**
	 * 受信作業ディレクトリを返す
	 * @return 受信作業ディレクトリ
	 */
	public String getDestWorkDir() {
		return m_destWorkDir;
	}
	
	/**
	 * 受信作業ディレクトリを設定する
	 * @param destWorkDir 受信作業ディレクトリ
	 */
	public void setDestWorkDir(String destWorkDir) {
		this.m_destWorkDir = destWorkDir;
	}
	
	/**
	 * スコープ処理方法を返す
	 * @return スコープ処理方法
	 * @see com.clustercontrol.bean.ProcessingMethodConstant
	 */
	public int getProcessingMethod() {
		return m_processingMethod;
	}
	
	/**
	 * スコープ処理方法を設定する
	 * @param processingMethod スコープ処理方法
	 * @see com.clustercontrol.bean.ProcessingMethodConstant
	 */
	public void setProcessingMethod(int processingMethod) {
		this.m_processingMethod = processingMethod;
	}
	
	/**
	 * 実効ユーザを返す
	 * @return 実効ユーザ
	 */
	public String getUser() {
		return m_user;
	}
	
	/**
	 * 実効ユーザを設定する
	 * @param user 実効ユーザ
	 */
	public void setUser(String user) {
		this.m_user = user;
	}
	
	/**
	 * ジョブファイル転送情報のクローンを作成する
	 * 
	 * @see java.lang.Object#clone()
	 */
	protected Object clone() {
		try {
			JobFileInfo clone = (JobFileInfo)super.clone();
			
			clone.setProcessingMethod(this.getProcessingMethod());
			clone.setSrcFacilityID(this.getSrcFacilityID());
			clone.setDestFacilityID(this.getDestFacilityID());
			clone.setSrcScope(this.getSrcScope());
			clone.setDestScope(this.getDestScope());
			clone.setSrcFile(this.getSrcFile());
			clone.setSrcWorkDir(this.getSrcWorkDir());
			clone.setDestDirectory(this.getDestDirectory());
			clone.setDestWorkDir(this.getDestWorkDir());
			clone.setCompressionFlg(this.getCompressionFlg());
			clone.setCheckFlg(this.getCheckFlg());
			clone.setUser(this.getUser());
			
			return clone;
		} catch (CloneNotSupportedException e) {
			return null;
		}
	}
}