/*
 
Copyright (C) 2007 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.maintenance.action;

import java.rmi.RemoteException;

import javax.ejb.RemoveException;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;

import org.eclipse.jface.dialogs.MessageDialog;
import org.quartz.SchedulerException;

import com.clustercontrol.maintenance.ejb.session.MaintenanceController;
import com.clustercontrol.maintenance.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * 
 * メンテナンス情報を削除するクラスです。
 * 
 * @version 2.2.0
 * @since 2.2.0
 * 
 */
public class DeleteMaintenance {
	
	public boolean delete(String maintenanceId) {
		boolean ret = false;
		
		MaintenanceController controller = EjbConnectionManager.getConnectionManager().getMaintenanceController();
		
		try {
			controller.deleteMaintenance(maintenanceId);
			ret = true;
		} catch (RemoteException e) {
			// アクセス権なしの場合、エラーダイアログを表示する
			MessageDialog.openInformation(null, Messages.getString("message"),
					Messages.getString("message.accesscontrol.16"));
		} catch (NamingException e) {
		} catch (RemoveException e) {
		} catch (SystemException e) {
		} catch (NotSupportedException e) {
		} catch (RollbackException e) {
		} catch (HeuristicMixedException e) {
		} catch (HeuristicRollbackException e) {
		} catch (SchedulerException e) {
		}
		
		return ret;
	}
	
}
