/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.process.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Locale;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.process.util.EjbConnectionManager;
import com.clustercontrol.process.ejb.session.MonitorProcessController;
import com.clustercontrol.util.Messages;

/**
 * プロセス監視一覧テーブル定義情報を取得するクラスです。
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class GetProcessListTableDefine {

    /**
     * プロセス監視一覧のテーブル定義情報を返します。
     * 
     * @return プロセス監視一覧テーブル定義情報
     */
    public static ArrayList get() {
    	MonitorProcessController process = EjbConnectionManager.getConnectionManager()
                .getProcessController();

        ArrayList tableDefine = null;
        try {
            tableDefine = process.getProcessListTableDefine(Locale.getDefault());
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        }
        return tableDefine;
    }
}