/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.troubledetection.output;

import java.sql.Timestamp;
import java.util.Calendar;

import javax.ejb.FinderException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.StatusExpirationConstant;
import com.clustercontrol.monitor.ejb.entity.StatusInfoLocal;
import com.clustercontrol.monitor.ejb.entity.StatusInfoPK;
import com.clustercontrol.monitor.ejb.entity.StatusInfoUtil;
import com.clustercontrol.monitor.message.LogOutputInfo;

/**
 * ステータス出力クラス
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class OutputStatus {
	private static Log log = LogFactory.getLog( OutputStatus.class );

	/**
	 * ステータス情報出力処理
	 * 
	 * @param logOutput
	 * @param outputDate
	 * @return
	 */
	public boolean outputStatusInfo(LogOutputInfo logOutput, Timestamp outputDate) {
		log.debug("outputStatusInfo start : MonitorId=" + logOutput.getMonitorId() + ", MessageId" + logOutput.getMessageId());

		boolean result = false;
		
		if(logOutput.isStatusInfoFlg())
		{
			StatusInfoLocal statusInfo = null;
			boolean insertFlg = false;
			
			try
			{
				// エンティティ情報の検索
				StatusInfoPK pk = new StatusInfoPK(logOutput.getMonitorId(), logOutput.getPluginId(),logOutput.getFacilityId());
				statusInfo = StatusInfoUtil.getLocalHome().findByPrimaryKey(pk);
			}
			catch(FinderException e)
			{
				// 検索条件に合致するCMPエンティティが存在しない
				insertFlg = true;
			}
			catch (Exception e)
			{
				log.error("outputStatusInfo():" + e.getMessage());
				//検索条件に合致するCMPエンティティが存在しない
				insertFlg = true;
			}
			
			try
			{
				// エンティティ情報の生成
				if(insertFlg)
				{
					log.debug("outputStatusInfo insert : MonitorId=" + logOutput.getMonitorId() + ", MessageId" + logOutput.getMessageId());
					
					insertStatusInfo(logOutput, outputDate);
					result = true;
				}
				//　エンティティ情報の更新
				else
				{
					log.debug("outputStatusInfo update : MonitorId=" + logOutput.getMonitorId() + ", MessageId" + logOutput.getMessageId());
					
					updateStatusInfo(statusInfo, logOutput, outputDate);
					result = true;
				}
			}
			catch(Exception e)
			{
				log.error("outputStatusInfo():" + e.getMessage());
			}
		}
		
		log.debug("outputStatusInfo end : MonitorId=" + logOutput.getMonitorId() + ", MessageId" + logOutput.getMessageId());
		
		return result;
	}
	
	/**
	 * ステータス情報挿入処理
	 * 
	 * @param logOutput
	 * @param outputDate
	 * @return
	 */
	public void  insertStatusInfo(LogOutputInfo logOutput, Timestamp outputDate) throws Exception {
	
		try
		{
			// 有効期限制御フラグ
			Integer expirationFlg = getExpirationFlg(logOutput);
			// 有効期限日時
			Timestamp expirationDate = null;
			
			// 有効期限日時
			if(expirationFlg != null){
		        expirationDate = getExpirationDate(logOutput, outputDate);
			}
			
			StatusInfoUtil.getLocalHome().create(
					logOutput.getFacilityId(),
					logOutput.getMonitorId(),
					logOutput.getPluginId(),
					logOutput.getApplication(),
					logOutput.getMessageId(),
					logOutput.getMessage(),
					new Integer(logOutput.getPriority()),
					new java.sql.Timestamp(logOutput.getGenerationDate().getTime()),
					outputDate,
					expirationFlg,
					expirationDate);
		}
		catch(Exception e)
		{
			throw e;
		}
	}
	
	/**
	 * ステータス情報更新処理
	 * 
	 * @param statusInfo
	 * @param logOutput
	 * @param outputDate
	 * @return
	 */
	public void updateStatusInfo(StatusInfoLocal statusInfo, LogOutputInfo logOutput, Timestamp outputDate) throws Exception{
	
		if(statusInfo != null)
		{
			try
			{
				// 有効期限制御フラグ
				Integer expirationFlg = getExpirationFlg(logOutput);
				// 有効期限日時
				Timestamp expirationDate = null;
				// 有効期限日時
				if(expirationFlg != null){
			        expirationDate = getExpirationDate(logOutput, outputDate);
				}
				
				statusInfo.setApplication(logOutput.getApplication());
				statusInfo.setMessageId(logOutput.getMessageId());
				statusInfo.setMessage(logOutput.getMessage());
				statusInfo.setPriority(new Integer(logOutput.getPriority()));
//				statusInfo.setGenerationDate(new java.sql.Timestamp(logOutput.getGenerationDate().getTime()));
				statusInfo.setOutputDate(outputDate);
				statusInfo.setExpirationFlg(expirationFlg);
				statusInfo.setExpirationDate(expirationDate);
			}
			catch(Exception e)
			{
				throw e;
			}
		}
	}
	
	/**
	 * 有効期限制御フラグを返します
	 * 
	 * @param logOutput
	 * @return
	 */
	private Integer getExpirationFlg(LogOutputInfo logOutput){

		// 有効期限制御フラグ
		Integer expirationFlg = null;

		if(logOutput != null)
		{
			if(StatusExpirationConstant.TYPE_DELETE  == logOutput.getStatusInvalidFlg()){
				expirationFlg = new Integer(logOutput.getStatusInvalidFlg());
			}
			if(StatusExpirationConstant.TYPE_UPDATE  == logOutput.getStatusInvalidFlg()){
				// 有効期間経過後の扱いが、更新されていない旨のメッセージに置き換える場合は、
				// 置換え後の重要度を設定する
				expirationFlg = new Integer(logOutput.getStatusUpdatePriority());	
			}
		}
		return expirationFlg;
	}
	
	/**
	 * 有効期限日時を返します
	 * 
	 * @param logOutput
	 * @param outputDate
	 * @return
	 */
	private Timestamp getExpirationDate(LogOutputInfo logOutput, Timestamp outputDate){

		// 有効期限日時
		Timestamp expirationDate = null;

		if(logOutput != null)
		{
			if(logOutput.getStatusValidPeriod() > 0){
				Calendar cal = null;
				cal = Calendar.getInstance();
				cal.setTime(outputDate);
		        cal.add(Calendar.MINUTE, logOutput.getStatusValidPeriod());
		        expirationDate = new Timestamp(cal.getTimeInMillis());
			}
		}
		return expirationDate;
	}
}
