/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.process.util;

import com.clustercontrol.snmppoller.SnmpSharedTable;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SnmpProcConnectionManager {
    protected static Log m_log = LogFactory.getLog(SnmpProcConnectionManager.class);
    private static SnmpProcConnectionManager m_instance = null;
    private InitialContext m_ctx = null;

    public static SnmpProcConnectionManager getConnectionManager() {
        if (m_instance == null) {
            m_instance = new SnmpProcConnectionManager();
        }
        return m_instance;
    }

    private SnmpProcConnectionManager() {
        try {
            String serverName = System.getProperty("jboss.server.name");
            if (serverName.equals("all")) {
                Properties properties = new Properties();
                properties.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
                properties.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
                properties.put("java.naming.provider.url", "jnp://localhost:1100");
                this.m_ctx = new InitialContext(properties);
            } else {
                this.m_ctx = new InitialContext();
            }
        }
        catch (NamingException e) {
            m_log.error((Object)("SnmpProcConnectionManager:" + e.getMessage()));
        }
    }

    public synchronized SnmpSharedTable getSnmpSharedTable() throws NamingException {
        if (this.m_ctx == null) {
            try {
                String serverName = System.getProperty("jboss.server.name");
                if (serverName.equals("all")) {
                    Properties properties = new Properties();
                    properties.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
                    properties.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
                    properties.put("java.naming.provider.url", "jnp://localhost:1100");
                    this.m_ctx = new InitialContext(properties);
                } else {
                    this.m_ctx = new InitialContext();
                }
            }
            catch (NamingException e) {
                m_log.error((Object)("getSnmpSharedTable:" + e.getMessage()));
                throw e;
            }
        }
        try {
            SnmpSharedTable table = (SnmpSharedTable)this.m_ctx.lookup("SnmpProc");
            return table;
        }
        catch (NamingException e) {
            this.m_ctx = null;
            m_log.error((Object)("getSnmpSharedTable:" + e.getMessage()));
            throw e;
        }
    }
}

