/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performanceMGR.dao;

import com.clustercontrol.bean.FacilityInfo;
import com.clustercontrol.commons.util.ConnectionManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScopeSnapDAO {
    protected static Log m_log = LogFactory.getLog(ScopeSnapDAO.class);

    public FacilityInfo selectScopeSnap(String collectorID, String facilityID) throws EJBException {
        FacilityInfo finfo;
        block18: {
            m_log.debug((Object)("selectScopeSnap() start :" + collectorID + " " + facilityID));
            finfo = null;
            String type = null;
            Connection conn = null;
            PreparedStatement stmt = null;
            ResultSet res = null;
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT * FROM SCOPE_SNAP WHERE COLLECTORID=? AND FACILITYID = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, collectorID);
                stmt.setString(2, facilityID);
                res = stmt.executeQuery();
                if (res.next()) {
                    finfo = new FacilityInfo();
                    finfo.setFacilityId(res.getString("FACILITYID"));
                    finfo.setFacilityName(res.getString("FACILITY_NAME"));
                    type = res.getString("FACILITY_TYPE");
                    if (type.equals("node")) {
                        finfo.setType(2);
                    } else if (type.equals("scope")) {
                        finfo.setType(1);
                    } else if (type.equals("comp")) {
                        finfo.setType(0);
                    }
                    break block18;
                }
                String msg = "Select Error In ScopeSnapDAO";
                m_log.error((Object)("selectScopeSnap() error :" + collectorID + " SQLException "));
                throw new EJBException(msg);
            }
            catch (SQLException e) {
                m_log.error((Object)("selectScopeSnap() error :" + collectorID + " SQLException "));
                throw new EJBException(e.getMessage());
            }
            finally {
                try {
                    if (res != null) {
                        res.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e1) {
                    m_log.error((Object)("selectScopeSnap() error :" + collectorID + " SQLException "));
                    throw new EJBException(e1.getMessage());
                }
            }
        }
        m_log.debug((Object)("selectScopeSnap() start :" + collectorID + " " + facilityID));
        return finfo;
    }

    public void deleteScopeSnap(String collectorID, String facilityID) throws EJBException {
        m_log.debug((Object)("deleteScopeSnap() start :" + collectorID + " " + facilityID));
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "DELETE FROM SCOPE_SNAP WHERE COLLECTORID = ? AND FACILITYID=?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, collectorID);
            stmt.setString(2, facilityID);
            int row = stmt.executeUpdate();
            if (row != 1) {
                String msg = "Deletet Error In ScopeSnapDAO";
                m_log.error((Object)("deleteScopeSnap() error :" + collectorID + " SQLException "));
                throw new EJBException(msg);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("deleteScopeSnap() error :" + collectorID + " SQLException "));
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("deleteScopeSnap() error :" + collectorID + " SQLException "));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("deleteScopeSnap() start :" + collectorID + " " + facilityID));
        }
    }

    public void insertScopeSnap(String collectorID, FacilityInfo finfo) throws CreateException, EJBException {
        m_log.debug((Object)("insertScopeSnap() start :" + collectorID + " " + finfo.getFacilityId()));
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "INSERT INTO SCOPE_SNAP (collectorID, facilityID,facility_name,facility_type)values (?,?,?,?);";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, collectorID);
            stmt.setString(2, finfo.getFacilityId());
            stmt.setString(3, finfo.getFacilityName());
            int i = finfo.getType();
            if (i == 2) {
                stmt.setString(4, "comp");
            } else if (i == 0) {
                stmt.setString(4, "scope");
            } else if (i == 1) {
                stmt.setString(4, "node");
            }
            int row = stmt.executeUpdate();
            if (row != 1) {
                String msg = "Insert Error In ScopeSnapDAO";
                m_log.error((Object)("insertScopeSnap() error :" + collectorID + " CreateException "));
                throw new CreateException(msg);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("insertScopeSnap() error :" + collectorID + " SQLException "));
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("insertScopeSnap() error :" + collectorID + " SQLException "));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("insertScopeSnap() end   :" + collectorID + " " + finfo.getFacilityId()));
        }
    }

    public Hashtable selectScopeSnapByCollectorID(String collectorID) throws EJBException {
        m_log.debug((Object)("selectScopeSnapByCollectorID() start :" + collectorID));
        Hashtable<String, FacilityInfo> ret = new Hashtable<String, FacilityInfo>();
        String type = null;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT * FROM SCOPE_SNAP WHERE COLLECTORID=?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, collectorID);
            res = stmt.executeQuery();
            while (res.next()) {
                FacilityInfo finfo = new FacilityInfo();
                finfo.setFacilityId(res.getString("FACILITYID"));
                finfo.setFacilityName(res.getString("FACILITY_NAME"));
                type = res.getString("FACILITY_TYPE");
                if (type.equals("node")) {
                    finfo.setType(1);
                } else if (type.equals("scope")) {
                    finfo.setType(0);
                } else if (type.equals("comp")) {
                    finfo.setType(2);
                }
                ret.put(res.getString("FACILITYID"), finfo);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("selectScopeSnapByCollectorID() error :" + collectorID + " SQLException "));
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (res != null) {
                    res.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("selectScopeSnapByCollectorID() error :" + collectorID + " SQLException "));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("selectScopeSnapByCollectorID() end :" + collectorID));
        return ret;
    }

    public void deleteScopeSnapByCollectorID(String collectorID) throws EJBException {
        m_log.debug((Object)("deleteScopeSnapByCollectorID() start :" + collectorID));
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "DELETE FROM SCOPE_SNAP WHERE COLLECTORID = ? ";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, collectorID);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            m_log.error((Object)("deleteScopeSnapByCollectorID() error :" + collectorID + " SQLException "));
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("deleteScopeSnapByCollectorID() error :" + collectorID + " SQLException "));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("deleteScopeSnapByCollectorID() start :" + collectorID));
        }
    }
}

