/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.font.LineMetrics;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.DrawableLegendItem;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.jfree.chart.StandardLegend;
import org.jfree.chart.event.LegendChangeEvent;
import org.jfree.chart.plot.MeterPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.data.general.ValueDataset;

public class MeterLegend
extends StandardLegend {
    private String legendText;
    private boolean showNormal = true;
    private boolean showWarning = true;
    private boolean showCritical = true;

    public MeterLegend() {
        this("");
    }

    public MeterLegend(String legendText) {
        this.legendText = legendText;
    }

    public MeterLegend(JFreeChart chart, String legendText) {
        super(chart);
        this.legendText = legendText;
    }

    public String getLegendText() {
        return this.legendText;
    }

    public void setLegendText(String text) {
        this.legendText = text;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Rectangle2D draw(Graphics2D g2, Rectangle2D available) {
        return this.draw(g2, available, (this.getAnchor() & 1) != 0, (this.getAnchor() & 2) != 0);
    }

    private boolean updateInformation(MeterPlot plot, ValueDataset data, int type, int index, LegendItem[] legendItems, Paint[] legendItemColors) {
        boolean ret = false;
        String label = null;
        Paint paint = null;
        switch (type) {
            case 0: {
                paint = plot.getNormalPaint();
                label = "Normal";
                break;
            }
            case 1: {
                paint = plot.getWarningPaint();
                label = "Warning";
                break;
            }
            case 2: {
                paint = plot.getCriticalPaint();
                label = "Critical";
                break;
            }
            case 3: {
                paint = MeterPlot.DEFAULT_BACKGROUND_PAINT;
                label = "Meter Graph";
                break;
            }
            default: {
                return false;
            }
        }
        label = label + "  Range: ";
        legendItems[index] = new LegendItem(label, label, null, true, null, null, null, null);
        legendItemColors[index] = paint;
        ret = true;
        return ret;
    }

    protected Rectangle2D draw(Graphics2D g2, Rectangle2D available, boolean horizontal, boolean inverted) {
        int legendCount = 0;
        Plot plot = this.getChart().getPlot();
        if (!(plot instanceof MeterPlot)) {
            throw new IllegalArgumentException("Plot must be MeterPlot");
        }
        MeterPlot meterPlot = (MeterPlot)plot;
        ValueDataset data = meterPlot.getDataset();
        legendCount = 1;
        ++legendCount;
        if (this.showCritical) {
            ++legendCount;
        }
        if (this.showWarning) {
            ++legendCount;
        }
        if (this.showNormal) {
            ++legendCount;
        }
        LegendItem[] legendItems = new LegendItem[legendCount];
        Paint[] legendItemColors = new Color[legendCount];
        int currentItem = 0;
        String label = this.legendText + (data.getValue() != null ? "   Current Value: " + data.getValue().toString() : "");
        legendItems[currentItem] = new LegendItem(label, label, null, true, null, null, null, null);
        legendItemColors[currentItem] = null;
        if (this.updateInformation(meterPlot, data, 3, ++currentItem, legendItems, legendItemColors)) {
            ++currentItem;
        }
        if (this.showCritical && this.updateInformation(meterPlot, data, 2, currentItem, legendItems, legendItemColors)) {
            ++currentItem;
        }
        if (this.showWarning && this.updateInformation(meterPlot, data, 1, currentItem, legendItems, legendItemColors)) {
            ++currentItem;
        }
        if (this.showNormal && this.updateInformation(meterPlot, data, 0, currentItem, legendItems, legendItemColors)) {
            ++currentItem;
        }
        if (legendItems != null) {
            Rectangle2D legendArea = new Rectangle2D.Double();
            double availableWidth = available.getWidth();
            double availableHeight = available.getHeight();
            Point2D.Double translation = new Point2D.Double();
            DrawableLegendItem[] items = new DrawableLegendItem[legendItems.length];
            g2.setFont(this.getItemFont());
            if (horizontal) {
                double xstart = available.getX() + this.getOuterGap().getLeftSpace(availableWidth);
                double xlimit = available.getMaxX() + this.getOuterGap().getRightSpace(availableWidth) - 1.0;
                double maxRowWidth = 0.0;
                double xoffset = 0.0;
                double rowHeight = 0.0;
                double totalHeight = 0.0;
                boolean startingNewRow = true;
                for (int i = 0; i < legendItems.length; ++i) {
                    items[i] = this.createLegendItem(g2, legendItems[i], xoffset, totalHeight);
                    if (!startingNewRow && items[i].getX() + items[i].getWidth() + xstart > xlimit) {
                        maxRowWidth = Math.max(maxRowWidth, xoffset);
                        xoffset = 0.0;
                        totalHeight += rowHeight;
                        --i;
                        startingNewRow = true;
                        continue;
                    }
                    rowHeight = Math.max(rowHeight, items[i].getHeight());
                    xoffset += items[i].getWidth();
                    startingNewRow = false;
                }
                maxRowWidth = Math.max(maxRowWidth, xoffset);
                legendArea = new Rectangle2D.Double(0.0, 0.0, maxRowWidth, totalHeight += rowHeight);
                double yloc = inverted ? available.getMaxY() - totalHeight - this.getOuterGap().getBottomSpace(availableHeight) : available.getY() + this.getOuterGap().getTopSpace(availableHeight);
                double xloc = available.getX() + available.getWidth() / 2.0 - maxRowWidth / 2.0;
                translation = new Point2D.Double(xloc, yloc);
            } else {
                double totalHeight = 0.0;
                double maxWidth = 0.0;
                g2.setFont(this.getItemFont());
                for (int i = 0; i < items.length; ++i) {
                    items[i] = this.createLegendItem(g2, legendItems[i], 0.0, totalHeight);
                    totalHeight += items[i].getHeight();
                    maxWidth = Math.max(maxWidth, items[i].getWidth());
                }
                legendArea = new Rectangle2D.Float(0.0f, 0.0f, (float)maxWidth, (float)totalHeight);
                double xloc = inverted ? available.getMaxX() - maxWidth - this.getOuterGap().getRightSpace(availableWidth) : available.getX() + this.getOuterGap().getLeftSpace(availableWidth);
                double yloc = available.getY() + available.getHeight() / 2.0 - totalHeight / 2.0;
                translation = new Point2D.Double(xloc, yloc);
            }
            g2.translate(((Point2D)translation).getX(), ((Point2D)translation).getY());
            g2.setPaint(this.getBackgroundPaint());
            g2.fill(legendArea);
            g2.setPaint(this.getOutlinePaint());
            g2.setStroke(this.getOutlineStroke());
            g2.draw(legendArea);
            for (int i = 0; i < items.length; ++i) {
                Paint color = legendItemColors[i];
                if (color != null) {
                    g2.setPaint(color);
                    g2.fill(items[i].getMarker());
                }
                g2.setPaint(this.getItemPaint());
                g2.drawString(items[i].getItem().getLabel(), (float)items[i].getLabelPosition().getX(), (float)items[i].getLabelPosition().getY());
            }
            g2.translate(-((Point2D)translation).getX(), -((Point2D)translation).getY());
            if (horizontal) {
                double yy = available.getY();
                double yloc = inverted ? yy : yy + legendArea.getHeight() + this.getOuterGap().getBottomSpace(availableHeight);
                return new Rectangle2D.Double(available.getX(), yloc, availableWidth, availableHeight - legendArea.getHeight() - this.getOuterGap().getTopSpace(availableHeight) - this.getOuterGap().getBottomSpace(availableHeight));
            }
            double xloc = inverted ? available.getX() : available.getX() + legendArea.getWidth() + this.getOuterGap().getLeftSpace(availableWidth) + this.getOuterGap().getRightSpace(availableWidth);
            return new Rectangle2D.Double(xloc, available.getY(), availableWidth - legendArea.getWidth() - this.getOuterGap().getLeftSpace(availableWidth) - this.getOuterGap().getRightSpace(availableWidth), availableHeight);
        }
        return available;
    }

    private DrawableLegendItem createLegendItem(Graphics graphics, LegendItem item, double x, double y) {
        int innerGap = 2;
        FontMetrics fm = graphics.getFontMetrics();
        LineMetrics lm = fm.getLineMetrics(item.getLabel(), graphics);
        float textHeight = lm.getHeight();
        DrawableLegendItem drawable = new DrawableLegendItem(item);
        float xloc = (float)(x + (double)innerGap + (double)(1.15f * textHeight));
        float yloc = (float)(y + (double)innerGap + (double)(textHeight - lm.getLeading() - lm.getDescent()));
        drawable.setLabelPosition(new Point2D.Float(xloc, yloc));
        float boxDim = textHeight * 0.7f;
        xloc = (float)(x + (double)innerGap + (double)(0.15f * textHeight));
        yloc = (float)(y + (double)innerGap + (double)(0.15f * textHeight));
        drawable.setMarker(new Rectangle2D.Float(xloc, yloc, boxDim, boxDim));
        float width = (float)(drawable.getLabelPosition().getX() - x + (double)fm.stringWidth(item.getLabel()) + 0.5 * (double)textHeight);
        float height = (float)(2 * innerGap) + textHeight;
        drawable.setBounds(x, y, width, height);
        return drawable;
    }
}

