/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.repository.composite;

import com.clustercontrol.bean.Property;
import com.clustercontrol.composite.CommonTableViewer;
import com.clustercontrol.repository.action.GetNodeList;
import com.clustercontrol.repository.action.GetNodeListTableDefine;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class NodeFilterComposite
extends Composite {
    private CommonTableViewer tableViewer = null;
    private Label statuslabel = null;
    private Label totalLabel = null;
    private Property condition = null;
    private String scopeId = null;

    public NodeFilterComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    public NodeFilterComposite(Composite parent, int style, String facilityId) {
        super(parent, style);
        this.scopeId = facilityId;
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.statuslabel = new Label((Composite)this, 16384);
        this.statuslabel.setText("");
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.statuslabel.setLayoutData((Object)gridData);
        Table table = new Table((Composite)this, 68354);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        table.setLayoutData((Object)gridData);
        this.tableViewer = new CommonTableViewer(table);
        this.tableViewer.createTableColumn(GetNodeListTableDefine.get(), 0, 1);
        this.totalLabel = new Label((Composite)this, 131072);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.totalLabel.setLayoutData((Object)gridData);
        this.update();
    }

    public CommonTableViewer getTableViewer() {
        return this.tableViewer;
    }

    public void update() {
        ArrayList list = null;
        if (this.scopeId == null) {
            if (this.condition == null) {
                this.statuslabel.setText("");
                list = new GetNodeList().getAll();
            } else {
                this.statuslabel.setText(Messages.getString((String)"filtered.list"));
                list = new GetNodeList().get(this.condition);
            }
        } else {
            this.statuslabel.setText("");
            list = new GetNodeList().get(this.scopeId);
        }
        this.tableViewer.setInput(list);
        Object[] args = new String[]{String.valueOf(list.size())};
        String message = null;
        message = this.scopeId == null ? (this.condition == null ? Messages.getString((String)"records", (Object[])args) : Messages.getString((String)"filtered.records", (Object[])args)) : Messages.getString((String)"records", (Object[])args);
        this.totalLabel.setText(message);
    }

    public void update(Property condition) {
        this.condition = condition;
        this.update();
    }
}

