/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.repository.dialog;

import com.clustercontrol.ClusterControlPlugin;
import com.clustercontrol.bean.FacilityPath;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.bean.Property;
import com.clustercontrol.composite.PropertySheet;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ScopeTreeDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.repository.action.AddNodeProperty;
import com.clustercontrol.repository.action.GetNodeProperty;
import com.clustercontrol.repository.action.GetNodePropertyBySNMP;
import com.clustercontrol.repository.action.ModifyNodeProperty;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NodeCreateDialog
extends CommonDialog {
    private String facilityId = "";
    private String scopeId = "";
    private boolean isModifyDialog = false;
    private boolean isNodeSelected = true;
    private Button radioCreateTypeNode = null;
    private Button radioCreateTypeScope = null;
    private Text textScope = null;
    private Button buttonScope = null;
    private PropertySheet propertySheet = null;
    private boolean isClearDone = false;
    private Button buttonAuto = null;
    private Label ipAddressText = null;
    private Text ipAddressBox = null;
    private Label communityText = null;
    private Text communityBox = null;
    private Label portText = null;
    private Text portBox = null;
    private Label versionText = null;
    private Combo versionBox = null;

    public NodeCreateDialog(Shell parent, String facilityId, boolean isModifyDialog) {
        super(parent);
        this.facilityId = facilityId;
        this.isModifyDialog = isModifyDialog;
    }

    protected Point getInitialSize() {
        return new Point(500, 600);
    }

    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();
        shell.setText(Messages.getString((String)"dialog.repository.node.create.modify"));
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        parent.setLayout((Layout)layout);
        Group group = new Group(parent, 32);
        layout = new GridLayout(1, true);
        group.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        group.setLayoutData((Object)gridData);
        group.setText(Messages.getString((String)"registration.method"));
        this.radioCreateTypeNode = new Button((Composite)group, 16);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        this.radioCreateTypeNode.setLayoutData((Object)gridData);
        this.radioCreateTypeNode.setText(Messages.getString((String)"registration.method.node.base"));
        Composite compositeSNMP = new Composite((Composite)group, 0);
        RowLayout rowLayoutAuto = new RowLayout();
        rowLayoutAuto.marginLeft = 20;
        rowLayoutAuto.type = 256;
        compositeSNMP.setLayout((Layout)rowLayoutAuto);
        Group groupAuto = new Group(compositeSNMP, 131072);
        layout = new GridLayout(5, false);
        groupAuto.setLayout((Layout)layout);
        groupAuto.setText("Find By SNMP");
        this.ipAddressText = new Label((Composite)groupAuto, 0);
        this.ipAddressText.setText("IP Address : ");
        this.ipAddressBox = new Text((Composite)groupAuto, 2052);
        GridData grid = new GridData(768);
        grid.minimumWidth = 80;
        this.ipAddressBox.setLayoutData((Object)grid);
        this.ipAddressBox.setText("192.168.0.1");
        this.portText = new Label((Composite)groupAuto, 0);
        this.portText.setText("Port : ");
        this.portBox = new Text((Composite)groupAuto, 2052);
        grid = new GridData(768);
        grid.minimumWidth = 50;
        this.portBox.setLayoutData((Object)grid);
        this.portBox.setText("161");
        new Label((Composite)groupAuto, 0);
        this.communityText = new Label((Composite)groupAuto, 0);
        this.communityText.setText("Community Name : ");
        this.communityBox = new Text((Composite)groupAuto, 2052);
        this.communityBox.setLayoutData((Object)new GridData(768));
        this.communityBox.setText("public");
        this.versionText = new Label((Composite)groupAuto, 0);
        this.versionText.setText("version : ");
        this.versionBox = new Combo((Composite)groupAuto, 16);
        this.versionBox.setLayoutData((Object)new GridData(768));
        this.versionBox.add("1", 0);
        this.versionBox.add("2c", 1);
        this.versionBox.select(1);
        this.buttonAuto = new Button((Composite)groupAuto, 131080);
        this.buttonAuto.setText(" Find ");
        gridData = new GridData();
        gridData.horizontalIndent = 30;
        this.buttonAuto.setLayoutData((Object)gridData);
        this.buttonAuto.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    int portnum = Integer.parseInt(NodeCreateDialog.this.portBox.getText());
                    if (NodeCreateDialog.this.ipAddressBox.getText().matches("^[0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+") && portnum <= 65536) {
                        Hashtable<String, Object> pollingData = new Hashtable<String, Object>();
                        pollingData.put("IPAddress", NodeCreateDialog.this.ipAddressBox.getText());
                        pollingData.put("port", NodeCreateDialog.this.portBox.getText());
                        pollingData.put("community", NodeCreateDialog.this.communityBox.getText());
                        pollingData.put("version", new Integer(NodeCreateDialog.this.versionBox.getSelectionIndex()));
                        Property propertySNMP = null;
                        GetNodePropertyBySNMP poller = new GetNodePropertyBySNMP();
                        propertySNMP = NodeCreateDialog.this.isModifyDialog ? poller.search(pollingData, 1) : poller.search(pollingData, 0);
                        NodeCreateDialog.this.propertySheet.setInput(propertySNMP);
                        NodeCreateDialog.this.propertySheet.expandToLevel(1);
                        Object element = NodeCreateDialog.this.propertySheet.getElementAt(3);
                        NodeCreateDialog.this.propertySheet.expandToLevel(element, 2);
                        element = NodeCreateDialog.this.propertySheet.getElementAt(4);
                        NodeCreateDialog.this.propertySheet.expandToLevel(element, 2);
                    } else {
                        MessageDialog.openWarning((Shell)NodeCreateDialog.this.getShell(), (String)"Warning", (String)"The input is invalid.");
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    MessageDialog.openWarning((Shell)NodeCreateDialog.this.getShell(), (String)"Warning", (String)"The input is invalid.");
                }
            }
        });
        this.radioCreateTypeScope = new Button((Composite)group, 16);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        this.radioCreateTypeScope.setLayoutData((Object)gridData);
        this.radioCreateTypeScope.setText(Messages.getString((String)"registration.method.scope.base"));
        Composite composite = new Composite((Composite)group, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.type = 256;
        composite.setLayout((Layout)rowLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        composite.setLayoutData((Object)gridData);
        Label dummy = new Label(composite, 0);
        dummy.setLayoutData((Object)new RowData(12, 15));
        this.textScope = new Text(composite, 18440);
        this.textScope.setText("");
        this.textScope.setLayoutData((Object)new RowData(300, 15));
        this.buttonScope = new Button(composite, 8);
        this.buttonScope.setText(Messages.getString((String)"refer"));
        this.buttonScope.pack();
        if (!this.isModifyDialog) {
            this.buttonScope.setEnabled(false);
        }
        this.buttonScope.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScopeTreeDialog dialog = new ScopeTreeDialog(NodeCreateDialog.this.getParentShell(), true);
                if (dialog.open() == 0) {
                    FacilityTreeItem selectItem = dialog.getSelectItem();
                    if (selectItem.getData().getType() == 2) {
                        NodeCreateDialog.this.textScope.setText("");
                        NodeCreateDialog.this.scopeId = "";
                    } else {
                        FacilityPath facilityPath = new FacilityPath(ClusterControlPlugin.getDefault().getSeparator());
                        NodeCreateDialog.this.textScope.setText(facilityPath.getPath(selectItem));
                        NodeCreateDialog.this.scopeId = selectItem.getData().getFacilityId();
                    }
                }
            }
        });
        this.radioCreateTypeNode.setSelection(true);
        this.textScope.setEnabled(false);
        this.buttonScope.setEnabled(false);
        this.radioCreateTypeNode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NodeCreateDialog.this.textScope.setEnabled(false);
                NodeCreateDialog.this.buttonScope.setEnabled(false);
            }
        });
        this.radioCreateTypeScope.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NodeCreateDialog.this.textScope.setEnabled(true);
                NodeCreateDialog.this.buttonScope.setEnabled(true);
            }
        });
        if (!this.isModifyDialog) {
            this.radioCreateTypeScope.setEnabled(false);
        } else {
            this.ipAddressBox.setText("           ");
            this.communityBox.setText("      ");
            this.portBox.setText("   ");
            this.versionBox.select(0);
            this.ipAddressBox.setEnabled(false);
            this.communityBox.setEnabled(false);
            this.portBox.setEnabled(false);
            this.versionBox.setEnabled(false);
            this.buttonAuto.setEnabled(false);
        }
        Label label = new Label(parent, 16384);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"attribute")) + " : ");
        TableTree table = new TableTree(parent, 68354);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        table.setLayoutData((Object)gridData);
        this.propertySheet = new PropertySheet(table);
        this.propertySheet.setCopy(true);
        Property property = null;
        property = this.isModifyDialog ? new GetNodeProperty().getProperty(this.facilityId, 1) : new GetNodeProperty().getProperty(this.facilityId, 0);
        this.propertySheet.setInput(property);
        this.propertySheet.expandToLevel(1);
        Object element = this.propertySheet.getElementAt(3);
        this.propertySheet.expandToLevel(element, 2);
        element = this.propertySheet.getElementAt(4);
        this.propertySheet.expandToLevel(element, 2);
        Label line = new Label(parent, 258);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        line.setLayoutData((Object)gridData);
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2, (display.getBounds().height - shell.getSize().y) / 2);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 11, Messages.getString((String)"clear"), false);
        this.getButton(11).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Property property = null;
                if (NodeCreateDialog.this.isModifyDialog()) {
                    property = new GetNodeProperty().getProperty(null, 1);
                    ArrayList list = PropertyUtil.getProperty((Property)property, (String)"facilityId");
                    ((Property)list.get(0)).setValue((Object)NodeCreateDialog.this.getFacilityId());
                } else {
                    property = new GetNodeProperty().getProperty(null, 0);
                }
                PropertyUtil.setPropertyValue((Property)property, (String)"com.clustercontrol.composite.BooleanPropertyDefine", null);
                NodeCreateDialog.this.setInputData(property);
                NodeCreateDialog.this.isClearDone = true;
            }
        });
        super.createButtonsForButtonBar(parent);
    }

    protected ValidateResult validate() {
        ValidateResult result = null;
        this.isNodeSelected = this.radioCreateTypeNode.getSelection();
        if (this.isNodeSelected) {
            ArrayList values = PropertyUtil.getPropertyValue((Property)this.getInputData(), (String)"facilityId");
            String value = (String)values.get(0);
            if (value.compareTo("") == 0) {
                result = new ValidateResult();
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.repository.21"));
                result.setValid(false);
                return result;
            }
            values = PropertyUtil.getPropertyValue((Property)this.getInputData(), (String)"facilityName");
            value = (String)values.get(0);
            if (value.compareTo("") == 0) {
                result = new ValidateResult();
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.repository.22"));
                result.setValid(false);
                return result;
            }
            values = PropertyUtil.getPropertyValue((Property)this.getInputData(), (String)"nodeName");
            value = (String)values.get(0);
            if (value.compareTo("") == 0) {
                result = new ValidateResult();
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.repository.23"));
                result.setValid(false);
                return result;
            }
            values = PropertyUtil.getPropertyValue((Property)this.getInputData(), (String)"deviceName");
            Iterator itr = values.iterator();
            while (itr.hasNext()) {
                String judg_str = itr.next().toString();
                if (judg_str.matches(".*[\\\\/;,<>+\"]+.*")) {
                    result = new ValidateResult();
                    result.setID(Messages.getString((String)"message.hinemos.1"));
                    result.setMessage(Messages.getString((String)"message.repository.29"));
                    result.setValid(false);
                    return result;
                }
                if (!judg_str.matches("#.*")) continue;
                result = new ValidateResult();
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.repository.30"));
                result.setValid(false);
                return result;
            }
            values = PropertyUtil.getPropertyValue((Property)this.getInputData(), (String)"fileSystemIndex");
            itr = values.iterator();
            ArrayList values2 = PropertyUtil.getPropertyValue((Property)this.getInputData(), (String)"fileSystemMountPoint");
            Iterator itr2 = values2.iterator();
            while (itr.hasNext()) {
                String fileSystemIndex = itr.next().toString();
                String fileSystemMountPoint = itr2.hasNext() ? itr2.next().toString() : "";
                if (fileSystemIndex.compareTo("") == 0 || fileSystemMountPoint.compareTo("") != 0) continue;
                Object[] args = new String[]{fileSystemIndex};
                result = new ValidateResult();
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.repository.31", (Object[])args));
                result.setValid(false);
                return result;
            }
        } else if (this.scopeId.compareTo("") == 0) {
            result = new ValidateResult();
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"message.hinemos.3"));
            result.setValid(false);
            return result;
        }
        return result;
    }

    protected boolean action() {
        boolean result = false;
        Property property = this.getInputData();
        if (property != null) {
            if (!this.isModifyDialog()) {
                result = new AddNodeProperty().add(property);
            } else if (this.isNodeSelected()) {
                result = new ModifyNodeProperty().edit(property);
            } else {
                boolean done = false;
                if (this.isClearDone()) {
                    done = true;
                } else if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)Messages.getString((String)"message.repository.20"))) {
                    done = true;
                }
                if (done) {
                    result = new ModifyNodeProperty().editAllInScope(property, this.getScopeId());
                }
            }
        }
        return result;
    }

    public boolean isModifyDialog() {
        return this.isModifyDialog;
    }

    public boolean isNodeSelected() {
        return this.isNodeSelected;
    }

    public String getScopeId() {
        return this.scopeId;
    }

    public boolean isClearDone() {
        return this.isClearDone;
    }

    public Property getInputData() {
        return (Property)this.propertySheet.getInput();
    }

    public void setInputData(Property property) {
        this.propertySheet.setInput(property);
    }

    public String getFacilityId() {
        return this.facilityId;
    }

    protected String getOkButtonText() {
        if (this.isModifyDialog()) {
            return Messages.getString((String)"modify");
        }
        return Messages.getString((String)"register");
    }

    protected String getCancelButtonText() {
        return Messages.getString((String)"cancel");
    }
}

