/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.calendar.composite;

import com.clustercontrol.calendar.action.GetWeekdayInfoList;
import com.clustercontrol.calendar.action.GetWeekdayInfoListTableDefine;
import com.clustercontrol.composite.CommonTableViewer;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class WeekdayInfoListComposite
extends Composite {
    protected CommonTableViewer m_viewer = null;
    protected String m_calendarId = null;
    protected Label m_labelId = null;
    protected Label m_labelCount = null;

    public WeekdayInfoListComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.m_labelId = new Label((Composite)this, 16384);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.m_labelId.setLayoutData((Object)gridData);
        Table table = new Table((Composite)this, 66308);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        table.setLayoutData((Object)gridData);
        this.m_labelCount = new Label((Composite)this, 131072);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.m_labelCount.setLayoutData((Object)gridData);
        this.m_viewer = new CommonTableViewer(table);
        this.m_viewer.createTableColumn(GetWeekdayInfoListTableDefine.get(), 0, 1);
    }

    public void update(String calendarId) {
        this.m_calendarId = calendarId;
        ArrayList info = null;
        GetWeekdayInfoList getWeekdayInfoList = new GetWeekdayInfoList();
        info = getWeekdayInfoList.get(calendarId);
        if (info == null) {
            info = new ArrayList();
        }
        this.m_viewer.setInput(info);
        if (calendarId != null && calendarId.length() > 0) {
            this.m_labelId.setText(String.valueOf(Messages.getString("calendar.id")) + " : " + calendarId);
        } else {
            this.m_labelId.setText(String.valueOf(Messages.getString("calendar.id")) + " : ");
        }
        Object[] args = new Object[]{new Integer(info.size())};
        this.m_labelCount.setText(Messages.getString("records", args));
    }

    public TableViewer getTableViewer() {
        return this.m_viewer;
    }

    public Table getTable() {
        return this.m_viewer.getTable();
    }

    public String getCalendarId() {
        return this.m_calendarId;
    }
}

