/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.run.composite;

import com.clustercontrol.composite.StringVerifyListener;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.util.Messages;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class MonitorBasicComposite
extends Composite {
    public static final int WIDTH_TITLE = 5;
    public static final int WIDTH_VALUE = 2;
    private Text m_textMonitorId = null;
    private Text m_textDescription = null;

    public MonitorBasicComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        Label label = null;
        GridData gridData = null;
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 15;
        this.setLayout((Layout)layout);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString("monitor.id")) + " : ");
        this.m_textMonitorId = new Text((Composite)this, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textMonitorId.addVerifyListener((VerifyListener)new StringVerifyListener(64));
        this.m_textMonitorId.setLayoutData((Object)gridData);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString("description")) + " : ");
        this.m_textDescription = new Text((Composite)this, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textDescription.addVerifyListener((VerifyListener)new StringVerifyListener(256));
        this.m_textDescription.setLayoutData((Object)gridData);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
    }

    public void setInputData(MonitorInfo info) {
        if (info != null) {
            if (info.getMonitorId() != null) {
                this.m_textMonitorId.setText(info.getMonitorId());
                this.m_textMonitorId.setEnabled(false);
            }
            if (info.getDescription() != null) {
                this.m_textDescription.setText(info.getDescription());
            }
        }
    }

    public ValidateResult createInputData(MonitorInfo info) {
        if (info != null) {
            if (this.m_textMonitorId.getText() == null || "".equals(this.m_textMonitorId.getText().trim())) {
                return this.setValidateResult(Messages.getString("message.hinemos.1"), Messages.getString("message.monitor.1"));
            }
            info.setMonitorId(this.m_textMonitorId.getText());
            if (this.m_textDescription.getText() != null && !"".equals(this.m_textDescription.getText().trim())) {
                info.setDescription(this.m_textDescription.getText());
            }
        }
        return null;
    }

    public void setEnabled(boolean enabled) {
        this.m_textMonitorId.setEnabled(enabled);
        this.m_textDescription.setEnabled(enabled);
    }

    protected ValidateResult setValidateResult(String id, String message) {
        ValidateResult validateResult = new ValidateResult();
        validateResult.setValid(false);
        validateResult.setID(id);
        validateResult.setMessage(message);
        return validateResult;
    }
}

