/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.xdoclet.core.ui;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jboss.ide.eclipse.xdoclet.core.XDocletCoreMessages;
import org.jboss.ide.eclipse.xdoclet.core.XDocletCorePlugin;

public class MainPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button version32Button;
    private Button version40Button;

    public MainPreferencePage() {
        this.setDescription(XDocletCoreMessages.getString("MainPreferencePage.description"));
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout(1, true));
        Group group = new Group(top, 0);
        group.setLayoutData((Object)new GridData(768));
        group.setText(XDocletCoreMessages.getString("MainPreferencePage.group.jboss.net.version"));
        group.setLayout((Layout)new GridLayout(1, true));
        this.version40Button = new Button((Composite)group, 16);
        this.version40Button.setText(XDocletCoreMessages.getString("MainPreferencePage.button.version40"));
        this.version32Button = new Button((Composite)group, 16);
        this.version32Button.setText(XDocletCoreMessages.getString("MainPreferencePage.button.version32"));
        Button refreshButton = new Button(top, 0x1000000);
        refreshButton.setLayoutData((Object)new GridData(768));
        refreshButton.setText(XDocletCoreMessages.getString("MainPreferencePage.button.refresh.modules"));
        refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XDocletCorePlugin.getDefault().refreshModules();
            }
        });
        this.setDefaults();
        return top;
    }

    public boolean performOk() {
        String version = this.version32Button.getSelection() ? "3.2" : "4.0";
        XDocletCorePlugin plugin = XDocletCorePlugin.getDefault();
        if (!plugin.getJBossNetVersion().equals(version)) {
            plugin.setJBossNetVersion(version);
            plugin.refreshModules();
        }
        return super.performOk();
    }

    protected void performDefaults() {
        this.setDefaults();
        super.performDefaults();
    }

    private void setDefaults() {
        String version = XDocletCorePlugin.getDefault().getJBossNetVersion();
        this.version32Button.setSelection("3.2".equals(version));
        this.version40Button.setSelection("4.0".equals(version));
    }
}

