/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.draw;

import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.export.draw.ElementDrawer;

public class RectangleDrawer
extends ElementDrawer {
    public void draw(Graphics2D grx, JRPrintElement element, int offsetX, int offsetY) {
        JRPrintRectangle rectangle = (JRPrintRectangle)element;
        if (rectangle.getMode() == 1) {
            grx.setColor(rectangle.getBackcolor());
            if (rectangle.getRadius() > 0) {
                grx.fillRoundRect(rectangle.getX() + offsetX, rectangle.getY() + offsetY, rectangle.getWidth(), rectangle.getHeight(), 2 * rectangle.getRadius(), 2 * rectangle.getRadius());
            } else {
                grx.fillRect(rectangle.getX() + offsetX, rectangle.getY() + offsetY, rectangle.getWidth(), rectangle.getHeight());
            }
        }
        grx.setColor(rectangle.getForecolor());
        byte pen = rectangle.getPen();
        Stroke stroke = RectangleDrawer.getStroke(pen);
        if (stroke != null) {
            double cornerOffset = RectangleDrawer.getBorderCornerOffset(pen);
            int sizeAdjust = RectangleDrawer.getRectangleSizeAdjust(pen);
            AffineTransform transform = grx.getTransform();
            grx.translate((double)(rectangle.getX() + offsetX) + cornerOffset, (double)(rectangle.getY() + offsetY) + cornerOffset);
            if (pen == 5) {
                grx.scale(((double)rectangle.getWidth() - 0.5) / (double)rectangle.getWidth(), ((double)rectangle.getHeight() - 0.5) / (double)rectangle.getHeight());
            }
            grx.setStroke(stroke);
            if (rectangle.getRadius() > 0) {
                grx.drawRoundRect(0, 0, rectangle.getWidth() - sizeAdjust, rectangle.getHeight() - sizeAdjust, 2 * rectangle.getRadius(), 2 * rectangle.getRadius());
            } else {
                grx.drawRect(0, 0, rectangle.getWidth() - sizeAdjust, rectangle.getHeight() - sizeAdjust);
            }
            grx.setTransform(transform);
        }
    }
}

