/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.proxy;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import org.jboss.invocation.Invocation;
import org.jboss.proxy.Interceptor;
import org.jboss.security.SecurityAssociation;

public class SecurityInterceptor
extends Interceptor {
    private static final long serialVersionUID = -4206940878404525061L;

    public Object invoke(Invocation invocation) throws Throwable {
        Object credential;
        SecurityActions sa = SecurityActions.UTIL.getSecurityActions();
        Principal principal = sa.getPrincipal();
        if (principal != null) {
            invocation.setPrincipal(principal);
        }
        if ((credential = sa.getCredential()) != null) {
            invocation.setCredential(credential);
        }
        return this.getNext().invoke(invocation);
    }

    static interface SecurityActions {
        public static final SecurityActions NON_PRIVILEGED = new SecurityActions(){

            public Principal getPrincipal() {
                return SecurityAssociation.getPrincipal();
            }

            public Object getCredential() {
                return SecurityAssociation.getCredential();
            }
        };
        public static final SecurityActions PRIVILEGED = new SecurityActions(){
            private final PrivilegedAction getPrincipalAction = new PrivilegedAction(){

                public Object run() {
                    return SecurityAssociation.getPrincipal();
                }
            };
            private final PrivilegedAction getCredentialAction = new PrivilegedAction(){

                public Object run() {
                    return SecurityAssociation.getCredential();
                }
            };

            public Principal getPrincipal() {
                return (Principal)AccessController.doPrivileged(this.getPrincipalAction);
            }

            public Object getCredential() {
                return AccessController.doPrivileged(this.getCredentialAction);
            }
        };

        public Principal getPrincipal();

        public Object getCredential();

        public static class UTIL {
            static SecurityActions getSecurityActions() {
                return System.getSecurityManager() == null ? NON_PRIVILEGED : PRIVILEGED;
            }
        }
    }
}

