/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.network;

import javax.management.Notification;
import javax.management.ObjectName;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.detection.ServerInvokerMetadata;
import org.jboss.remoting.ident.Identity;

public class NetworkNotification
extends Notification {
    static final long serialVersionUID = 987487760197074685L;
    public static final String SERVER_ADDED = "jboss.network.server.added";
    public static final String SERVER_UPDATED = "jboss.network.server.updated";
    public static final String SERVER_REMOVED = "jboss.network.server.removed";
    public static final String DOMAIN_CHANGED = "jboss.network.domain.changed";
    private final Identity identity;
    private final ServerInvokerMetadata[] serverInvokers;
    private final InvokerLocator[] locators;

    public NetworkNotification(ObjectName source, String type, Identity identity, ServerInvokerMetadata[] serverInvokers) {
        super(type, source, System.currentTimeMillis());
        this.identity = identity;
        this.serverInvokers = serverInvokers;
        this.locators = null;
    }

    public NetworkNotification(ObjectName source, String type, Identity identity, InvokerLocator[] locators) {
        super(type, source, System.currentTimeMillis());
        this.identity = identity;
        this.serverInvokers = null;
        this.locators = locators;
    }

    public final Identity getIdentity() {
        return this.identity;
    }

    public final InvokerLocator[] getLocator() {
        if (this.locators != null) {
            return this.locators;
        }
        InvokerLocator[] locators = new InvokerLocator[this.serverInvokers.length];
        for (int x = 0; x < this.serverInvokers.length; ++x) {
            locators[x] = this.serverInvokers[x].getInvokerLocator();
        }
        return locators;
    }

    public final ServerInvokerMetadata[] getServerInvokers() {
        return this.serverInvokers;
    }
}

