/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.spi.LoginModule;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityAssociation;

public class RunAsLoginModule
implements LoginModule {
    private String roleName;
    private String principalName;
    private boolean pushedRole;

    public void initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options) {
        this.roleName = (String)options.get("roleName");
        if (this.roleName == null) {
            this.roleName = "nobody";
        }
        this.principalName = (String)options.get("principalName");
        if (this.principalName == null) {
            this.principalName = "nobody";
        }
    }

    public boolean login() {
        RunAsIdentity runAsRole = new RunAsIdentity(this.roleName, this.principalName);
        SecurityAssociation.pushRunAsIdentity(runAsRole);
        this.pushedRole = true;
        return true;
    }

    public boolean commit() {
        return this.abort();
    }

    public boolean abort() {
        if (!this.pushedRole) {
            return false;
        }
        SecurityAssociation.popRunAsIdentity();
        return true;
    }

    public boolean logout() {
        return true;
    }
}

