/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.jce;

import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.jboss.security.jce.JCEProviderServiceMBean;
import org.jboss.system.ServiceMBeanSupport;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JCEProviderService
extends ServiceMBeanSupport
implements JCEProviderServiceMBean {
    private ArrayList addedProviders = new ArrayList();
    private Element providers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJceProviders(Element element) {
        this.providers = element;
        if (this.getState() != 7) {
            Class clazz = JCEProviderService.class;
            synchronized (clazz) {
                this.removeProviders();
                this.loadProviders();
            }
        }
    }

    public Element getJceProviders() {
        return this.providers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createService() throws Exception {
        Class clazz = JCEProviderService.class;
        synchronized (clazz) {
            this.loadProviders();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyService() {
        Class clazz = JCEProviderService.class;
        synchronized (clazz) {
            this.removeProviders();
        }
    }

    private void loadProviders() {
        int n = 0;
        if (this.providers != null) {
            this.addedProviders = new ArrayList();
            NodeList reqdProviders = this.providers.getElementsByTagName("provider");
            n = reqdProviders.getLength();
            for (int i = 0; i < n; ++i) {
                Node reqdProvider = reqdProviders.item(i);
                int requestedPosition = 0;
                if (1 == reqdProvider.getNodeType()) {
                    int pos;
                    Provider provider;
                    Element prov = (Element)reqdProvider;
                    if (!prov.hasAttribute("class")) {
                        this.log.warn((Object)("A provider element must, at the very least, have a class attribute: " + prov));
                        continue;
                    }
                    String providerClass = prov.getAttribute("class");
                    try {
                        provider = (Provider)Class.forName(providerClass).newInstance();
                    }
                    catch (InstantiationException e1) {
                        this.log.warn((Object)("Unable to instantiate an instance of the JCE Provider class " + providerClass), (Throwable)e1);
                        continue;
                    }
                    catch (IllegalAccessException e1) {
                        this.log.warn((Object)("No permission to access the JCE Provider class " + providerClass), (Throwable)e1);
                        continue;
                    }
                    catch (ClassNotFoundException e1) {
                        this.log.warn((Object)("Could not find the JCE Provider class " + providerClass), (Throwable)e1);
                        continue;
                    }
                    catch (ClassCastException e1) {
                        this.log.warn((Object)("The Class " + providerClass + " is not a java.security.Provider"));
                        continue;
                    }
                    String providerName = provider.getName();
                    if (prov.hasAttribute("position")) {
                        try {
                            requestedPosition = Integer.parseInt(prov.getAttribute("position"));
                        }
                        catch (NumberFormatException e) {
                            this.log.warn((Object)("the position '" + prov.getAttribute("position") + "' is not a valid number. This provider has to go to the end of the line. " + prov));
                        }
                    }
                    if ((pos = requestedPosition < 1 ? Security.addProvider(provider) : Security.insertProviderAt(provider, requestedPosition)) == -1) {
                        int exPos = Arrays.asList(Security.getProviders()).indexOf(provider);
                        this.log.info((Object)("The provider " + providerName + " already exists at position " + exPos));
                        continue;
                    }
                    if (requestedPosition >= 1 && pos != requestedPosition) {
                        this.log.info((Object)("The position " + requestedPosition + " was requested for Provider " + providerName + " but it was added at position " + pos));
                        this.addedProviders.add(providerName);
                        continue;
                    }
                    this.log.info((Object)("The Provider " + providerName + " was added at position " + pos));
                    this.addedProviders.add(providerName);
                    continue;
                }
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("Ignoring node" + reqdProvider));
            }
            if (this.addedProviders.size() == 1) {
                this.log.info((Object)(this.addedProviders.size() + " JCE Provider was actually loaded."));
            } else {
                this.log.info((Object)(this.addedProviders.size() + " JCE Providers were actually loaded."));
            }
        }
        if (n < 1) {
            this.log.info((Object)"No JCE Providers were requested.");
        }
    }

    private void removeProviders() {
        Iterator iter = this.addedProviders.iterator();
        while (iter.hasNext()) {
            String providerName = (String)iter.next();
            try {
                Security.removeProvider(providerName);
            }
            catch (Exception e) {
                this.log.warn((Object)("Failed to remove Provider " + providerName));
            }
        }
    }
}

