/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.core;

import java.io.IOException;
import org.postgresforest.core.PGStream;

public class StartupPacket {
    private static final int SM_DATABASE = 64;
    private static final int SM_USER = 32;
    private static final int SM_OPTIONS = 64;
    private static final int SM_UNUSED = 64;
    private static final int SM_TTY = 64;
    private int protocolMajor;
    private int protocolMinor;
    private String user;
    private String database;

    public StartupPacket(int protocolMajor, int protocolMinor, String user, String database) {
        this.protocolMajor = protocolMajor;
        this.protocolMinor = protocolMinor;
        this.user = user;
        this.database = database;
    }

    public void writeTo(PGStream stream) throws IOException {
        if (this.protocolMajor == 3) {
            this.v3WriteTo(stream);
        } else {
            this.v2WriteTo(stream);
        }
    }

    public void v3WriteTo(PGStream stream) throws IOException {
        stream.SendInteger(8 + "user".length() + 1 + this.user.length() + 1 + "database".length() + 1 + this.database.length() + 1 + 1, 4);
        stream.SendInteger(this.protocolMajor, 2);
        stream.SendInteger(this.protocolMinor, 2);
        stream.Send("user".getBytes());
        stream.SendChar(0);
        stream.Send(this.user.getBytes());
        stream.SendChar(0);
        stream.Send("database".getBytes());
        stream.SendChar(0);
        stream.Send(this.database.getBytes());
        stream.SendChar(0);
        stream.SendChar(0);
    }

    public void v2WriteTo(PGStream stream) throws IOException {
        stream.SendInteger(296, 4);
        stream.SendInteger(this.protocolMajor, 2);
        stream.SendInteger(this.protocolMinor, 2);
        stream.Send(this.database.getBytes(), 64);
        stream.Send(this.user.getBytes(), 224);
    }
}

